/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-31 14:04:30 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`),
  KEY `idx_wp_users_user_login` (`user_login`),
  KEY `idx_wp_users_user_nicename` (`user_nicename`),
  KEY `idx_wp_users_user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=236 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4910 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=23967 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `idx_wp_commentmeta_comment_id` (`comment_id`),
  KEY `idx_wp_commentmeta_meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `idx_wp_comments_comment_post_ID` (`comment_post_ID`),
  KEY `idx_wp_comments_comment_approved` (`comment_approved`),
  KEY `idx_wp_comments_comment_author_email` (`comment_author_email`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `owner` varchar(60) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`(250))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ewwwio_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) DEFAULT NULL,
  `resize` varchar(75) DEFAULT NULL,
  `path` text NOT NULL,
  `converted` text NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `backup` varchar(100) DEFAULT NULL,
  `level` int(10) unsigned DEFAULT NULL,
  `pending` tinyint(4) NOT NULL DEFAULT 0,
  `updates` int(10) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `trace` blob DEFAULT NULL,
  `retrieve` varchar(100) DEFAULT NULL,
  `resized_width` smallint(5) unsigned DEFAULT NULL,
  `resized_height` smallint(5) unsigned DEFAULT NULL,
  `resize_error` tinyint(3) unsigned DEFAULT NULL,
  `webp_size` int(10) unsigned DEFAULT NULL,
  `webp_error` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`(191)),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1455 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ewwwio_queue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(20) DEFAULT NULL,
  `scanned` tinyint(4) NOT NULL DEFAULT 0,
  `new` tinyint(4) NOT NULL DEFAULT 0,
  `convert_once` tinyint(4) NOT NULL DEFAULT 0,
  `force_reopt` tinyint(4) NOT NULL DEFAULT 0,
  `force_smart` tinyint(4) NOT NULL DEFAULT 0,
  `webp_only` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1513 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) NOT NULL,
  `event_id` varchar(100) NOT NULL,
  `event_payload` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`),
  KEY `idx_option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=52445 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `idx_wp_postmeta_post_id` (`post_id`),
  KEY `idx_wp_postmeta_meta_key_meta_value` (`meta_key`(191),`meta_value`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22018 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `idx_wp_posts_id` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_404_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint(20) unsigned NOT NULL DEFAULT 1,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_analytics_gsc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `query` varchar(1000) NOT NULL,
  `page` varchar(500) NOT NULL,
  `clicks` mediumint(6) NOT NULL,
  `impressions` mediumint(6) NOT NULL,
  `position` double NOT NULL,
  `ctr` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_query` (`query`(190)),
  KEY `analytics_page` (`page`(190)),
  KEY `clicks` (`clicks`),
  KEY `rank_position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_analytics_inspections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page` varchar(500) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `index_verdict` varchar(64) NOT NULL,
  `indexing_state` varchar(64) NOT NULL,
  `coverage_state` text NOT NULL,
  `page_fetch_state` varchar(64) NOT NULL,
  `robots_txt_state` varchar(64) NOT NULL,
  `rich_results_verdict` varchar(64) NOT NULL,
  `rich_results_items` longtext NOT NULL,
  `last_crawl_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `crawled_as` varchar(64) NOT NULL,
  `google_canonical` text NOT NULL,
  `user_canonical` text NOT NULL,
  `sitemap` text NOT NULL,
  `referring_urls` longtext NOT NULL,
  `raw_api_response` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190)),
  KEY `created` (`created`),
  KEY `index_verdict` (`index_verdict`),
  KEY `page_fetch_state` (`page_fetch_state`),
  KEY `robots_txt_state` (`robots_txt_state`),
  KEY `rich_results_verdict` (`rich_results_verdict`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_analytics_keyword_manager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(1000) NOT NULL,
  `collection` varchar(200) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` longtext NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `idx_wp_termmeta_term_id` (`term_id`),
  KEY `idx_wp_termmeta_meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=392 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`),
  KEY `idx_wp_term_relationships_term_taxonomy_id` (`term_taxonomy_id`),
  KEY `idx_wp_term_relationships_object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`),
  KEY `idx_wp_term_taxonomy_term_taxonomy_id` (`term_taxonomy_id`),
  KEY `idx_wp_term_taxonomy_taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wacv_abandoned_cart_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `abandoned_cart_info` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `abandoned_cart_time` int(11) NOT NULL,
  `current_lang` text DEFAULT NULL,
  `cart_ignored` enum('0','1') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `recovered_cart` int(11) NOT NULL,
  `recovered_cart_time` int(11) NOT NULL,
  `order_type` enum('0','1') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_type` text DEFAULT NULL,
  `unsubscribe_link` enum('0','1') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `session_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `send_mail_time` int(11) DEFAULT NULL,
  `number_of_mailing` int(3) NOT NULL,
  `email_complete` enum('0','1') DEFAULT NULL,
  `messenger_sent` int(3) NOT NULL,
  `messenger_complete` enum('0','1') DEFAULT NULL,
  `sms_sent` int(3) NOT NULL,
  `sms_complete` enum('0','1') DEFAULT NULL,
  `valid_phone` int(3) NOT NULL,
  `whatsapp_complete` enum('0','1') DEFAULT NULL,
  `whatsapp_sent` int(3) NOT NULL,
  `customer_ip` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `os_platform` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `browser` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wacv_cart_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `time_log` int(11) DEFAULT NULL,
  `ip` tinytext NOT NULL,
  `os_platform` tinytext NOT NULL,
  `browser` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wacv_email_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `billing_email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `template_id` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `acr_id` int(11) NOT NULL,
  `sent_time` int(11) NOT NULL,
  `clicked` int(11) DEFAULT NULL,
  `opened` int(11) DEFAULT NULL,
  `coupon` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sent_email_id` tinytext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wacv_guest_info_record` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `user_ref` text DEFAULT NULL,
  `input_date` int(11) DEFAULT NULL,
  `billing_first_name` text DEFAULT NULL,
  `billing_last_name` text DEFAULT NULL,
  `billing_company` text DEFAULT NULL,
  `billing_address_1` text DEFAULT NULL,
  `billing_address_2` text DEFAULT NULL,
  `billing_city` text DEFAULT NULL,
  `billing_country` text DEFAULT NULL,
  `billing_state` text DEFAULT NULL,
  `billing_postcode` text DEFAULT NULL,
  `billing_email` text DEFAULT NULL,
  `billing_phone` text DEFAULT NULL,
  `ship_to_billing` text DEFAULT NULL,
  `order_notes` text DEFAULT NULL,
  `shipping_first_name` text DEFAULT NULL,
  `shipping_last_name` text DEFAULT NULL,
  `shipping_company` text DEFAULT NULL,
  `shipping_address_1` text DEFAULT NULL,
  `shipping_address_2` text DEFAULT NULL,
  `shipping_city` text DEFAULT NULL,
  `shipping_country` text DEFAULT NULL,
  `shipping_state` text DEFAULT NULL,
  `shipping_postcode` double DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100000000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=39898 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32)),
  KEY `idx_order_item_id` (`order_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `idx_order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=701 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","depozitul","$wp$2y$10$5yzGUrDCEEjeY..6Wfw3NOe4JlKwGX/9r/75hYPHSEe/zgvmSKxuW","depozitul","demo@depozitul-de-magazine.ro","https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse","2024-01-10 20:49:22","","0","depozitul"),
("2","irina","$wp$2y$10$pmx7ueJdfW9tG1zACyXcdOS5BLehFF.77EWqIvqm1kVchQ5.TKtO2","irina","irina-dmin@depozitul-de-magazine.ro","","0000-00-00 00:00:00","","0","Irina");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","depozitul"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","false"),
("11","1","locale","ro_RO"),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","1"),
("17","1","wp_user-settings","libraryContent=browse&editor=tinymce&posts_list_mode=list"),
("18","1","wp_user-settings-time","1709039018"),
("19","1","wp_dashboard_quick_press_last_post_id","4453"),
("20","1","community-events-location","a:1:{s:2:\"ip\";s:19:\"2a01:e0a:b07:a650::\";}"),
("21","1","_woocommerce_tracks_anon_id","woo:EMzXz9GyYLlzpLVjvUhgtTzh"),
("22","1","wc_last_active","1761868800"),
("23","1","billing_first_name",""),
("24","1","billing_last_name",""),
("25","1","billing_company",""),
("26","1","billing_address_1",""),
("27","1","billing_address_2",""),
("28","1","billing_city",""),
("29","1","billing_postcode",""),
("30","1","billing_country",""),
("31","1","billing_state",""),
("32","1","billing_phone",""),
("33","1","billing_email","demo@depozitul-de-magazine.ro"),
("34","1","shipping_first_name",""),
("35","1","shipping_last_name",""),
("36","1","shipping_company",""),
("37","1","shipping_address_1",""),
("38","1","shipping_address_2",""),
("39","1","shipping_city",""),
("40","1","shipping_postcode",""),
("41","1","shipping_country",""),
("42","1","shipping_state",""),
("43","1","shipping_phone",""),
("44","1","last_update","1733749587"),
("46","1","rocketcdn_dismiss_notice","1"),
("49","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("54","1","xstore_wishlist_ids_0",""),
("55","1","xstore_compare_ids_0",""),
("56","1","elementor_admin_notices","a:2:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:7:\"3.25.11\";}}s:31:\"elementor-pro-forms-submissions\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("58","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("59","1","manageedit-postcolumnshidden_default","1"),
("60","1","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("61","1","manageedit-pagecolumnshidden_default","1"),
("62","1","manageedit-e-landing-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("63","1","manageedit-e-landing-pagecolumnshidden_default","1"),
("64","1","manageedit-etheme_slidescolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("65","1","manageedit-etheme_slidescolumnshidden_default","1"),
("66","1","manageedit-staticblockscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("67","1","manageedit-staticblockscolumnshidden_default","1"),
("68","1","manageedit-etheme_portfoliocolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("69","1","manageedit-etheme_portfoliocolumnshidden_default","1"),
("70","1","manageedit-productcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("71","1","manageedit-productcolumnshidden_default","1"),
("72","1","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("73","1","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("74","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("77","2","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("78","2","wp_user_level","10"),
("81","2","xstore_wishlist_ids_0","{\"id\":4160}"),
("82","2","wc_last_active","1761868800"),
("84","2","_woocommerce_tracks_anon_id","woo:DjJPZkH1QYC4L0Affm8kftuH"),
("85","2","wp_dashboard_quick_press_last_post_id","4446"),
("86","2","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:2:{s:32:\"f816dc0acface7498e10496222e9db10\";a:11:{s:3:\"key\";s:32:\"f816dc0acface7498e10496222e9db10\";s:10:\"product_id\";i:4160;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:65;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:65;s:8:\"line_tax\";d:0;}s:32:\"bd22c2ef9e6f0fa97825c6be879f8fa4\";a:11:{s:3:\"key\";s:32:\"bd22c2ef9e6f0fa97825c6be879f8fa4\";s:10:\"product_id\";i:4154;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:55;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:55;s:8:\"line_tax\";d:0;}}}"),
("87","2","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("88","2","manageedit-postcolumnshidden_default","1"),
("89","2","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("90","2","manageedit-pagecolumnshidden_default","1"),
("91","2","manageedit-e-landing-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("92","2","manageedit-e-landing-pagecolumnshidden_default","1"),
("93","2","manageedit-etheme_slidescolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("94","2","manageedit-etheme_slidescolumnshidden_default","1"),
("95","2","manageedit-staticblockscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("96","2","manageedit-staticblockscolumnshidden_default","1"),
("97","2","manageedit-etheme_portfoliocolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("98","2","manageedit-etheme_portfoliocolumnshidden_default","1"),
("99","2","manageedit-productcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("100","2","manageedit-productcolumnshidden_default","1"),
("101","2","community-events-location","a:1:{s:2:\"ip\";s:12:\"86.120.252.0\";}"),
("104","2","manageedit-etheme_mega_menuscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("105","2","manageedit-etheme_mega_menuscolumnshidden_default","1"),
("107","2","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("108","2","manageedit-e-floating-buttonscolumnshidden_default","1"),
("110","1","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("111","1","manageedit-e-floating-buttonscolumnshidden_default","1"),
("112","1","manageedit-etheme_mega_menuscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("113","1","manageedit-etheme_mega_menuscolumnshidden_default","1"),
("118","2","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:7:\"3.25.11\";}}}"),
("119","2","last_update","1733750418"),
("120","2","nickname","irina"),
("121","2","first_name",""),
("122","2","last_name",""),
("123","2","description",""),
("124","2","rich_editing","true"),
("125","2","syntax_highlighting","true"),
("126","2","comment_shortcuts","false"),
("127","2","admin_color","fresh"),
("128","2","use_ssl","0"),
("129","2","show_admin_bar_front","false"),
("130","2","locale","ro_RO"),
("131","2","woocommerce_admin_launch_your_store_tour_hidden","yes"),
("132","2","wp_elementor_enable_ai","1"),
("133","2","billing_first_name",""),
("134","2","billing_last_name",""),
("135","2","billing_company",""),
("136","2","billing_address_1",""),
("137","2","billing_address_2",""),
("138","2","billing_city",""),
("139","2","billing_postcode",""),
("140","2","billing_country",""),
("141","2","billing_state",""),
("142","2","billing_phone",""),
("143","2","billing_email","irina-dmin@depozitul-de-magazine.ro"),
("144","2","shipping_first_name",""),
("145","2","shipping_last_name",""),
("146","2","shipping_company",""),
("147","2","shipping_address_1",""),
("148","2","shipping_address_2",""),
("149","2","shipping_city",""),
("150","2","shipping_postcode",""),
("151","2","shipping_country",""),
("152","2","shipping_state",""),
("153","2","shipping_phone",""),
("154","2","twitter",""),
("155","2","facebook",""),
("156","2","additional_profile_urls",""),
("157","2","wp_user-settings","libraryContent=browse&editor=tinymce"),
("158","2","wp_user-settings-time","1733738703"),
("159","2","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("160","2","meta-box-order_staticblocks","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("161","2","meta-box-order_product","a:3:{s:4:\"side\";s:113:\"submitdiv,rank_math_metabox_content_ai,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("162","2","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("163","2","wp_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-10-22T13:50:12.210Z\";}"),
("164","2","closedpostboxes_product","a:1:{i:0;s:28:\"rank_math_metabox_content_ai\";}"),
("165","2","metaboxhidden_product","a:2:{i:0;s:10:\"postcustom\";i:1;s:7:\"slugdiv\";}"),
("166","2","woocommerce_admin_variable_product_tour_shown","yes"),
("167","2","wbcr_dan_hidden_notices","a:6:{s:65:\"df1e0e5a65f29c58c83017ea36e4f641_1dd88952141e31463a185d9fe14389a5\";s:982:\"<div class=\"cn-notice-container\">\n				<div class=\"cn-notice-text cn-no-compliance\"><h2>Automatic Google Consent Mode support in Cookie Compliance</h2><p>Cookie Compliance integration with Google Consent Mode ensures that your Google Analytics and other services you use through Google Tag Manager tags respond dynamically to user consent status. <b>It requires no technical expertise to set up.</b> When users choose their preferences, Cookie Compliance automatically signals this information to Google services so that cookies are set only if consent is given for each type of data processing.<br>Click \"Run Compliance Check\" to proceed and test other compliance features.</p><p class=\"cn-notice-actions\"><a href=\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-admin/admin.php?page=cookie-notice&amp;welcome=1\" class=\"button button-primary cn-button\">Run Compliance Check</a> <a href=\"#\" class=\"button-link cn-notice-dismiss\">Dismiss Notice</a></p></div>\n				</div>\";s:65:\"1454a83fdad0f25ef7a6e66fce6b5964_6726cd42136ae39c90cef7cc3cdcca20\";s:808:\"<p>Hey, we noticed you\'ve been using <strong>Rank Math SEO</strong> for more than a week now – that\'s awesome!<br>Could you please do us a BIG favor and give it a rating on WordPress.org to help us spread the word and boost our motivation?</p>\n<p><strong>Bhanu Ahluwalia</strong><br>Co-founder of Rank Math</p>\n<p>\n				<a href=\"https://wordpress.org/support/plugin/seo-by-rank-math/reviews/?filter=5#new-post\" class=\"rank-math-dismiss-review-notice rank-math-review-action rank-math-review-out\" target=\"_blank\" rel=\"noopener noreferrer\"><strong>Yes, you deserve it</strong></a><br>\n				<a href=\"#\" class=\"rank-math-dismiss-review-notice rank-math-maybe-later-action\">No, maybe later</a><br>\n				<a href=\"#\" class=\"rank-math-dismiss-review-notice rank-math-already-reviewed-action\">I already did</a>\n			</p>\";s:65:\"ba89b62245c2d617dd88e20167dd9c53_2962a9d6b6f25f7f79702bb5fc1d42f5\";s:275:\"<p><strong>Disable Admin Notices Individually:</strong><br>Thanks for using the Disable admin notices plugin! If you need support or all the features of the plugin, please buy the pro version <a class=\"button\" href=\"https://clearfy.pro/disable-admin-notices/\">Get PRO</a></p>\";s:65:\"a7bbed0198d7009c07a8bdd748d6b32d_ee3ee69509bcf5d9d0ad9f97a6837fdc\";s:1037:\"<i class=\"e-notice__dismiss\" role=\"button\" aria-label=\"Înlătură această notificare.\" tabindex=\"0\"></i>			<div class=\"e-notice__aside\">\n				<div class=\"e-notice__icon-wrapper\"><i class=\"eicon-elementor\" aria-hidden=\"true\"></i></div>			</div>\n			<div class=\"e-notice__content\">\n									<h3>Îți place să folosești Elementor?</h3>\n				\n									<p>Become a super contributor by opting in to share non-sensitive plugin data and to receive periodic email updates from us. <a href=\"https://go.elementor.com/usage-data-tracking/\" target=\"_blank\">Află mai multe.</a></p>\n				\n									<div class=\"e-notice__actions\">\n						<a href=\"/wp-admin/edit.php?post_type=staticblocks&amp;elementor_tracker=opt_into&amp;_wpnonce=54890ffad9\" class=\"e-button e-button e-button--cta\"><span>Sigur! Mi-ar plăcea să ajut</span></a><a href=\"/wp-admin/edit.php?post_type=staticblocks&amp;elementor_tracker=opt_out&amp;_wpnonce=52747a1637\" class=\"e-button e-button e-button--cta e-button--outline\"><span>Nu, mulțumesc</span></a>					</div>\n							</div>\";s:65:\"0321101436fb279f58025367ee32a435_c230d8e53d1338cc47af11dfda2e7079\";s:1092:\"<i class=\"e-notice__dismiss\" role=\"button\" aria-label=\"Înlătură această notificare.\" tabindex=\"0\"></i>			<div class=\"e-notice__aside\">\n				<div class=\"e-notice__icon-wrapper\"><i class=\"eicon-elementor\" aria-hidden=\"true\"></i></div>			</div>\n			<div class=\"e-notice__content\">\n									<h3>Form Submissions now activated by default on all websites</h3>\n				\n									<p>The Form Submissions feature, previously located under the Features tab in Elementor, is now enabled by default on all websites. If you prefer to disable this feature, you can do so by navigating to <a href=\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-admin/admin.php?page=elementor-settings#tab-advanced\"><strong>Settings → Advanced</strong></a>.</p>\n				\n									<div class=\"e-notice__actions\">\n						<a href=\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-admin/admin-post.php?action=elementor_set_admin_notice_viewed&amp;notice_id=elementor-pro-forms-submissions\" class=\"e-notice-dismiss e-button e-button--cta\"><span>Got it! Keep it enabled</span></a>					</div>\n							</div>\";s:65:\"51ec794b2e419991e919722738b51f8d_04450503746dbb6fdf02ca4d7b4c1feb\";s:377:\"<h3>Don’t miss out on the new version of Elementor</h3><p>Update to the latest version of Elementor to enjoy new features, better performance and compatibility. <a href=\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-admin/update.php?action=upgrade-plugin&amp;plugin=elementor%2Felementor.php&amp;_wpnonce=7277c4b13b\" class=\"button-primary\">Update Now</a></p>\";}"),
("168","2","nav_menu_recently_edited","249"),
("169","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("170","2","metaboxhidden_nav-menus","a:12:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:31:\"add-post-type-etheme_mega_menus\";i:2;s:27:\"add-post-type-etheme_slides\";i:3;s:26:\"add-post-type-staticblocks\";i:4;s:30:\"add-post-type-etheme_portfolio\";i:5;s:21:\"add-post-type-product\";i:6;s:33:\"add-post-type-wacv_email_template\";i:7;s:12:\"add-post_tag\";i:8;s:15:\"add-post_format\";i:9;s:22:\"add-portfolio_category\";i:10;s:9:\"add-brand\";i:11;s:15:\"add-product_tag\";}"),
("171","2","closedpostboxes_nav-menus","a:0:{}"),
("172","1","wp_elementor_enable_ai","1"),
("173","1","twitter",""),
("174","1","facebook",""),
("175","1","additional_profile_urls",""),
("216","2","xstore_wishlist_u","7DHR35KFONO0"),
("218","2","my-jetpack-cache-date","1729759367"),
("219","2","my-jetpack-wpcom-product-check-hash","a991fedaf269fa1f13fcd9629eb34d9f"),
("220","2","my-jetpack-cache","O:8:\"stdClass\":80:{s:15:\"jetpack_premium\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2000;s:12:\"product_name\";s:15:\"Jetpack Premium\";s:12:\"product_slug\";s:15:\"jetpack_premium\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-premium\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€154.95\";s:21:\"combined_cost_display\";s:9:\"€154.95\";s:4:\"cost\";d:154.95;s:18:\"cost_smallest_unit\";i:15495;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:8:\"€12.91\";}s:16:\"jetpack_business\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2001;s:12:\"product_name\";s:20:\"Jetpack Professional\";s:12:\"product_slug\";s:16:\"jetpack_business\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-business\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€399.95\";s:21:\"combined_cost_display\";s:9:\"€399.95\";s:4:\"cost\";d:399.95;s:18:\"cost_smallest_unit\";i:39995;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:8:\"€33.33\";}s:12:\"jetpack_free\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2002;s:12:\"product_name\";s:12:\"Jetpack Free\";s:12:\"product_slug\";s:12:\"jetpack_free\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:12:\"jetpack-free\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€0.00\";s:21:\"combined_cost_display\";s:4:\"€0\";s:4:\"cost\";i:0;s:18:\"cost_smallest_unit\";i:0;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:8:\"one time\";s:22:\"product_term_localized\";s:8:\"one time\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:23:\"jetpack_premium_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2003;s:12:\"product_name\";s:15:\"Jetpack Premium\";s:12:\"product_slug\";s:23:\"jetpack_premium_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-premium\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:24:\"jetpack_business_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2004;s:12:\"product_name\";s:20:\"Jetpack Professional\";s:12:\"product_slug\";s:24:\"jetpack_business_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-business\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€36.95\";s:21:\"combined_cost_display\";s:8:\"€36.95\";s:4:\"cost\";d:36.95;s:18:\"cost_smallest_unit\";i:3695;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:16:\"jetpack_personal\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2005;s:12:\"product_name\";s:16:\"Jetpack Personal\";s:12:\"product_slug\";s:16:\"jetpack_personal\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-personal\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€72.95\";s:21:\"combined_cost_display\";s:8:\"€72.95\";s:4:\"cost\";d:72.95;s:18:\"cost_smallest_unit\";i:7295;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€6.08\";}s:24:\"jetpack_personal_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2006;s:12:\"product_name\";s:16:\"Jetpack Personal\";s:12:\"product_slug\";s:24:\"jetpack_personal_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-personal\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€6.55\";s:21:\"combined_cost_display\";s:7:\"€6.55\";s:4:\"cost\";d:6.55;s:18:\"cost_smallest_unit\";i:655;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:22:\"jetpack_security_daily\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2010;s:12:\"product_name\";s:22:\"Jetpack Security Daily\";s:12:\"product_slug\";s:22:\"jetpack_security_daily\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:22:\"jetpack-security-daily\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€264.00\";s:21:\"combined_cost_display\";s:6:\"€264\";s:4:\"cost\";i:264;s:18:\"cost_smallest_unit\";i:26400;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";i:132;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:5:\"€22\";}s:30:\"jetpack_security_daily_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2011;s:12:\"product_name\";s:22:\"Jetpack Security Daily\";s:12:\"product_slug\";s:30:\"jetpack_security_daily_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:22:\"jetpack-security-daily\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€22.00\";s:21:\"combined_cost_display\";s:5:\"€22\";s:4:\"cost\";i:22;s:18:\"cost_smallest_unit\";i:2200;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:25:\"jetpack_security_realtime\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2012;s:12:\"product_name\";s:26:\"Jetpack Security Real-time\";s:12:\"product_slug\";s:25:\"jetpack_security_realtime\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:25:\"jetpack-security-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€708.00\";s:21:\"combined_cost_display\";s:6:\"€708\";s:4:\"cost\";i:708;s:18:\"cost_smallest_unit\";i:70800;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";i:354;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:5:\"€59\";}s:33:\"jetpack_security_realtime_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2013;s:12:\"product_name\";s:26:\"Jetpack Security Real-time\";s:12:\"product_slug\";s:33:\"jetpack_security_realtime_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:25:\"jetpack-security-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€59.00\";s:21:\"combined_cost_display\";s:5:\"€59\";s:4:\"cost\";i:59;s:18:\"cost_smallest_unit\";i:5900;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:16:\"jetpack_complete\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2014;s:12:\"product_name\";s:16:\"Jetpack Complete\";s:12:\"product_slug\";s:16:\"jetpack_complete\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-complete\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€551.40\";s:21:\"combined_cost_display\";s:9:\"€551.40\";s:4:\"cost\";d:551.4;s:18:\"cost_smallest_unit\";i:55140;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:275.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€45.95\";}s:24:\"jetpack_complete_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2015;s:12:\"product_name\";s:16:\"Jetpack Complete\";s:12:\"product_slug\";s:24:\"jetpack_complete_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-complete\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€67.95\";s:21:\"combined_cost_display\";s:8:\"€67.95\";s:4:\"cost\";d:67.95;s:18:\"cost_smallest_unit\";i:6795;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:26:\"jetpack_security_t1_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2016;s:12:\"product_name\";s:23:\"Jetpack Security (10GB)\";s:12:\"product_slug\";s:26:\"jetpack_security_t1_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-security-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€227.40\";s:21:\"combined_cost_display\";s:9:\"€227.40\";s:4:\"cost\";d:227.4;s:18:\"cost_smallest_unit\";i:22740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:107.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€18.95\";}s:27:\"jetpack_security_t1_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2017;s:12:\"product_name\";s:23:\"Jetpack Security (10GB)\";s:12:\"product_slug\";s:27:\"jetpack_security_t1_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-security-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€27.95\";s:21:\"combined_cost_display\";s:8:\"€27.95\";s:4:\"cost\";d:27.95;s:18:\"cost_smallest_unit\";i:2795;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:26:\"jetpack_security_t2_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2019;s:12:\"product_name\";s:22:\"Jetpack Security (1TB)\";s:12:\"product_slug\";s:26:\"jetpack_security_t2_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-security-tier-2\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€863.40\";s:21:\"combined_cost_display\";s:9:\"€863.40\";s:4:\"cost\";d:863.4;s:18:\"cost_smallest_unit\";i:86340;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:347.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€71.95\";}s:27:\"jetpack_security_t2_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2020;s:12:\"product_name\";s:22:\"Jetpack Security (1TB)\";s:12:\"product_slug\";s:27:\"jetpack_security_t2_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-security-tier-2\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€71.95\";s:21:\"combined_cost_display\";s:8:\"€71.95\";s:4:\"cost\";d:71.95;s:18:\"cost_smallest_unit\";i:7195;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:22:\"jetpack_starter_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2030;s:12:\"product_name\";s:15:\"Jetpack Starter\";s:12:\"product_slug\";s:22:\"jetpack_starter_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:0;s:20:\"billing_product_slug\";s:15:\"jetpack-starter\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€71.40\";s:21:\"combined_cost_display\";s:8:\"€71.40\";s:4:\"cost\";d:71.4;s:18:\"cost_smallest_unit\";i:7140;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:43.8;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€5.95\";}s:23:\"jetpack_starter_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2031;s:12:\"product_name\";s:15:\"Jetpack Starter\";s:12:\"product_slug\";s:23:\"jetpack_starter_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:0;s:20:\"billing_product_slug\";s:15:\"jetpack-starter\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€8.45\";s:21:\"combined_cost_display\";s:7:\"€8.45\";s:4:\"cost\";d:8.45;s:18:\"cost_smallest_unit\";i:845;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:29:\"jetpack_security_t1_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2034;s:12:\"product_name\";s:23:\"Jetpack Security (10GB)\";s:12:\"product_slug\";s:29:\"jetpack_security_t1_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"bundle\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-security-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€363.84\";s:21:\"combined_cost_display\";s:9:\"€363.84\";s:4:\"cost\";d:363.84;s:18:\"cost_smallest_unit\";i:36384;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:267.84;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€15.16\";}s:26:\"jetpack_complete_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2035;s:12:\"product_name\";s:16:\"Jetpack Complete\";s:12:\"product_slug\";s:26:\"jetpack_complete_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:16:\"jetpack-complete\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€882.24\";s:21:\"combined_cost_display\";s:9:\"€882.24\";s:4:\"cost\";d:882.24;s:18:\"cost_smallest_unit\";i:88224;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:661.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€36.76\";}s:23:\"jetpack_boost_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2036;s:12:\"product_name\";s:13:\"Jetpack Boost\";s:12:\"product_slug\";s:23:\"jetpack_boost_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:13:\"jetpack-boost\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€363.84\";s:21:\"combined_cost_display\";s:9:\"€363.84\";s:4:\"cost\";d:363.84;s:18:\"cost_smallest_unit\";i:36384;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:267.84;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€15.16\";}s:30:\"jetpack_social_basic_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2037;s:12:\"product_name\";s:20:\"Jetpack Social Basic\";s:12:\"product_slug\";s:30:\"jetpack_social_basic_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:27:\"jetpack-social-basic-yearly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€214.80\";s:21:\"combined_cost_display\";s:9:\"€214.80\";s:4:\"cost\";d:214.8;s:18:\"cost_smallest_unit\";i:21480;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:128.64;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:22:\"jetpack_scan_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2038;s:12:\"product_name\";s:18:\"Jetpack Scan Daily\";s:12:\"product_slug\";s:22:\"jetpack_scan_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:12:\"jetpack-scan\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:27:\"jetpack_anti_spam_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2039;s:12:\"product_name\";s:25:\"Jetpack Akismet Anti-spam\";s:12:\"product_slug\";s:27:\"jetpack_anti_spam_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-anti-spam\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:41:\"jetpack_backup_addon_storage_10gb_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2040;s:12:\"product_name\";s:47:\"Jetpack VaultPress Backup Add-on Storage (10GB)\";s:12:\"product_slug\";s:41:\"jetpack_backup_addon_storage_10gb_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:33:\"jetpack-backup-addon-storage-10gb\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€2.75\";s:21:\"combined_cost_display\";s:7:\"€2.75\";s:4:\"cost\";d:2.75;s:18:\"cost_smallest_unit\";i:275;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:42:\"jetpack_backup_addon_storage_100gb_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2044;s:12:\"product_name\";s:48:\"Jetpack VaultPress Backup Add-on Storage (100GB)\";s:12:\"product_slug\";s:42:\"jetpack_backup_addon_storage_100gb_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:34:\"jetpack-backup-addon-storage-100gb\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€5.45\";s:21:\"combined_cost_display\";s:7:\"€5.45\";s:4:\"cost\";d:5.45;s:18:\"cost_smallest_unit\";i:545;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:40:\"jetpack_backup_addon_storage_1tb_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2048;s:12:\"product_name\";s:46:\"Jetpack VaultPress Backup Add-on Storage (1TB)\";s:12:\"product_slug\";s:40:\"jetpack_backup_addon_storage_1tb_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:32:\"jetpack-backup-addon-storage-1tb\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€9.45\";s:21:\"combined_cost_display\";s:7:\"€9.45\";s:4:\"cost\";d:9.45;s:18:\"cost_smallest_unit\";i:945;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:40:\"jetpack_backup_addon_storage_3tb_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2052;s:12:\"product_name\";s:46:\"Jetpack VaultPress Backup Add-on Storage (3TB)\";s:12:\"product_slug\";s:40:\"jetpack_backup_addon_storage_3tb_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:32:\"jetpack-backup-addon-storage-3tb\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€18.95\";s:21:\"combined_cost_display\";s:8:\"€18.95\";s:4:\"cost\";d:18.95;s:18:\"cost_smallest_unit\";i:1895;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:40:\"jetpack_backup_addon_storage_5tb_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2056;s:12:\"product_name\";s:46:\"Jetpack VaultPress Backup Add-on Storage (5TB)\";s:12:\"product_slug\";s:40:\"jetpack_backup_addon_storage_5tb_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:32:\"jetpack-backup-addon-storage-5tb\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€27.95\";s:21:\"combined_cost_display\";s:8:\"€27.95\";s:4:\"cost\";d:27.95;s:18:\"cost_smallest_unit\";i:2795;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:20:\"jetpack_backup_daily\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2100;s:12:\"product_name\";s:22:\"Jetpack Backup (Daily)\";s:12:\"product_slug\";s:20:\"jetpack_backup_daily\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:20:\"jetpack-backup-daily\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€108.00\";s:21:\"combined_cost_display\";s:6:\"€108\";s:4:\"cost\";i:108;s:18:\"cost_smallest_unit\";i:10800;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";i:54;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:4:\"€9\";}s:28:\"jetpack_backup_daily_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2101;s:12:\"product_name\";s:22:\"Jetpack Backup (Daily)\";s:12:\"product_slug\";s:28:\"jetpack_backup_daily_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:20:\"jetpack-backup-daily\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€9.00\";s:21:\"combined_cost_display\";s:4:\"€9\";s:4:\"cost\";i:9;s:18:\"cost_smallest_unit\";i:900;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:23:\"jetpack_backup_realtime\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2102;s:12:\"product_name\";s:26:\"Jetpack Backup (Real-time)\";s:12:\"product_slug\";s:23:\"jetpack_backup_realtime\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-backup-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€528.00\";s:21:\"combined_cost_display\";s:6:\"€528\";s:4:\"cost\";i:528;s:18:\"cost_smallest_unit\";i:52800;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";i:264;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:5:\"€44\";}s:31:\"jetpack_backup_realtime_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2103;s:12:\"product_name\";s:26:\"Jetpack Backup (Real-time)\";s:12:\"product_slug\";s:31:\"jetpack_backup_realtime_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-backup-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€44.00\";s:21:\"combined_cost_display\";s:5:\"€44\";s:4:\"cost\";i:44;s:18:\"cost_smallest_unit\";i:4400;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:14:\"jetpack_search\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2104;s:12:\"product_name\";s:14:\"Jetpack Search\";s:12:\"product_slug\";s:14:\"jetpack_search\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"search\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:14:\"jetpack-search\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€95.40\";s:21:\"combined_cost_display\";s:8:\"€95.40\";s:4:\"cost\";d:95.4;s:18:\"cost_smallest_unit\";i:9540;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:1:{i:0;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:0;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:10000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:0;s:12:\"per_unit_fee\";i:9540;s:21:\"minimum_price_display\";s:4:\"€0\";s:29:\"minimum_price_monthly_display\";s:4:\"€0\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€7.95\";}s:22:\"jetpack_search_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2105;s:12:\"product_name\";s:14:\"Jetpack Search\";s:12:\"product_slug\";s:22:\"jetpack_search_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"search\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:14:\"jetpack-search\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€11.95\";s:21:\"combined_cost_display\";s:8:\"€11.95\";s:4:\"cost\";d:11.95;s:18:\"cost_smallest_unit\";i:1195;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:1:{i:0;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:0;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:10000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:0;s:12:\"per_unit_fee\";i:1195;s:21:\"minimum_price_display\";s:4:\"€0\";s:29:\"minimum_price_monthly_display\";s:4:\"€0\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:12:\"jetpack_scan\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2106;s:12:\"product_name\";s:18:\"Jetpack Scan Daily\";s:12:\"product_slug\";s:12:\"jetpack_scan\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:12:\"jetpack-scan\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:20:\"jetpack_scan_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2107;s:12:\"product_name\";s:18:\"Jetpack Scan Daily\";s:12:\"product_slug\";s:20:\"jetpack_scan_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:12:\"jetpack-scan\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:21:\"jetpack_scan_realtime\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2108;s:12:\"product_name\";s:21:\"Jetpack Scan Realtime\";s:12:\"product_slug\";s:21:\"jetpack_scan_realtime\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-scan-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€550.00\";s:21:\"combined_cost_display\";s:6:\"€550\";s:4:\"cost\";i:550;s:18:\"cost_smallest_unit\";i:55000;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:8:\"€45.83\";}s:29:\"jetpack_scan_realtime_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2109;s:12:\"product_name\";s:21:\"Jetpack Scan Realtime\";s:12:\"product_slug\";s:29:\"jetpack_scan_realtime_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-scan-realtime\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€55.00\";s:21:\"combined_cost_display\";s:5:\"€55\";s:4:\"cost\";i:55;s:18:\"cost_smallest_unit\";i:5500;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:17:\"jetpack_anti_spam\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2110;s:12:\"product_name\";s:25:\"Jetpack Akismet Anti-spam\";s:12:\"product_slug\";s:17:\"jetpack_anti_spam\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-anti-spam\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:25:\"jetpack_anti_spam_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2111;s:12:\"product_name\";s:25:\"Jetpack Akismet Anti-spam\";s:12:\"product_slug\";s:25:\"jetpack_anti_spam_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-anti-spam\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:24:\"jetpack_backup_t1_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2112;s:12:\"product_name\";s:32:\"Jetpack VaultPress Backup (10GB)\";s:12:\"product_slug\";s:24:\"jetpack_backup_t1_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:25:\"jetpack_backup_t1_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2113;s:12:\"product_name\";s:32:\"Jetpack VaultPress Backup (10GB)\";s:12:\"product_slug\";s:25:\"jetpack_backup_t1_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:24:\"jetpack_backup_t2_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2114;s:12:\"product_name\";s:31:\"Jetpack VaultPress Backup (1TB)\";s:12:\"product_slug\";s:24:\"jetpack_backup_t2_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-2\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€347.40\";s:21:\"combined_cost_display\";s:9:\"€347.40\";s:4:\"cost\";d:347.4;s:18:\"cost_smallest_unit\";i:34740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:143.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€28.95\";}s:25:\"jetpack_backup_t2_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2115;s:12:\"product_name\";s:31:\"Jetpack VaultPress Backup (1TB)\";s:12:\"product_slug\";s:25:\"jetpack_backup_t2_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-2\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€28.95\";s:21:\"combined_cost_display\";s:8:\"€28.95\";s:4:\"cost\";d:28.95;s:18:\"cost_smallest_unit\";i:2895;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:18:\"jetpack_videopress\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2116;s:12:\"product_name\";s:18:\"Jetpack VideoPress\";s:12:\"product_slug\";s:18:\"jetpack_videopress\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:18:\"jetpack-videopress\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:26:\"jetpack_videopress_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2117;s:12:\"product_name\";s:18:\"Jetpack VideoPress\";s:12:\"product_slug\";s:26:\"jetpack_videopress_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:18:\"jetpack-videopress\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:28:\"jetpack_videopress_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2119;s:12:\"product_name\";s:18:\"Jetpack VideoPress\";s:12:\"product_slug\";s:28:\"jetpack_videopress_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:18:\"jetpack-videopress\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:24:\"jetpack_backup_t0_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2120;s:12:\"product_name\";s:31:\"Jetpack VaultPress Backup (1GB)\";s:12:\"product_slug\";s:24:\"jetpack_backup_t0_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-0\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€39.00\";s:21:\"combined_cost_display\";s:5:\"€39\";s:4:\"cost\";i:39;s:18:\"cost_smallest_unit\";i:3900;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€3.25\";}s:25:\"jetpack_backup_t0_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2121;s:12:\"product_name\";s:31:\"Jetpack VaultPress Backup (1GB)\";s:12:\"product_slug\";s:25:\"jetpack_backup_t0_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-0\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€3.00\";s:21:\"combined_cost_display\";s:4:\"€3\";s:4:\"cost\";i:3;s:18:\"cost_smallest_unit\";i:300;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:27:\"jetpack_backup_t1_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2123;s:12:\"product_name\";s:32:\"Jetpack VaultPress Backup (10GB)\";s:12:\"product_slug\";s:27:\"jetpack_backup_t1_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack-backup-tier-1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:19:\"jetpack_search_free\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2130;s:12:\"product_name\";s:19:\"Jetpack Search Free\";s:12:\"product_slug\";s:19:\"jetpack_search_free\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:6:\"search\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:19:\"jetpack-search-free\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€0.00\";s:21:\"combined_cost_display\";s:4:\"€0\";s:4:\"cost\";i:0;s:18:\"cost_smallest_unit\";i:0;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:8:\"one time\";s:22:\"product_term_localized\";s:8:\"one time\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:24:\"jetpack_search_bi_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2131;s:12:\"product_name\";s:14:\"Jetpack Search\";s:12:\"product_slug\";s:24:\"jetpack_search_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:14:\"jetpack-search\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€152.64\";s:21:\"combined_cost_display\";s:9:\"€152.64\";s:4:\"cost\";d:152.64;s:18:\"cost_smallest_unit\";i:15264;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:1:{i:0;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:0;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:10000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:0;s:12:\"per_unit_fee\";i:15264;s:21:\"minimum_price_display\";s:4:\"€0\";s:29:\"minimum_price_monthly_display\";s:4:\"€0\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€6.36\";}s:23:\"jetpack_backup_one_time\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2201;s:12:\"product_name\";s:36:\"Jetpack VaultPress Backup (One-time)\";s:12:\"product_slug\";s:23:\"jetpack_backup_one_time\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-backup-one-time\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€1.09\";s:21:\"combined_cost_display\";s:7:\"€1.09\";s:4:\"cost\";d:1.09;s:18:\"cost_smallest_unit\";i:109;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:8:\"one time\";s:22:\"product_term_localized\";s:8:\"one time\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:20:\"jetpack_stats_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2219;s:12:\"product_name\";s:34:\"Jetpack Stats (Commercial license)\";s:12:\"product_slug\";s:20:\"jetpack_stats_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack_stats_monthly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€95.40\";s:21:\"combined_cost_display\";s:8:\"€95.40\";s:4:\"cost\";d:95.4;s:18:\"cost_smallest_unit\";i:9540;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:6:{i:0;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";i:10000;s:13:\"minimum_price\";i:9540;s:13:\"maximum_price\";i:9540;s:21:\"minimum_price_display\";s:8:\"€95.40\";s:29:\"minimum_price_monthly_display\";s:7:\"€7.95\";s:21:\"maximum_price_display\";s:8:\"€95.40\";s:29:\"maximum_price_monthly_display\";s:7:\"€7.95\";}i:1;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:10001;s:13:\"maximum_units\";i:100000;s:13:\"minimum_price\";i:19140;s:13:\"maximum_price\";i:19140;s:21:\"minimum_price_display\";s:9:\"€191.40\";s:29:\"minimum_price_monthly_display\";s:8:\"€15.95\";s:21:\"maximum_price_display\";s:9:\"€191.40\";s:29:\"maximum_price_monthly_display\";s:8:\"€15.95\";}i:2;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:100001;s:13:\"maximum_units\";i:250000;s:13:\"minimum_price\";i:27540;s:13:\"maximum_price\";i:27540;s:21:\"minimum_price_display\";s:9:\"€275.40\";s:29:\"minimum_price_monthly_display\";s:8:\"€22.95\";s:21:\"maximum_price_display\";s:9:\"€275.40\";s:29:\"maximum_price_monthly_display\";s:8:\"€22.95\";}i:3;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:250001;s:13:\"maximum_units\";i:500000;s:13:\"minimum_price\";i:45540;s:13:\"maximum_price\";i:45540;s:21:\"minimum_price_display\";s:9:\"€455.40\";s:29:\"minimum_price_monthly_display\";s:8:\"€37.95\";s:21:\"maximum_price_display\";s:9:\"€455.40\";s:29:\"maximum_price_monthly_display\";s:8:\"€37.95\";}i:4;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:500001;s:13:\"maximum_units\";i:1000000;s:13:\"minimum_price\";i:63540;s:13:\"maximum_price\";i:63540;s:21:\"minimum_price_display\";s:9:\"€635.40\";s:29:\"minimum_price_monthly_display\";s:8:\"€52.95\";s:21:\"maximum_price_display\";s:9:\"€635.40\";s:29:\"maximum_price_monthly_display\";s:8:\"€52.95\";}i:5;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:1000001;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:86280;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:1000000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:40800;s:12:\"per_unit_fee\";i:22740;s:21:\"minimum_price_display\";s:9:\"€862.80\";s:29:\"minimum_price_monthly_display\";s:8:\"€71.90\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:10000;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€7.95\";}s:21:\"jetpack_stats_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2220;s:12:\"product_name\";s:34:\"Jetpack Stats (Commercial license)\";s:12:\"product_slug\";s:21:\"jetpack_stats_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack_stats_monthly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€11.95\";s:21:\"combined_cost_display\";s:8:\"€11.95\";s:4:\"cost\";d:11.95;s:18:\"cost_smallest_unit\";i:1195;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:6:{i:0;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";i:10000;s:13:\"minimum_price\";i:1195;s:13:\"maximum_price\";i:1195;s:21:\"minimum_price_display\";s:8:\"€11.95\";s:29:\"minimum_price_monthly_display\";s:8:\"€11.95\";s:21:\"maximum_price_display\";s:8:\"€11.95\";s:29:\"maximum_price_monthly_display\";s:8:\"€11.95\";}i:1;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:10001;s:13:\"maximum_units\";i:100000;s:13:\"minimum_price\";i:2395;s:13:\"maximum_price\";i:2395;s:21:\"minimum_price_display\";s:8:\"€23.95\";s:29:\"minimum_price_monthly_display\";s:8:\"€23.95\";s:21:\"maximum_price_display\";s:8:\"€23.95\";s:29:\"maximum_price_monthly_display\";s:8:\"€23.95\";}i:2;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:100001;s:13:\"maximum_units\";i:250000;s:13:\"minimum_price\";i:3495;s:13:\"maximum_price\";i:3495;s:21:\"minimum_price_display\";s:8:\"€34.95\";s:29:\"minimum_price_monthly_display\";s:8:\"€34.95\";s:21:\"maximum_price_display\";s:8:\"€34.95\";s:29:\"maximum_price_monthly_display\";s:8:\"€34.95\";}i:3;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:250001;s:13:\"maximum_units\";i:500000;s:13:\"minimum_price\";i:5695;s:13:\"maximum_price\";i:5695;s:21:\"minimum_price_display\";s:8:\"€56.95\";s:29:\"minimum_price_monthly_display\";s:8:\"€56.95\";s:21:\"maximum_price_display\";s:8:\"€56.95\";s:29:\"maximum_price_monthly_display\";s:8:\"€56.95\";}i:4;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:500001;s:13:\"maximum_units\";i:1000000;s:13:\"minimum_price\";i:7995;s:13:\"maximum_price\";i:7995;s:21:\"minimum_price_display\";s:8:\"€79.95\";s:29:\"minimum_price_monthly_display\";s:8:\"€79.95\";s:21:\"maximum_price_display\";s:8:\"€79.95\";s:29:\"maximum_price_monthly_display\";s:8:\"€79.95\";}i:5;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:1000001;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:10890;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:1000000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:5100;s:12:\"per_unit_fee\";i:2895;s:21:\"minimum_price_display\";s:9:\"€108.90\";s:29:\"minimum_price_monthly_display\";s:9:\"€108.90\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:10000;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:25:\"jetpack_stats_free_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2221;s:12:\"product_name\";s:43:\"Jetpack Stats (Free non-commercial license)\";s:12:\"product_slug\";s:25:\"jetpack_stats_free_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:25:\"jetpack_stats_free_yearly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€0.00\";s:21:\"combined_cost_display\";s:4:\"€0\";s:4:\"cost\";i:0;s:18:\"cost_smallest_unit\";i:0;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:4:\"€0\";}s:25:\"jetpack_stats_pwyw_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2222;s:12:\"product_name\";s:20:\"Jetpack Stats (Paid)\";s:12:\"product_slug\";s:25:\"jetpack_stats_pwyw_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:25:\"jetpack_stats_pwyw_yearly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€0.00\";s:21:\"combined_cost_display\";s:4:\"€0\";s:4:\"cost\";i:0;s:18:\"cost_smallest_unit\";i:0;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";i:0;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:4:\"€0\";}s:23:\"jetpack_stats_bi_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2223;s:12:\"product_name\";s:34:\"Jetpack Stats (Commercial license)\";s:12:\"product_slug\";s:23:\"jetpack_stats_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:21:\"jetpack_stats_monthly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€152.64\";s:21:\"combined_cost_display\";s:9:\"€152.64\";s:4:\"cost\";d:152.64;s:18:\"cost_smallest_unit\";i:15264;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:6:{i:0;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:0;s:13:\"maximum_units\";i:10000;s:13:\"minimum_price\";i:15264;s:13:\"maximum_price\";i:15264;s:21:\"minimum_price_display\";s:9:\"€152.64\";s:29:\"minimum_price_monthly_display\";s:8:\"€12.72\";s:21:\"maximum_price_display\";s:9:\"€152.64\";s:29:\"maximum_price_monthly_display\";s:8:\"€12.72\";}i:1;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:10001;s:13:\"maximum_units\";i:100000;s:13:\"minimum_price\";i:30624;s:13:\"maximum_price\";i:30624;s:21:\"minimum_price_display\";s:9:\"€306.24\";s:29:\"minimum_price_monthly_display\";s:8:\"€25.52\";s:21:\"maximum_price_display\";s:9:\"€306.24\";s:29:\"maximum_price_monthly_display\";s:8:\"€25.52\";}i:2;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:100001;s:13:\"maximum_units\";i:250000;s:13:\"minimum_price\";i:44064;s:13:\"maximum_price\";i:44064;s:21:\"minimum_price_display\";s:9:\"€440.64\";s:29:\"minimum_price_monthly_display\";s:8:\"€36.72\";s:21:\"maximum_price_display\";s:9:\"€440.64\";s:29:\"maximum_price_monthly_display\";s:8:\"€36.72\";}i:3;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:250001;s:13:\"maximum_units\";i:500000;s:13:\"minimum_price\";i:72864;s:13:\"maximum_price\";i:72864;s:21:\"minimum_price_display\";s:9:\"€728.64\";s:29:\"minimum_price_monthly_display\";s:8:\"€60.72\";s:21:\"maximum_price_display\";s:9:\"€728.64\";s:29:\"maximum_price_monthly_display\";s:8:\"€60.72\";}i:4;O:8:\"stdClass\":8:{s:13:\"minimum_units\";i:500001;s:13:\"maximum_units\";i:1000000;s:13:\"minimum_price\";i:101664;s:13:\"maximum_price\";i:101664;s:21:\"minimum_price_display\";s:11:\"€1,016.64\";s:29:\"minimum_price_monthly_display\";s:8:\"€84.72\";s:21:\"maximum_price_display\";s:11:\"€1,016.64\";s:29:\"maximum_price_monthly_display\";s:8:\"€84.72\";}i:5;O:8:\"stdClass\":12:{s:13:\"minimum_units\";i:1000001;s:13:\"maximum_units\";N;s:13:\"minimum_price\";i:138048;s:13:\"maximum_price\";i:0;s:28:\"transform_quantity_divide_by\";i:1000000;s:24:\"transform_quantity_round\";s:2:\"up\";s:8:\"flat_fee\";i:65280;s:12:\"per_unit_fee\";i:36384;s:21:\"minimum_price_display\";s:11:\"€1,380.48\";s:29:\"minimum_price_monthly_display\";s:9:\"€115.04\";s:21:\"maximum_price_display\";N;s:29:\"maximum_price_monthly_display\";N;}}s:25:\"price_tier_usage_quantity\";i:10000;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€6.36\";}s:23:\"jetpack_monitor_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2241;s:12:\"product_name\";s:15:\"Jetpack Monitor\";s:12:\"product_slug\";s:23:\"jetpack_monitor_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-monitor\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€1.00\";s:21:\"combined_cost_display\";s:4:\"€1\";s:4:\"cost\";i:1;s:18:\"cost_smallest_unit\";i:100;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:22:\"jetpack_monitor_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2242;s:12:\"product_name\";s:15:\"Jetpack Monitor\";s:12:\"product_slug\";s:22:\"jetpack_monitor_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-monitor\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.00\";s:21:\"combined_cost_display\";s:5:\"€13\";s:4:\"cost\";i:13;s:18:\"cost_smallest_unit\";i:1300;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€1.08\";}s:21:\"jetpack_boost_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2400;s:12:\"product_name\";s:13:\"Jetpack Boost\";s:12:\"product_slug\";s:21:\"jetpack_boost_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:13:\"jetpack-boost\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€27.95\";s:21:\"combined_cost_display\";s:8:\"€27.95\";s:4:\"cost\";d:27.95;s:18:\"cost_smallest_unit\";i:2795;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:20:\"jetpack_boost_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2401;s:12:\"product_name\";s:13:\"Jetpack Boost\";s:12:\"product_slug\";s:20:\"jetpack_boost_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:13:\"jetpack-boost\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€227.40\";s:21:\"combined_cost_display\";s:9:\"€227.40\";s:4:\"cost\";d:227.4;s:18:\"cost_smallest_unit\";i:22740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:107.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€18.95\";}s:18:\"jetpack_ai_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2450;s:12:\"product_name\";s:20:\"Jetpack AI Assistant\";s:12:\"product_slug\";s:18:\"jetpack_ai_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:10:\"jetpack-ai\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:17:\"jetpack_ai_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2451;s:12:\"product_name\";s:20:\"Jetpack AI Assistant\";s:12:\"product_slug\";s:17:\"jetpack_ai_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:10:\"jetpack-ai\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:20:\"jetpack_ai_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2452;s:12:\"product_name\";s:20:\"Jetpack AI Assistant\";s:12:\"product_slug\";s:20:\"jetpack_ai_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:10:\"jetpack-ai\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";i:1;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:22:\"jetpack_social_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2500;s:12:\"product_name\";s:20:\"Jetpack Social Basic\";s:12:\"product_slug\";s:22:\"jetpack_social_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:14:\"jetpack-social\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.00\";s:21:\"combined_cost_display\";s:5:\"€13\";s:4:\"cost\";i:13;s:18:\"cost_smallest_unit\";i:1300;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:27:\"jetpack_social_basic_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2503;s:12:\"product_name\";s:20:\"Jetpack Social Basic\";s:12:\"product_slug\";s:27:\"jetpack_social_basic_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:27:\"jetpack-social-basic-yearly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:53.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:28:\"jetpack_social_basic_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2504;s:12:\"product_name\";s:20:\"Jetpack Social Basic\";s:12:\"product_slug\";s:28:\"jetpack_social_basic_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:27:\"jetpack-social-basic-yearly\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:30:\"jetpack_social_advanced_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2602;s:12:\"product_name\";s:30:\"Jetpack Social Advanced (Beta)\";s:12:\"product_slug\";s:30:\"jetpack_social_advanced_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-social-advanced\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:31:\"jetpack_social_advanced_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2603;s:12:\"product_name\";s:30:\"Jetpack Social Advanced (Beta)\";s:12:\"product_slug\";s:31:\"jetpack_social_advanced_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-social-advanced\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:33:\"jetpack_social_advanced_bi_yearly\";O:8:\"stdClass\":20:{s:10:\"product_id\";i:2604;s:12:\"product_name\";s:30:\"Jetpack Social Advanced (Beta)\";s:12:\"product_slug\";s:33:\"jetpack_social_advanced_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:23:\"jetpack-social-advanced\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€214.80\";s:21:\"combined_cost_display\";s:9:\"€214.80\";s:4:\"cost\";d:214.8;s:18:\"cost_smallest_unit\";i:21480;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:24:\"jetpack_social_v1_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2605;s:12:\"product_name\";s:14:\"Jetpack Social\";s:12:\"product_slug\";s:24:\"jetpack_social_v1_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-social-v1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€107.40\";s:21:\"combined_cost_display\";s:9:\"€107.40\";s:4:\"cost\";d:107.4;s:18:\"cost_smallest_unit\";i:10740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:59.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€8.95\";}s:25:\"jetpack_social_v1_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2606;s:12:\"product_name\";s:14:\"Jetpack Social\";s:12:\"product_slug\";s:25:\"jetpack_social_v1_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-social-v1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€13.95\";s:21:\"combined_cost_display\";s:8:\"€13.95\";s:4:\"cost\";d:13.95;s:18:\"cost_smallest_unit\";i:1395;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:27:\"jetpack_social_v1_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2607;s:12:\"product_name\";s:14:\"Jetpack Social\";s:12:\"product_slug\";s:27:\"jetpack_social_v1_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:17:\"jetpack-social-v1\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€171.84\";s:21:\"combined_cost_display\";s:9:\"€171.84\";s:4:\"cost\";d:171.84;s:18:\"cost_smallest_unit\";i:17184;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:133.44;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:7:\"€7.16\";}s:23:\"jetpack_creator_monthly\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2610;s:12:\"product_name\";s:15:\"Jetpack Creator\";s:12:\"product_slug\";s:23:\"jetpack_creator_monthly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-creator\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:8:\"€27.95\";s:21:\"combined_cost_display\";s:8:\"€27.95\";s:4:\"cost\";d:27.95;s:18:\"cost_smallest_unit\";i:2795;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:5:\"month\";s:22:\"product_term_localized\";s:5:\"month\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}s:22:\"jetpack_creator_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2611;s:12:\"product_name\";s:15:\"Jetpack Creator\";s:12:\"product_slug\";s:22:\"jetpack_creator_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-creator\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€227.40\";s:21:\"combined_cost_display\";s:9:\"€227.40\";s:4:\"cost\";d:227.4;s:18:\"cost_smallest_unit\";i:22740;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:4:\"year\";s:22:\"product_term_localized\";s:4:\"year\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:1;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:107.4;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€18.95\";}s:25:\"jetpack_creator_bi_yearly\";O:8:\"stdClass\":21:{s:10:\"product_id\";i:2612;s:12:\"product_name\";s:15:\"Jetpack Creator\";s:12:\"product_slug\";s:25:\"jetpack_creator_bi_yearly\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:15:\"jetpack-creator\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:9:\"€363.84\";s:21:\"combined_cost_display\";s:9:\"€363.84\";s:4:\"cost\";d:363.84;s:18:\"cost_smallest_unit\";i:36384;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:9:\"two years\";s:22:\"product_term_localized\";s:9:\"two years\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";s:18:\"introductory_offer\";O:8:\"stdClass\":7:{s:13:\"interval_unit\";s:4:\"year\";s:14:\"interval_count\";i:2;s:11:\"usage_limit\";N;s:17:\"cost_per_interval\";d:267.84;s:30:\"transition_after_renewal_count\";i:0;s:30:\"should_prorate_when_offer_ends\";b:0;s:6:\"reason\";N;}s:22:\"cost_per_month_display\";s:8:\"€15.16\";}s:29:\"jetpack_golden_token_lifetime\";O:8:\"stdClass\":19:{s:10:\"product_id\";i:2900;s:12:\"product_name\";s:20:\"Jetpack Golden Token\";s:12:\"product_slug\";s:29:\"jetpack_golden_token_lifetime\";s:11:\"description\";s:0:\"\";s:12:\"product_type\";s:7:\"jetpack\";s:9:\"available\";b:1;s:20:\"billing_product_slug\";s:20:\"jetpack-golden-token\";s:22:\"is_domain_registration\";b:0;s:12:\"cost_display\";s:7:\"€0.00\";s:21:\"combined_cost_display\";s:4:\"€0\";s:4:\"cost\";i:0;s:18:\"cost_smallest_unit\";i:0;s:13:\"currency_code\";s:3:\"EUR\";s:15:\"price_tier_list\";a:0:{}s:25:\"price_tier_usage_quantity\";N;s:12:\"product_term\";s:8:\"one time\";s:22:\"product_term_localized\";s:8:\"one time\";s:11:\"price_tiers\";a:0:{}s:15:\"price_tier_slug\";s:0:\"\";}}"),
("221","2","jetpack_tracks_wpcom_id","257454433"),
("222","1","jetpack_tracks_anon_id","jetpack:BBO+fGrfiFP/+J8zYBKSdH8Z"),
("223","1","dismissed_update_notice","1"),
("224","1","session_tokens","a:1:{s:64:\"0d6d30fa6277d5ccc86517c9e46e1ed563174e3cdba5c9c08c72d39616f4c622\";a:4:{s:10:\"expiration\";i:1763129020;s:2:\"ip\";s:37:\"2a01:e0a:b07:a650:acdf:7630:b068:9e08\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\";s:5:\"login\";i:1761919420;}}"),
("226","2","session_tokens","a:1:{s:64:\"f76e198a81cdc1fb991330119149878727882bce427f2dab100a9815dd0dee32\";a:4:{s:10:\"expiration\";i:1762090414;s:2:\"ip\";s:14:\"86.120.252.105\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1761917614;}}"),
("228","2","rocket_boxes","a:1:{i:0;s:34:\"rocket_warning_plugin_modification\";}"),
("230","1","rocket_boxes","a:1:{i:1;s:34:\"rocket_warning_plugin_modification\";}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("10","action_scheduler/migration_hook","failed","2024-01-10 20:53:34","2024-01-10 20:53:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1704920014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1704920014;}","1","1","2024-01-10 20:53:44","2024-01-10 20:53:44","0",NULL),
("600","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2024-02-05 21:22:14","2024-02-05 21:22:14","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-02-05 21:22:48","2024-02-05 21:22:48","0",NULL),
("7296","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wishlist\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-10 09:57:17","2024-10-10 09:57:17","1889",NULL),
("7297","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/about-us\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7298","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/footer-niche-market03\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7299","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/prefooter-niche-market03\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7300","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/banner-for-single-product-page\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7301","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/block-for-single-product-page\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7302","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/top-header-left-block\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7303","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/main-header-block\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7304","rocket_preload_job_preload_url","failed","2024-10-10 09:55:31","2024-10-10 09:55:31","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/staticblocks\\/bottom-header-block\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7305","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/console\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7306","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/brands\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7307","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/tv-monitor\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7308","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/shop\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7309","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/brand\\/ds\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7310","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/other\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7311","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/new-arrivals\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7312","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/furniture\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7313","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/automation\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7314","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/brand\\/minim\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7315","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/brand\\/minimal\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7316","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/brand\\/sunshi\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7317","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/all-appliances\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7318","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/apparels\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7319","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/beauty\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7320","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/bestsellers\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7321","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/body\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7322","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/cameras\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7323","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/children\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7324","rocket_preload_job_preload_url","failed","2024-10-10 09:56:30","2024-10-10 09:56:30","10","[\"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/categorie-produs\\/clothings\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7325","rocket_preload_job_check_finished","failed","2024-10-10 09:58:04","2024-10-10 09:58:04","10","[1728554224]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728554284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728554284;}","3","1","2024-10-22 11:03:09","2024-10-22 11:03:09","0",NULL),
("7461","rank_math/analytics/data_fetch","failed","2024-10-26 05:42:28","2024-10-26 05:42:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1729921348;s:18:\"\0*\0first_timestamp\";i:1729653240;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1729921348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-06 14:23:55","2024-12-06 14:23:55","0",NULL),
("7507","rank_math/analytics/data_fetch","failed","2024-12-09 14:23:55","2024-12-09 14:23:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733754235;s:18:\"\0*\0first_timestamp\";i:1729653240;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733754235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-14 20:13:33","2024-12-14 22:13:33","0",NULL),
("7519","action_scheduler/migration_hook","failed","2024-12-09 09:27:39","2024-12-09 09:27:39","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733736459;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733736459;}","1","1","2024-12-09 09:27:52","2024-12-09 09:27:52","0",NULL),
("7534","rank_math/analytics/data_fetch","failed","2024-12-17 20:13:33","2024-12-17 20:13:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734466413;s:18:\"\0*\0first_timestamp\";i:1729653240;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734466413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-18 09:24:34","2024-12-18 11:24:34","0",NULL),
("7538","rank_math/analytics/data_fetch","failed","2024-12-21 09:24:34","2024-12-21 09:24:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734773074;s:18:\"\0*\0first_timestamp\";i:1729653240;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734773074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-22 13:41:02","2024-12-22 15:41:02","0",NULL),
("7543","rank_math/analytics/data_fetch","failed","2024-12-25 13:41:02","2024-12-25 13:41:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735134062;s:18:\"\0*\0first_timestamp\";i:1729653240;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735134062;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-25 14:35:14","2024-12-25 16:35:14","0",NULL),
("7919","woocommerce_cleanup_draft_orders","complete","2025-09-30 03:43:40","2025-09-30 03:43:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759203820;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759203820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-09-30 17:12:48","2025-09-30 19:12:48","4639",NULL),
("7920","woocommerce_refresh_order_count_cache","complete","2025-09-30 01:59:08","2025-09-30 01:59:08","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759197548;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759197548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-09-30 17:12:48","2025-09-30 19:12:48","4639",NULL),
("7921","woocommerce_refresh_order_count_cache","complete","2025-10-01 05:12:48","2025-10-01 05:12:48","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759295568;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759295568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-01 17:14:10","2025-10-01 19:14:10","4646",NULL),
("7922","woocommerce_cleanup_draft_orders","complete","2025-10-01 17:12:48","2025-10-01 17:12:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759338768;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759338768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-01 17:14:10","2025-10-01 19:14:10","4646",NULL),
("7923","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2025-09-30 17:13:01","2025-09-30 17:13:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759252381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759252381;}","5","1","2025-09-30 17:36:54","2025-09-30 19:36:54","4641",NULL),
("7924","woocommerce_refresh_order_count_cache","complete","2025-10-02 05:14:10","2025-10-02 05:14:10","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759382050;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759382050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-02 08:05:16","2025-10-02 10:05:16","4655",NULL),
("7925","woocommerce_cleanup_draft_orders","complete","2025-10-02 17:14:10","2025-10-02 17:14:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759425250;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759425250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-03 07:11:27","2025-10-03 09:11:27","4658",NULL),
("7926","woocommerce_refresh_order_count_cache","complete","2025-10-02 20:05:16","2025-10-02 20:05:16","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759435516;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759435516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-03 07:11:27","2025-10-03 09:11:27","4658",NULL),
("7927","woocommerce_cleanup_draft_orders","complete","2025-10-04 07:11:27","2025-10-04 07:11:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759561887;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759561887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-05 04:11:52","2025-10-05 06:11:52","4660",NULL),
("7928","woocommerce_refresh_order_count_cache","complete","2025-10-03 19:11:27","2025-10-03 19:11:27","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759518687;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759518687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-05 04:11:52","2025-10-05 06:11:52","4660",NULL),
("7929","woocommerce_refresh_order_count_cache","complete","2025-10-05 16:11:52","2025-10-05 16:11:52","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759680712;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759680712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-06 18:06:28","2025-10-06 20:06:28","4662",NULL),
("7930","woocommerce_cleanup_draft_orders","complete","2025-10-06 04:11:52","2025-10-06 04:11:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759723912;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759723912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-06 18:06:28","2025-10-06 20:06:28","4662",NULL),
("7931","woocommerce_refresh_order_count_cache","complete","2025-10-07 06:06:28","2025-10-07 06:06:28","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759817188;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759817188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-07 08:17:00","2025-10-07 10:17:00","4672",NULL),
("7932","woocommerce_cleanup_draft_orders","complete","2025-10-07 18:06:28","2025-10-07 18:06:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759860388;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759860388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-08 11:59:44","2025-10-08 13:59:44","4677",NULL),
("7933","woocommerce_refresh_order_count_cache","complete","2025-10-07 20:17:00","2025-10-07 20:17:00","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759868220;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759868220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-08 11:59:44","2025-10-08 13:59:44","4677",NULL),
("7934","woocommerce_cleanup_draft_orders","complete","2025-10-09 11:59:44","2025-10-09 11:59:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760011184;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760011184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-09 22:53:08","2025-10-10 00:53:08","4687",NULL),
("7935","woocommerce_refresh_order_count_cache","complete","2025-10-08 23:59:44","2025-10-08 23:59:44","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759967984;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759967984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-09 00:22:53","2025-10-09 02:22:53","4684",NULL),
("7936","woocommerce_refresh_order_count_cache","complete","2025-10-09 12:22:53","2025-10-09 12:22:53","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760012573;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760012573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-09 22:53:08","2025-10-10 00:53:08","4687",NULL),
("7937","woocommerce_cleanup_draft_orders","complete","2025-10-10 22:53:08","2025-10-10 22:53:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760136788;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760136788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-11 07:37:29","2025-10-11 09:37:29","4694",NULL),
("7938","woocommerce_refresh_order_count_cache","complete","2025-10-10 10:53:08","2025-10-10 10:53:08","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760093588;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760093588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-11 07:37:29","2025-10-11 09:37:29","4694",NULL),
("7939","woocommerce_refresh_order_count_cache","complete","2025-10-11 19:37:29","2025-10-11 19:37:29","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760211449;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760211449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-12 06:07:51","2025-10-12 08:07:51","4699",NULL),
("7940","woocommerce_cleanup_draft_orders","complete","2025-10-12 07:37:29","2025-10-12 07:37:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760254649;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760254649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-12 17:40:11","2025-10-12 19:40:11","4701",NULL),
("7941","woocommerce_refresh_order_count_cache","complete","2025-10-12 18:07:51","2025-10-12 18:07:51","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760292471;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760292471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-12 20:17:13","2025-10-12 22:17:13","4704",NULL),
("7942","woocommerce_cleanup_draft_orders","complete","2025-10-13 17:40:11","2025-10-13 17:40:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760377211;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760377211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-14 09:27:33","2025-10-14 11:27:33","4717",NULL),
("7943","woocommerce_refresh_order_count_cache","complete","2025-10-13 08:17:13","2025-10-13 08:17:13","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760343433;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760343433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-13 12:26:20","2025-10-13 14:26:20","4706",NULL),
("7944","woocommerce_refresh_order_count_cache","complete","2025-10-14 00:26:20","2025-10-14 00:26:20","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760401580;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760401580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-14 09:27:33","2025-10-14 11:27:33","4717",NULL),
("7945","woocommerce_cleanup_draft_orders","complete","2025-10-15 09:27:33","2025-10-15 09:27:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760520453;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760520453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-15 17:06:29","2025-10-15 19:06:29","4728",NULL),
("7946","woocommerce_refresh_order_count_cache","complete","2025-10-14 21:27:33","2025-10-14 21:27:33","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760477253;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760477253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-15 03:46:39","2025-10-15 05:46:39","4726",NULL),
("7947","woocommerce_refresh_order_count_cache","complete","2025-10-15 15:46:39","2025-10-15 15:46:39","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760543199;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760543199;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-15 17:06:29","2025-10-15 19:06:29","4728",NULL),
("7948","woocommerce_cleanup_draft_orders","complete","2025-10-16 17:06:29","2025-10-16 17:06:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760634389;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760634389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-16 21:03:08","2025-10-16 23:03:08","4742",NULL),
("7949","woocommerce_refresh_order_count_cache","complete","2025-10-16 05:06:29","2025-10-16 05:06:29","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760591189;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760591189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-16 11:37:34","2025-10-16 13:37:34","4735",NULL),
("7950","woocommerce_refresh_order_count_cache","complete","2025-10-16 23:37:34","2025-10-16 23:37:34","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760657854;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760657854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-17 04:38:56","2025-10-17 06:38:56","4744",NULL),
("7951","woocommerce_cleanup_draft_orders","complete","2025-10-17 21:03:08","2025-10-17 21:03:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760734988;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760734988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-17 22:49:13","2025-10-18 00:49:13","4763",NULL),
("7952","woocommerce_refresh_order_count_cache","complete","2025-10-17 16:38:56","2025-10-17 16:38:56","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760719136;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760719136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-17 19:33:03","2025-10-17 21:33:03","4755",NULL),
("7953","woocommerce_refresh_order_count_cache","complete","2025-10-18 07:33:03","2025-10-18 07:33:03","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760772783;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760772783;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-18 10:32:59","2025-10-18 12:32:59","4770",NULL),
("7954","woocommerce_cleanup_draft_orders","complete","2025-10-18 22:49:13","2025-10-18 22:49:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760827753;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760827753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-19 02:43:49","2025-10-19 04:43:49","4774",NULL),
("7955","woocommerce_refresh_order_count_cache","complete","2025-10-18 22:32:59","2025-10-18 22:32:59","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760826779;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760826779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-19 02:43:49","2025-10-19 04:43:49","4774",NULL),
("7956","woocommerce_refresh_order_count_cache","complete","2025-10-19 14:43:49","2025-10-19 14:43:49","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760885029;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760885029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-19 21:27:26","2025-10-19 23:27:26","4779",NULL),
("7957","woocommerce_cleanup_draft_orders","complete","2025-10-20 02:43:49","2025-10-20 02:43:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760928229;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760928229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-20 06:08:13","2025-10-20 08:08:13","4785",NULL),
("7958","woocommerce_refresh_order_count_cache","complete","2025-10-20 09:27:26","2025-10-20 09:27:26","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760952446;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760952446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-20 12:13:09","2025-10-20 14:13:09","4790",NULL),
("7959","woocommerce_cleanup_draft_orders","complete","2025-10-21 06:08:13","2025-10-21 06:08:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761026893;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761026893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-21 08:16:29","2025-10-21 10:16:29","4799",NULL),
("7960","woocommerce_refresh_order_count_cache","complete","2025-10-21 00:13:09","2025-10-21 00:13:09","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761005589;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761005589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-21 08:16:29","2025-10-21 10:16:29","4799",NULL),
("7961","woocommerce_refresh_order_count_cache","complete","2025-10-21 20:16:29","2025-10-21 20:16:29","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761077789;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761077789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-21 21:01:01","2025-10-21 23:01:01","4801",NULL),
("7962","woocommerce_cleanup_draft_orders","complete","2025-10-22 08:16:29","2025-10-22 08:16:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761120989;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761120989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-22 19:04:38","2025-10-22 21:04:38","4810",NULL),
("7963","woocommerce_refresh_order_count_cache","complete","2025-10-22 09:01:01","2025-10-22 09:01:01","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761123661;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761123661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-22 19:04:38","2025-10-22 21:04:38","4810",NULL),
("7964","woocommerce_cleanup_draft_orders","complete","2025-10-23 19:04:38","2025-10-23 19:04:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761246278;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761246278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-23 19:15:24","2025-10-23 21:15:24","4816",NULL),
("7965","woocommerce_refresh_order_count_cache","complete","2025-10-23 07:04:38","2025-10-23 07:04:38","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761203078;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761203078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-23 13:31:47","2025-10-23 15:31:47","4814",NULL),
("7966","woocommerce_run_update_callback","complete","2025-10-22 19:04:48","2025-10-22 19:04:48","10","{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761159888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761159888;}","5","1","2025-10-23 02:01:14","2025-10-23 04:01:14","4812",NULL),
("7967","woocommerce_update_db_to_current_version","complete","2025-10-22 19:04:49","2025-10-22 19:04:49","10","{\"version\":\"10.3.0\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761159889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761159889;}","5","1","2025-10-23 02:01:14","2025-10-23 04:01:14","4812",NULL),
("7968","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2025-10-22 19:04:49","2025-10-22 19:04:49","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761159889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761159889;}","5","1","2025-10-23 02:01:14","2025-10-23 04:01:14","4812",NULL),
("7969","woocommerce_refresh_order_count_cache","complete","2025-10-24 01:31:47","2025-10-24 01:31:47","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761269507;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761269507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-24 03:04:48","2025-10-24 05:04:48","4821",NULL),
("7970","woocommerce_cleanup_draft_orders","complete","2025-10-24 19:15:24","2025-10-24 19:15:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761333324;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761333324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-24 23:07:35","2025-10-25 01:07:35","4834",NULL),
("7971","woocommerce_refresh_order_count_cache","complete","2025-10-24 15:04:48","2025-10-24 15:04:48","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761318288;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761318288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-24 15:26:03","2025-10-24 17:26:03","4830",NULL),
("7972","woocommerce_refresh_order_count_cache","complete","2025-10-25 03:26:03","2025-10-25 03:26:03","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761362763;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761362763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-25 14:19:28","2025-10-25 16:19:28","4841",NULL),
("7973","woocommerce_cleanup_draft_orders","complete","2025-10-25 23:07:35","2025-10-25 23:07:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761433655;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761433655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-26 03:49:28","2025-10-26 05:49:28","4853",NULL),
("7974","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2025-10-24 23:08:01","2025-10-24 23:08:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761347281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761347281;}","5","1","2025-10-24 23:08:23","2025-10-25 01:08:23","4836",NULL),
("7975","woocommerce_refresh_order_count_cache","complete","2025-10-26 02:19:28","2025-10-26 02:19:28","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761445168;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761445168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-26 03:49:30","2025-10-26 05:49:30","4854",NULL),
("7976","woocommerce_cleanup_draft_orders","complete","2025-10-27 03:49:28","2025-10-27 03:49:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761536968;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761536968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-28 16:53:54","2025-10-28 18:53:54","4866",NULL),
("7977","woocommerce_refresh_order_count_cache","complete","2025-10-26 15:49:30","2025-10-26 15:49:30","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761493770;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761493770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-27 01:13:29","2025-10-27 03:13:29","4863",NULL),
("7978","woocommerce_refresh_order_count_cache","complete","2025-10-27 13:13:29","2025-10-27 13:13:29","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761570809;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761570809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-28 16:53:54","2025-10-28 18:53:54","4866",NULL),
("7979","woocommerce_cleanup_draft_orders","complete","2025-10-29 16:53:54","2025-10-29 16:53:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761756834;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761756834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-30 11:51:30","2025-10-30 13:51:30","4871",NULL),
("7980","woocommerce_refresh_order_count_cache","complete","2025-10-29 04:53:54","2025-10-29 04:53:54","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761713634;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761713634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-29 05:25:15","2025-10-29 07:25:15","4868",NULL),
("7981","woocommerce_refresh_order_count_cache","complete","2025-10-29 17:25:15","2025-10-29 17:25:15","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761758715;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761758715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-30 11:51:30","2025-10-30 13:51:30","4871",NULL),
("7982","woocommerce_cleanup_draft_orders","complete","2025-10-31 11:51:30","2025-10-31 11:51:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761911490;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761911490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2025-10-31 13:30:01","2025-10-31 15:30:01","4885",NULL),
("7983","woocommerce_refresh_order_count_cache","complete","2025-10-30 23:51:30","2025-10-30 23:51:30","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761868290;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761868290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","1","2025-10-31 08:43:58","2025-10-31 10:43:58","4883",NULL),
("7984","woocommerce_refresh_order_count_cache","pending","2025-10-31 20:43:58","2025-10-31 20:43:58","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761943438;s:18:\"\0*\0first_timestamp\";i:1749627915;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761943438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","9","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7985","woocommerce_cleanup_draft_orders","pending","2025-11-01 13:30:01","2025-11-01 13:30:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762003801;s:18:\"\0*\0first_timestamp\";i:1704919841;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762003801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7986","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-31 13:33:40","2025-10-31 13:33:40","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761917620;s:18:\"\0*\0first_timestamp\";i:1761917620;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761917620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","11","1","2025-10-31 13:33:41","2025-10-31 15:33:41","4888",NULL),
("7987","woocommerce_scheduled_sales","pending","2025-10-31 22:00:00","2025-10-31 22:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761948000;s:18:\"\0*\0first_timestamp\";i:1761948000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761948000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7988","woocommerce_cancel_unpaid_orders","pending","2025-10-31 14:33:41","2025-10-31 14:33:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761921221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761921221;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7989","woocommerce_cleanup_personal_data","complete","2025-10-31 13:33:51","2025-10-31 13:33:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761917631;s:18:\"\0*\0first_timestamp\";i:1761917631;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761917631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","1","2025-10-31 13:34:03","2025-10-31 15:34:03","4891",NULL),
("7990","woocommerce_cleanup_logs","pending","2025-11-01 01:00:00","2025-11-01 01:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761958800;s:18:\"\0*\0first_timestamp\";i:1761958800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761958800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7991","woocommerce_cleanup_sessions","pending","2025-11-01 04:00:00","2025-11-01 04:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761969600;s:18:\"\0*\0first_timestamp\";i:1761969600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761969600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7992","woocommerce_geoip_updater","pending","2025-11-01 04:00:00","2025-11-01 04:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761969600;s:18:\"\0*\0first_timestamp\";i:1761969600;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761969600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7993","woocommerce_tracker_send_event_wrapper","complete","2025-10-31 13:33:51","2025-10-31 13:33:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761917631;s:18:\"\0*\0first_timestamp\";i:1761917631;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761917631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","1","2025-10-31 13:34:03","2025-10-31 15:34:03","4891",NULL),
("7994","woocommerce_cleanup_rate_limits_wrapper","pending","2025-11-01 01:00:00","2025-11-01 01:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761958800;s:18:\"\0*\0first_timestamp\";i:1761958800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761958800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7995","wc_admin_daily_wrapper","complete","2025-10-31 13:33:41","2025-10-31 13:33:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761917621;s:18:\"\0*\0first_timestamp\";i:1761917621;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761917621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","1","2025-10-31 13:33:41","2025-10-31 15:33:41","4889",NULL),
("7996","generate_category_lookup_table_wrapper","complete","2025-10-31 13:33:51","2025-10-31 13:33:51","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761917631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761917631;}","10","1","2025-10-31 13:34:03","2025-10-31 15:34:03","4891",NULL),
("7997","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-11-01 13:33:41","2025-11-01 13:33:41","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762004021;s:18:\"\0*\0first_timestamp\";i:1761917620;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762004021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","11","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7998","wc_admin_daily_wrapper","pending","2025-11-01 13:33:41","2025-11-01 13:33:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762004021;s:18:\"\0*\0first_timestamp\";i:1761917621;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762004021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("7999","woocommerce_cleanup_personal_data","pending","2025-11-01 13:34:03","2025-11-01 13:34:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762004043;s:18:\"\0*\0first_timestamp\";i:1761917631;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762004043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("8000","woocommerce_tracker_send_event_wrapper","pending","2025-11-01 13:34:03","2025-11-01 13:34:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762004043;s:18:\"\0*\0first_timestamp\";i:1761917631;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762004043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("8001","rank_math/analytics/data_fetch","pending","2025-11-01 01:23:00","2025-11-01 01:23:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761960180;s:18:\"\0*\0first_timestamp\";i:1761960180;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761960180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `wp_actionscheduler_claims` VALUES 
("1889","2024-10-10 09:56:55");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","rocket-preload"),
("4","woocommerce-remote-inbox-engine"),
("5","woocommerce-db-updates"),
("6","wc_update_product_default_cat"),
("7","rank-math"),
("8","rocket-performance-hints-warmup"),
("9","count"),
("10","woocommerce"),
("11","ActionScheduler");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("8","10","am creat acțiunea","2024-01-10 20:52:34","2024-01-10 20:52:34"),
("9","10","acțiune începută prin Async Request","2024-01-10 20:53:44","2024-01-10 20:53:44"),
("10","10","acțiune eșuată prin Async Request: Acțiunea programată pentru action_scheduler/migration_hook nu va fi executată, deoarece nu sunt înregistrate apeluri-înapoi.","2024-01-10 20:53:44","2024-01-10 20:53:44"),
("1778","600","am creat acțiunea","2024-02-05 21:22:14","2024-02-05 21:22:14"),
("1779","600","acțiune începută prin Async Request","2024-02-05 21:22:48","2024-02-05 21:22:48"),
("1780","600","acțiune eșuată prin Async Request: Acțiunea programată pentru woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications nu va fi executată, deoarece nu sunt înregistrate apeluri-înapoi.","2024-02-05 21:22:48","2024-02-05 21:22:48"),
("21792","7296","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21793","7297","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21794","7298","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21795","7299","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21796","7300","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21797","7301","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21798","7302","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21799","7303","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21800","7304","action created","2024-10-10 09:55:31","2024-10-10 09:55:31"),
("21841","7305","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21842","7306","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21843","7307","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21844","7308","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21845","7309","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21846","7310","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21847","7311","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21848","7312","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21849","7313","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21850","7314","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21851","7315","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21852","7316","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21853","7317","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21854","7318","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21855","7319","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21856","7320","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21857","7321","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21858","7322","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21859","7323","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21860","7324","action created","2024-10-10 09:56:30","2024-10-10 09:56:30"),
("21874","7325","action created","2024-10-10 09:57:04","2024-10-10 09:57:04"),
("21896","7296","action started via WP Cron","2024-10-10 09:57:17","2024-10-10 09:57:17"),
("21897","7297","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21898","7298","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21899","7299","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21900","7300","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21901","7301","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21902","7302","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21903","7303","action reset","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21904","7296","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21905","7297","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21906","7297","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21907","7298","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21908","7298","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21909","7299","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21910","7299","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21911","7300","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21912","7300","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21913","7301","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21914","7301","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21915","7302","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21916","7302","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21917","7303","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21918","7303","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21919","7304","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21920","7304","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21921","7305","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21922","7305","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21923","7306","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21924","7306","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21925","7307","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21926","7307","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21927","7308","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21928","7308","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21929","7309","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21930","7309","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21931","7310","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21932","7310","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21933","7311","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21934","7311","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21935","7312","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21936","7312","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21937","7313","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21938","7313","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21939","7314","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21940","7314","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21941","7315","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21942","7315","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21943","7316","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21944","7316","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21945","7317","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21946","7317","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21947","7318","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21948","7318","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21949","7319","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21950","7319","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21951","7320","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21952","7320","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21953","7321","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21954","7321","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21955","7322","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21956","7322","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21957","7323","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21958","7323","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21959","7324","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21960","7324","action failed via WP Cron: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21961","7325","action started via WP Cron","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("21962","7325","action failed via WP Cron: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2024-10-22 11:03:09","2024-10-22 11:03:09"),
("22367","7461","action created","2024-10-23 05:42:28","2024-10-23 05:42:28"),
("22501","7461","action started via WP Cron","2024-12-06 14:23:55","2024-12-06 14:23:55"),
("22502","7461","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-06 14:23:55","2024-12-06 14:23:55"),
("22503","7507","action created","2024-12-06 14:23:55","2024-12-06 14:23:55"),
("22539","7519","action created","2024-12-09 09:26:39","2024-12-09 09:26:39"),
("22540","7519","action started via WP Cron","2024-12-09 09:27:52","2024-12-09 09:27:52"),
("22541","7519","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-12-09 09:27:52","2024-12-09 09:27:52"),
("22584","7507","action started via WP Cron","2024-12-14 20:13:33","2024-12-14 20:13:33"),
("22585","7507","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-14 20:13:33","2024-12-14 20:13:33"),
("22586","7534","action created","2024-12-14 20:13:33","2024-12-14 20:13:33"),
("22596","7534","action started via WP Cron","2024-12-18 09:24:34","2024-12-18 09:24:34"),
("22597","7534","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-18 09:24:34","2024-12-18 09:24:34"),
("22598","7538","action created","2024-12-18 09:24:34","2024-12-18 09:24:34"),
("22611","7538","action started via WP Cron","2024-12-22 13:41:02","2024-12-22 13:41:02"),
("22612","7538","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-22 13:41:02","2024-12-22 13:41:02"),
("22613","7543","action created","2024-12-22 13:41:02","2024-12-22 13:41:02"),
("22617","7543","action started via WP Cron","2024-12-25 14:35:14","2024-12-25 14:35:14"),
("22618","7543","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-25 14:35:14","2024-12-25 14:35:14"),
("22619","7543","This action appears to be consistently failing. A new instance will not be scheduled.","2024-12-25 14:35:14","2024-12-25 14:35:14"),
("23742","7919","am creat acțiunea","2025-09-29 03:43:40","2025-09-29 03:43:40"),
("23745","7920","am creat acțiunea","2025-09-29 13:59:08","2025-09-29 13:59:08"),
("23746","7920","acțiune începută prin WP Cron","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23747","7920","acțiune finalizată prin WP Cron","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23748","7921","am creat acțiunea","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23749","7919","acțiune începută prin WP Cron","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23750","7919","acțiune finalizată prin WP Cron","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23751","7922","am creat acțiunea","2025-09-30 17:12:48","2025-09-30 17:12:48"),
("23752","7923","am creat acțiunea","2025-09-30 17:13:00","2025-09-30 17:13:00"),
("23753","7923","acțiune începută prin WP Cron","2025-09-30 17:36:54","2025-09-30 17:36:54"),
("23754","7923","acțiune finalizată prin WP Cron","2025-09-30 17:36:54","2025-09-30 17:36:54"),
("23755","7921","acțiune începută prin WP Cron","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23756","7921","acțiune finalizată prin WP Cron","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23757","7924","am creat acțiunea","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23758","7922","acțiune începută prin WP Cron","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23759","7922","acțiune finalizată prin WP Cron","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23760","7925","am creat acțiunea","2025-10-01 17:14:10","2025-10-01 17:14:10"),
("23761","7924","acțiune începută prin WP Cron","2025-10-02 08:05:16","2025-10-02 08:05:16"),
("23762","7924","acțiune finalizată prin WP Cron","2025-10-02 08:05:16","2025-10-02 08:05:16"),
("23763","7926","am creat acțiunea","2025-10-02 08:05:16","2025-10-02 08:05:16"),
("23764","7925","acțiune începută prin WP Cron","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23765","7925","acțiune finalizată prin WP Cron","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23766","7927","am creat acțiunea","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23767","7926","acțiune începută prin WP Cron","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23768","7926","acțiune finalizată prin WP Cron","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23769","7928","am creat acțiunea","2025-10-03 07:11:27","2025-10-03 07:11:27"),
("23770","7928","acțiune începută prin WP Cron","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23771","7928","acțiune finalizată prin WP Cron","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23772","7929","am creat acțiunea","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23773","7927","acțiune începută prin WP Cron","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23774","7927","acțiune finalizată prin WP Cron","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23775","7930","am creat acțiunea","2025-10-05 04:11:52","2025-10-05 04:11:52"),
("23776","7929","acțiune începută prin WP Cron","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23777","7929","acțiune finalizată prin WP Cron","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23778","7931","am creat acțiunea","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23779","7930","acțiune începută prin WP Cron","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23780","7930","acțiune finalizată prin WP Cron","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23781","7932","am creat acțiunea","2025-10-06 18:06:28","2025-10-06 18:06:28"),
("23782","7931","acțiune începută prin WP Cron","2025-10-07 08:17:00","2025-10-07 08:17:00"),
("23783","7931","acțiune finalizată prin WP Cron","2025-10-07 08:17:00","2025-10-07 08:17:00"),
("23784","7933","am creat acțiunea","2025-10-07 08:17:00","2025-10-07 08:17:00"),
("23785","7932","acțiune începută prin WP Cron","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23786","7932","acțiune finalizată prin WP Cron","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23787","7934","am creat acțiunea","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23788","7933","acțiune începută prin WP Cron","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23789","7933","acțiune finalizată prin WP Cron","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23790","7935","am creat acțiunea","2025-10-08 11:59:44","2025-10-08 11:59:44"),
("23791","7935","acțiune începută prin WP Cron","2025-10-09 00:22:53","2025-10-09 00:22:53"),
("23792","7935","acțiune finalizată prin WP Cron","2025-10-09 00:22:53","2025-10-09 00:22:53"),
("23793","7936","am creat acțiunea","2025-10-09 00:22:53","2025-10-09 00:22:53"),
("23794","7934","acțiune începută prin WP Cron","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23795","7934","acțiune finalizată prin WP Cron","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23796","7937","am creat acțiunea","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23797","7936","acțiune începută prin WP Cron","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23798","7936","acțiune finalizată prin WP Cron","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23799","7938","am creat acțiunea","2025-10-09 22:53:08","2025-10-09 22:53:08"),
("23800","7938","acțiune începută prin WP Cron","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23801","7938","acțiune finalizată prin WP Cron","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23802","7939","am creat acțiunea","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23803","7937","acțiune începută prin WP Cron","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23804","7937","acțiune finalizată prin WP Cron","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23805","7940","am creat acțiunea","2025-10-11 07:37:29","2025-10-11 07:37:29"),
("23806","7939","acțiune începută prin WP Cron","2025-10-12 06:07:51","2025-10-12 06:07:51"),
("23807","7939","acțiune finalizată prin WP Cron","2025-10-12 06:07:51","2025-10-12 06:07:51"),
("23808","7941","am creat acțiunea","2025-10-12 06:07:51","2025-10-12 06:07:51"),
("23809","7940","acțiune începută prin WP Cron","2025-10-12 17:40:11","2025-10-12 17:40:11"),
("23810","7940","acțiune finalizată prin WP Cron","2025-10-12 17:40:11","2025-10-12 17:40:11"),
("23811","7942","am creat acțiunea","2025-10-12 17:40:11","2025-10-12 17:40:11"),
("23812","7941","acțiune începută prin WP Cron","2025-10-12 20:17:13","2025-10-12 20:17:13"),
("23813","7941","acțiune finalizată prin WP Cron","2025-10-12 20:17:13","2025-10-12 20:17:13"),
("23814","7943","am creat acțiunea","2025-10-12 20:17:13","2025-10-12 20:17:13"),
("23815","7943","acțiune începută prin WP Cron","2025-10-13 12:26:20","2025-10-13 12:26:20"),
("23816","7943","acțiune finalizată prin WP Cron","2025-10-13 12:26:20","2025-10-13 12:26:20"),
("23817","7944","am creat acțiunea","2025-10-13 12:26:20","2025-10-13 12:26:20"),
("23818","7942","acțiune începută prin WP Cron","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23819","7942","acțiune finalizată prin WP Cron","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23820","7945","am creat acțiunea","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23821","7944","acțiune începută prin WP Cron","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23822","7944","acțiune finalizată prin WP Cron","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23823","7946","am creat acțiunea","2025-10-14 09:27:33","2025-10-14 09:27:33"),
("23824","7946","acțiune începută prin WP Cron","2025-10-15 03:46:39","2025-10-15 03:46:39"),
("23825","7946","acțiune finalizată prin WP Cron","2025-10-15 03:46:39","2025-10-15 03:46:39"),
("23826","7947","am creat acțiunea","2025-10-15 03:46:39","2025-10-15 03:46:39"),
("23827","7945","acțiune începută prin WP Cron","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23828","7945","acțiune finalizată prin WP Cron","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23829","7948","am creat acțiunea","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23830","7947","acțiune începută prin WP Cron","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23831","7947","acțiune finalizată prin WP Cron","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23832","7949","am creat acțiunea","2025-10-15 17:06:29","2025-10-15 17:06:29"),
("23833","7949","acțiune începută prin WP Cron","2025-10-16 11:37:34","2025-10-16 11:37:34"),
("23834","7949","acțiune finalizată prin WP Cron","2025-10-16 11:37:34","2025-10-16 11:37:34"),
("23835","7950","am creat acțiunea","2025-10-16 11:37:34","2025-10-16 11:37:34"),
("23836","7948","acțiune începută prin WP Cron","2025-10-16 21:03:08","2025-10-16 21:03:08"),
("23837","7948","acțiune finalizată prin WP Cron","2025-10-16 21:03:08","2025-10-16 21:03:08"),
("23838","7951","am creat acțiunea","2025-10-16 21:03:08","2025-10-16 21:03:08"),
("23839","7950","acțiune începută prin WP Cron","2025-10-17 04:38:56","2025-10-17 04:38:56"),
("23840","7950","acțiune finalizată prin WP Cron","2025-10-17 04:38:56","2025-10-17 04:38:56"),
("23841","7952","am creat acțiunea","2025-10-17 04:38:56","2025-10-17 04:38:56"),
("23842","7952","acțiune începută prin WP Cron","2025-10-17 19:33:02","2025-10-17 19:33:02"),
("23843","7952","acțiune finalizată prin WP Cron","2025-10-17 19:33:03","2025-10-17 19:33:03"),
("23844","7953","am creat acțiunea","2025-10-17 19:33:03","2025-10-17 19:33:03"),
("23845","7951","acțiune începută prin WP Cron","2025-10-17 22:49:13","2025-10-17 22:49:13"),
("23846","7951","acțiune finalizată prin WP Cron","2025-10-17 22:49:13","2025-10-17 22:49:13"),
("23847","7954","am creat acțiunea","2025-10-17 22:49:13","2025-10-17 22:49:13"),
("23848","7953","acțiune începută prin WP Cron","2025-10-18 10:32:59","2025-10-18 10:32:59"),
("23849","7953","acțiune finalizată prin WP Cron","2025-10-18 10:32:59","2025-10-18 10:32:59"),
("23850","7955","am creat acțiunea","2025-10-18 10:32:59","2025-10-18 10:32:59"),
("23851","7955","acțiune începută prin WP Cron","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23852","7955","acțiune finalizată prin WP Cron","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23853","7956","am creat acțiunea","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23854","7954","acțiune începută prin WP Cron","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23855","7954","acțiune finalizată prin WP Cron","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23856","7957","am creat acțiunea","2025-10-19 02:43:49","2025-10-19 02:43:49"),
("23857","7956","acțiune începută prin WP Cron","2025-10-19 21:27:26","2025-10-19 21:27:26"),
("23858","7956","acțiune finalizată prin WP Cron","2025-10-19 21:27:26","2025-10-19 21:27:26"),
("23859","7958","am creat acțiunea","2025-10-19 21:27:26","2025-10-19 21:27:26"),
("23860","7957","acțiune începută prin WP Cron","2025-10-20 06:08:13","2025-10-20 06:08:13"),
("23861","7957","acțiune finalizată prin WP Cron","2025-10-20 06:08:13","2025-10-20 06:08:13"),
("23862","7959","am creat acțiunea","2025-10-20 06:08:13","2025-10-20 06:08:13"),
("23863","7958","acțiune începută prin WP Cron","2025-10-20 12:13:09","2025-10-20 12:13:09"),
("23864","7958","acțiune finalizată prin WP Cron","2025-10-20 12:13:09","2025-10-20 12:13:09"),
("23865","7960","am creat acțiunea","2025-10-20 12:13:09","2025-10-20 12:13:09"),
("23866","7960","acțiune începută prin WP Cron","2025-10-21 08:16:28","2025-10-21 08:16:28"),
("23867","7960","acțiune finalizată prin WP Cron","2025-10-21 08:16:29","2025-10-21 08:16:29"),
("23868","7961","am creat acțiunea","2025-10-21 08:16:29","2025-10-21 08:16:29"),
("23869","7959","acțiune începută prin WP Cron","2025-10-21 08:16:29","2025-10-21 08:16:29"),
("23870","7959","acțiune finalizată prin WP Cron","2025-10-21 08:16:29","2025-10-21 08:16:29"),
("23871","7962","am creat acțiunea","2025-10-21 08:16:29","2025-10-21 08:16:29"),
("23872","7961","acțiune începută prin WP Cron","2025-10-21 21:01:01","2025-10-21 21:01:01"),
("23873","7961","acțiune finalizată prin WP Cron","2025-10-21 21:01:01","2025-10-21 21:01:01"),
("23874","7963","am creat acțiunea","2025-10-21 21:01:01","2025-10-21 21:01:01"),
("23875","7962","acțiune începută prin WP Cron","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23876","7962","acțiune finalizată prin WP Cron","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23877","7964","am creat acțiunea","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23878","7963","acțiune începută prin WP Cron","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23879","7963","acțiune finalizată prin WP Cron","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23880","7965","am creat acțiunea","2025-10-22 19:04:38","2025-10-22 19:04:38"),
("23881","7966","am creat acțiunea","2025-10-22 19:04:48","2025-10-22 19:04:48"),
("23882","7967","am creat acțiunea","2025-10-22 19:04:48","2025-10-22 19:04:48"),
("23883","7968","am creat acțiunea","2025-10-22 19:04:48","2025-10-22 19:04:48"),
("23884","7966","acțiune începută prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23885","7966","acțiune finalizată prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23886","7967","acțiune începută prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23887","7967","acțiune finalizată prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23888","7968","acțiune începută prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23889","7968","acțiune finalizată prin WP Cron","2025-10-23 02:01:14","2025-10-23 02:01:14"),
("23890","7965","acțiune începută prin WP Cron","2025-10-23 13:31:47","2025-10-23 13:31:47"),
("23891","7965","acțiune finalizată prin WP Cron","2025-10-23 13:31:47","2025-10-23 13:31:47"),
("23892","7969","am creat acțiunea","2025-10-23 13:31:47","2025-10-23 13:31:47"),
("23893","7964","acțiune începută prin WP Cron","2025-10-23 19:15:24","2025-10-23 19:15:24"),
("23894","7964","acțiune finalizată prin WP Cron","2025-10-23 19:15:24","2025-10-23 19:15:24"),
("23895","7970","am creat acțiunea","2025-10-23 19:15:24","2025-10-23 19:15:24"),
("23896","7969","acțiune începută prin WP Cron","2025-10-24 03:04:48","2025-10-24 03:04:48"),
("23897","7969","acțiune finalizată prin WP Cron","2025-10-24 03:04:48","2025-10-24 03:04:48"),
("23898","7971","am creat acțiunea","2025-10-24 03:04:48","2025-10-24 03:04:48"),
("23899","7971","acțiune începută prin WP Cron","2025-10-24 15:26:03","2025-10-24 15:26:03"),
("23900","7971","acțiune finalizată prin WP Cron","2025-10-24 15:26:03","2025-10-24 15:26:03"),
("23901","7972","am creat acțiunea","2025-10-24 15:26:03","2025-10-24 15:26:03"),
("23902","7970","acțiune începută prin WP Cron","2025-10-24 23:07:35","2025-10-24 23:07:35"),
("23903","7970","acțiune finalizată prin WP Cron","2025-10-24 23:07:35","2025-10-24 23:07:35"),
("23904","7973","am creat acțiunea","2025-10-24 23:07:35","2025-10-24 23:07:35"),
("23905","7974","am creat acțiunea","2025-10-24 23:08:00","2025-10-24 23:08:00"),
("23906","7974","acțiune începută prin WP Cron","2025-10-24 23:08:23","2025-10-24 23:08:23"),
("23907","7974","acțiune finalizată prin WP Cron","2025-10-24 23:08:23","2025-10-24 23:08:23"),
("23908","7972","acțiune începută prin WP Cron","2025-10-25 14:19:28","2025-10-25 14:19:28"),
("23909","7972","acțiune finalizată prin WP Cron","2025-10-25 14:19:28","2025-10-25 14:19:28"),
("23910","7975","am creat acțiunea","2025-10-25 14:19:28","2025-10-25 14:19:28"),
("23911","7973","acțiune începută prin WP Cron","2025-10-26 03:49:28","2025-10-26 03:49:28"),
("23912","7973","acțiune finalizată prin WP Cron","2025-10-26 03:49:28","2025-10-26 03:49:28"),
("23913","7976","am creat acțiunea","2025-10-26 03:49:28","2025-10-26 03:49:28"),
("23914","7975","acțiune începută prin Async Request","2025-10-26 03:49:30","2025-10-26 03:49:30"),
("23915","7975","acțiune finalizată prin Async Request","2025-10-26 03:49:30","2025-10-26 03:49:30"),
("23916","7977","am creat acțiunea","2025-10-26 03:49:30","2025-10-26 03:49:30"),
("23917","7977","acțiune începută prin WP Cron","2025-10-27 01:13:29","2025-10-27 01:13:29"),
("23918","7977","acțiune finalizată prin WP Cron","2025-10-27 01:13:29","2025-10-27 01:13:29"),
("23919","7978","am creat acțiunea","2025-10-27 01:13:29","2025-10-27 01:13:29"),
("23920","7976","acțiune începută prin WP Cron","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23921","7976","acțiune finalizată prin WP Cron","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23922","7979","am creat acțiunea","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23923","7978","acțiune începută prin WP Cron","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23924","7978","acțiune finalizată prin WP Cron","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23925","7980","am creat acțiunea","2025-10-28 16:53:54","2025-10-28 16:53:54"),
("23926","7980","acțiune începută prin WP Cron","2025-10-29 05:25:15","2025-10-29 05:25:15"),
("23927","7980","acțiune finalizată prin WP Cron","2025-10-29 05:25:15","2025-10-29 05:25:15"),
("23928","7981","am creat acțiunea","2025-10-29 05:25:15","2025-10-29 05:25:15"),
("23929","7979","acțiune începută prin WP Cron","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23930","7979","acțiune finalizată prin WP Cron","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23931","7982","am creat acțiunea","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23932","7981","acțiune începută prin WP Cron","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23933","7981","acțiune finalizată prin WP Cron","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23934","7983","am creat acțiunea","2025-10-30 11:51:30","2025-10-30 11:51:30"),
("23935","7983","acțiune începută prin WP Cron","2025-10-31 08:43:58","2025-10-31 08:43:58"),
("23936","7983","acțiune finalizată prin WP Cron","2025-10-31 08:43:58","2025-10-31 08:43:58"),
("23937","7984","am creat acțiunea","2025-10-31 08:43:58","2025-10-31 08:43:58"),
("23938","7982","acțiune începută prin WP Cron","2025-10-31 13:30:01","2025-10-31 13:30:01"),
("23939","7982","acțiune finalizată prin WP Cron","2025-10-31 13:30:01","2025-10-31 13:30:01"),
("23940","7985","am creat acțiunea","2025-10-31 13:30:01","2025-10-31 13:30:01"),
("23941","7986","am creat acțiunea","2025-10-31 13:33:40","2025-10-31 13:33:40"),
("23942","7986","acțiune începută prin WP Cron","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23943","7987","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23944","7988","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23945","7989","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23946","7990","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23947","7991","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23948","7992","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23949","7993","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23950","7994","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23951","7995","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23952","7996","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23953","7986","acțiune finalizată prin WP Cron","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23954","7997","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23955","7995","acțiune începută prin WP Cron","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23956","7995","acțiune finalizată prin WP Cron","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23957","7998","am creat acțiunea","2025-10-31 13:33:41","2025-10-31 13:33:41"),
("23958","7989","acțiune începută prin Async Request","2025-10-31 13:34:02","2025-10-31 13:34:02"),
("23959","7989","acțiune finalizată prin Async Request","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23960","7999","am creat acțiunea","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23961","7993","acțiune începută prin Async Request","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23962","7993","acțiune finalizată prin Async Request","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23963","8000","am creat acțiunea","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23964","7996","acțiune începută prin Async Request","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23965","7996","acțiune finalizată prin Async Request","2025-10-31 13:34:03","2025-10-31 13:34:03"),
("23966","8001","am creat acțiunea","2025-10-31 13:41:32","2025-10-31 13:41:32");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("10","20251031_realizaremagazinonlinelacheiecosmet","228c379e996ac7f17017_20251031140410","20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_archive.zip","20","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 10,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.11.14\",\n    \"VersionPHP\": \"8.3.26\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20251031_realizaremagazinonlinelacheiecosmet\",\n    \"Hash\": \"228c379e996ac7f17017_20251031140410\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_scan.json\",\n    \"timer_start\": 1761919468.155729,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.opcache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.tmb\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/bps-backup\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/cache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/old-cache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/updraft\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wfcache\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.htaccess\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.user.ini\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/php.ini\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/web.config\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-config.php\",\n            \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\",\n        \"Size\": 512044198,\n        \"Dirs\": [],\n        \"DirCount\": 4862,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 30462,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 266986349,\n                        \"bytes\": \"254.62MB\",\n                        \"nodes\": 23759,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 451687916,\n                        \"bytes\": \"430.76MB\",\n                        \"nodes\": 32227,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-snapshots\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.opcache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.tmb\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/old-cache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/updraft\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/wfcache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/cache\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.htaccess\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/.user.ini\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/php.ini\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/web.config\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/debug.log\",\n                    \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"JcUGmGWWsGltDUankIY1xRnLRjnGHaJAerbIFlOdqRcSvwymQX5iiMyANUPyEJ1o81FeE\\/SZZjW6Q450G\\/XDcw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"depozitul_la-cheie-cosmetice-diverse\",\n            \"tablesBaseCount\": 89,\n            \"tablesFinalCount\": 89,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7266,\n            \"tablesSizeOnDisk\": 31309824,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"121\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"342\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_ewwwio_images\": {\n                    \"inaccurateRows\": \"972\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wp_ewwwio_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"996\",\n                    \"insertedRows\": 0,\n                    \"size\": 5799936\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"2782\",\n                    \"insertedRows\": 0,\n                    \"size\": 10584064\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"257\",\n                    \"insertedRows\": 0,\n                    \"size\": 9011200\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_analytics_gsc\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_rank_math_analytics_inspections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_rank_math_analytics_keyword_manager\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_analytics_objects\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"295\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"177\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"142\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"214\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"142\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"164\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_wacv_abandoned_cart_record\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wacv_cart_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wacv_email_history\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wacv_guest_info_record\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"103\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"154\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.14\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/depozitul\\/public_html\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-content\\/backups-dup-pro\\/tmp\\/20251031_realizaremagazinonlinelacheiecosmet_228c379e996ac7f17017_20251031140410_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1761919471,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_ewwwio_images\",\n            \"wp_ewwwio_queue\",\n            \"wp_e_events\",\n            \"wp_e_notes\",\n            \"wp_e_notes_users_relations\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_jetpack_sync_queue\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_rank_math_404_logs\",\n            \"wp_rank_math_analytics_gsc\",\n            \"wp_rank_math_analytics_inspections\",\n            \"wp_rank_math_analytics_keyword_manager\",\n            \"wp_rank_math_analytics_objects\",\n            \"wp_rank_math_internal_links\",\n            \"wp_rank_math_internal_meta\",\n            \"wp_rank_math_redirections\",\n            \"wp_rank_math_redirections_cache\",\n            \"wp_revslider_css\",\n            \"wp_revslider_css_bkp\",\n            \"wp_revslider_layer_animations\",\n            \"wp_revslider_layer_animations_bkp\",\n            \"wp_revslider_navigations\",\n            \"wp_revslider_navigations_bkp\",\n            \"wp_revslider_sliders\",\n            \"wp_revslider_sliders_bkp\",\n            \"wp_revslider_slides\",\n            \"wp_revslider_slides_bkp\",\n            \"wp_revslider_static_slides\",\n            \"wp_revslider_static_slides_bkp\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_wacv_abandoned_cart_record\",\n            \"wp_wacv_cart_log\",\n            \"wp_wacv_email_history\",\n            \"wp_wacv_guest_info_record\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_wpr_above_the_fold\",\n            \"wp_wpr_rocket_cache\",\n            \"wp_wpr_rucss_used_css\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1761919468.178071,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 7267,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ewwwio_images\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ewwwio_queue\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_analytics_gsc\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_analytics_inspections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_analytics_keyword_manager\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_analytics_objects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_redirections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wacv_abandoned_cart_record\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wacv_cart_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wacv_email_history\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wacv_guest_info_record\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.20\",\n    \"created\": \"2025-10-31 14:04:10\",\n    \"updated\": \"2025-10-31 14:04:31\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.20","2025-10-31 14:04:10","2025-10-31 14:04:31");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"demo@depozitul-de-magazine.ro\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"demo@depozitul-de-magazine.ro\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/la-cheie.depozitul-de-magazine.ro\\/cosmetice-diverse\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1704987222,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-01-11 15:33:42\",\n    \"updated\": \"2025-10-31 14:04:10\"\n}","4.5.20","2024-01-11 15:33:42","2025-10-31 14:04:10"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-01-11 15:33:42\",\n    \"updated\": \"2025-01-10 08:04:45\"\n}","4.5.20","2024-01-11 15:33:42","2025-01-10 08:04:45"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"xkkJX6\\/7irMVDFh0+WfGTXKAOJPhJSKFcdwKxhZm90WH3VFlSFklnDXoerKPM1eG+4pOIgPirJL7o+kXOBIqtaVNVSN9vJd6WCa4QPIjzT527TuKyIGbhOKCOpf3w7VdcpoyoiqSDv\\/5\\/D4v3KfbV6xbxvoEW3u983yHh+MfR1jz6XrhMZHu\\/7B2K9wD1\\/8IIZJxgk4AG67ldfI3zZ9lQ2bm3CLriRlXwUTViGGLw1aoGcYwu5\\/PEl0HgWNW9k8c4sfEFYYJzjJ\\/1tqMFHUeH7ASrLcDVe\\/qlVsMYCBhPgyVHs6TXD0HMZYniQXeypSKWRlJ2rBsU8rWfXXwRflJZTy5McF71TKJ\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-01-11 15:33:42\",\n    \"updated\": \"2025-01-10 08:04:45\"\n}","4.5.20","2024-01-11 15:33:42","2025-01-10 08:04:45"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"\",\n    \"updated\": \"2025-10-28 16:54:07\"\n}","4.5.20","0000-00-00 00:00:00","2025-10-28 16:54:07"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"getmQO\\/Y5Xk6UmpM\\/GGD8fqRuS2ePlU7\\/rlubk5D6x0nq4g2U7pUYQ9SJ\\/\\/bpcI4AY6RpYHNRoQQOAB5areNMw==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14\",\n    \"created\": \"2024-01-11 15:33:42\",\n    \"updated\": \"2024-01-11 15:33:42\"\n}","4.5.14","2024-01-11 15:33:42","2024-01-11 15:33:42"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"JTpgLwYhHfPFrirdWaBfqNYprd96jHDHXcNSwxppRDSRyb9SHFP4dCfp8YjAFNWtlVLtAxr2E2RSpZBy3TgjYA==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-01-11 15:33:42\",\n    \"updated\": \"2025-10-31 14:04:10\"\n}","4.5.20","2024-01-11 15:33:42","2025-10-31 14:04:10"),
("7","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1761919466,\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-01-11 15:33:43\",\n    \"updated\": \"2025-10-31 14:04:26\"\n}","4.5.20","2024-01-11 15:33:43","2025-10-31 14:04:26"),
("8","Dynamic_Entity","","","","","","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2025-01-10 08:04:45\",\n    \"updated\": \"2025-01-10 08:04:45\"\n}","4.5.20","2025-01-10 08:04:45","2025-01-10 08:04:45"),
("9","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"VnCg2Bz\\/OYOPXO3RFxwICK0N\\/mtCMa83c+UIrPL4NGltVckL7HhsvMbG5EORJCUO2Iz1etxqZSUINA0LiGWBR2T8ROagk0IKxi9LiNDSAM8biUPc7m26ZaOTeUK+b5tX\",\n    \"status\": \"hLI5v8AxrIB3qWALpymxgvI1yO2o68Jx2KJPqTM\\/tEDuIx4JCX+dRV9G3bCrQ3QOyCHff08vs5kj1lWm+fLFCxD9yxanDkm0\",\n    \"type\": \"VzuGU7u9ojWteUXMnoTNLjpN8zkZhZq60yM1VXDa+Zu9VUIQ7nsOiQVlvVefChdX650J5U+5RBvxNURy9pJXjhZjWs9D32PS\",\n    \"data\": \"358Uc8F3L\\/gZVUkpAcMXF8SXg6iTrYN68OvX2Fra30nh+1BlbsHHfbsxzEk3xH+b62Jkff+syuDwsqMkaCjyviF0LkjkLemMi0zSSv0be\\/0tv5DyUSx4EWk5l5A7UZsgi6mxRcv+sds8UbkRaYscZ38HwPp9ISA7M2KA0BzP4pFzQ0G0PnzyoDFV4U8J62xWNbUOGfOXvOtUfl9yh0OWP2mvLf1Opk0TDzSN1VXLfkZIx2y1HUGPn+tiZH3\\/rMrgCUIwYKhy27smWFkG4eVuEjAo4F8BQH2QZvxrU9v3t\\/kkNBkxTw1rcuzdCcqhFpr7aIzZ3bZg2+sLXfAKM7\\/my5RY5K\\/0pi6rOOFykRO35uhBJ4upG0xATfNw9BPvAW\\/smxYl1MLD74wMvXq9D37a\\/DvkuuBRL\\/KK6h8fY5Ci1M8=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2025-01-10 08:04:45\",\n    \"updated\": \"2025-10-31 14:04:31\"\n}","4.5.20","2025-01-10 08:04:45","2025-10-31 14:04:31");

INSERT IGNORE INTO `wp_ewwwio_images` VALUES 
("1",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme-child/screenshot.png","","316841","316841","","10","0","1","2024-01-10 23:16:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("2",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/assets/jplayer/css/jplayer.png","","507","1494","","10","0","1","2024-01-10 23:16:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("3",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/assets/jplayer/css/jplayer.blue.monday.video.play.png","","4080","4080","","10","0","1","2024-01-10 23:16:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("4",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/assets/jplayer/css/jplayer.blue.monday.seeking.gif","","3284","3284","","10","0","1","2024-01-10 23:16:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("5",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/assets/jplayer/css/jplayer.blue.monday.jpg","","18277","18277","","10","0","1","2024-01-10 23:16:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("6",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/admin/assets/images/icon-youtube.png","","1857","2287","","10","0","1","2024-01-10 23:16:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("7",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/admin/assets/images/video.jpg","","23627","23627","","10","0","1","2024-01-10 23:16:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("8",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/admin/setup/assets/images/code.png","","4989","14995","","10","0","1","2024-01-10 23:16:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("9",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/admin/setup/assets/images/placeholder.png","","112","651","","10","0","1","2024-01-10 23:16:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("10",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/admin/setup/assets/images/visual.png","","4289","13291","","10","0","1","2024-01-10 23:16:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("11",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/content.png","","1050","3766","","10","0","1","2024-01-10 23:16:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("12",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/faq.png","","368","3146","","10","0","1","2024-01-10 23:16:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("13",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/clients.png","","1231","3947","","10","0","1","2024-01-10 23:16:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("14",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/portfolio.png","","615","3370","","10","0","1","2024-01-10 23:16:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("15",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/photo_box.png","","674","1525","","10","0","1","2024-01-10 23:16:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("16",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/portfolio_photo.png","","419","1277","","10","0","1","2024-01-10 23:16:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("17",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/feature_list.png","","114","995","","10","0","1","2024-01-10 23:16:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("18",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/slider_plugin.png","","696","1553","","10","0","1","2024-01-10 23:16:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("19",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/helper.png","","282","282","","10","0","1","2024-01-10 23:16:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("20",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/trailer_box.png","","672","1523","","10","0","1","2024-01-10 23:16:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("21",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/call_to_action.png","","366","3082","","10","0","1","2024-01-10 23:16:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("22",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/our_team_list.png","","346","1197","","10","0","1","2024-01-10 23:16:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("23",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/timeline.png","","359","3187","","10","0","1","2024-01-10 23:16:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("24",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/testimonials.png","","658","3374","","10","0","1","2024-01-10 23:16:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("25",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/column.png","","311","3137","","10","0","1","2024-01-10 23:16:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("26",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/flat_box.png","","544","1395","","10","0","1","2024-01-10 23:16:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("27",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/accordion.png","","277","3042","","10","0","1","2024-01-10 23:16:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("28",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/promo_box.png","","410","1294","","10","0","1","2024-01-10 23:16:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("29",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/clients_slider.png","","950","1801","","10","0","1","2024-01-10 23:16:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("30",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/testimonials_page.png","","435","3151","","10","0","1","2024-01-10 23:16:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("31",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/contact_box.png","","351","3121","","10","0","1","2024-01-10 23:16:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("32",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/testimonials_list.png","","483","1334","","10","0","1","2024-01-10 23:16:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("33",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/progress_bars.png","","176","2944","","10","0","1","2024-01-10 23:16:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("34",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/hover_box.png","","736","1587","","10","0","1","2024-01-10 23:16:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("35",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/shop.png","","679","728","","10","0","1","2024-01-10 23:16:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("36",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/tabs.png","","313","3090","","10","0","1","2024-01-10 23:16:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("37",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/map.png","","823","860","","10","0","1","2024-01-10 23:16:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("38",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/how_it_works.png","","533","1578","","10","0","1","2024-01-10 23:16:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("39",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/vimeo.png","","881","3597","","10","0","1","2024-01-10 23:16:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("40",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/fancy_heading.png","","383","3162","","10","0","1","2024-01-10 23:16:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("41",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/countdown.png","","604","1483","","10","0","1","2024-01-10 23:16:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("42",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/image.png","","834","3550","","10","0","1","2024-01-10 23:16:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("43",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/offer_thumb.png","","699","1550","","10","0","1","2024-01-10 23:16:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("44",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/blog.png","","430","3222","","10","0","1","2024-01-10 23:16:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("45",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/code.png","","746","3462","","10","0","1","2024-01-10 23:16:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("46",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/chart.png","","481","1624","","10","0","1","2024-01-10 23:16:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("47",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/offer.png","","332","3109","","10","0","1","2024-01-10 23:16:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("48",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/feature_box.png","","304","304","","10","0","1","2024-01-10 23:16:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("49",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/video_box.png","","348","1248","","10","0","1","2024-01-10 23:16:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("50",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/article_box.png","","623","3339","","10","0","1","2024-01-10 23:16:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("51",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/slider.png","","696","1553","","10","0","1","2024-01-10 23:16:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("52",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/info_box.png","","219","2995","","10","0","1","2024-01-10 23:16:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("53",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/hover_color.png","","487","1446","","10","0","1","2024-01-10 23:16:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("54",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/blog_slider.png","","700","1562","","10","0","1","2024-01-10 23:16:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("55",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/quick_fact.png","","432","1344","","10","0","1","2024-01-10 23:16:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("56",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/alert.png","","328","1216","","10","0","1","2024-01-10 23:16:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("57",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/portfolio_grid.png","","441","1376","","10","0","1","2024-01-10 23:16:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("58",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/video.png","","292","1188","","10","0","1","2024-01-10 23:16:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("59",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/pricing_item.png","","339","3157","","10","0","1","2024-01-10 23:16:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("60",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/before_after.png","","226","227","","10","0","1","2024-01-10 23:16:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("61",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/youtube.png","","1018","3734","","10","0","1","2024-01-10 23:16:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("62",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/latest_posts.png","","430","3222","","10","0","1","2024-01-10 23:16:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("63",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/divider.png","","167","167","","10","0","1","2024-01-10 23:16:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("64",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/blockquote.png","","543","3259","","10","0","1","2024-01-10 23:16:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("65",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/image_gallery.png","","1041","1901","","10","0","1","2024-01-10 23:16:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("66",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/opening_hours.png","","872","1830","","10","0","1","2024-01-10 23:16:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("67",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/sidebar_widget.png","","278","1246","","10","0","1","2024-01-10 23:16:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("68",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/shop_slider.png","","575","1426","","10","0","1","2024-01-10 23:16:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("69",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/list.png","","183","1124","","10","0","1","2024-01-10 23:16:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("70",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/map_basic.png","","711","748","","10","0","1","2024-01-10 23:16:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("71",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/fancy_divider.png","","369","1220","","10","0","1","2024-01-10 23:16:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("72",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/quick_form.png","","488","1489","","10","0","1","2024-01-10 23:16:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("73",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/button.png","","204","204","","10","0","1","2024-01-10 23:16:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("74",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/sliding_box.png","","582","1433","","10","0","1","2024-01-10 23:16:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("75",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/icon_box.png","","999","3715","","10","0","1","2024-01-10 23:16:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("76",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/placeholder.png","","156","156","","10","0","1","2024-01-10 23:16:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("77",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/portfolio_slider.png","","716","1567","","10","0","1","2024-01-10 23:16:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("78",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/blog_teaser.png","","521","584","","10","0","1","2024-01-10 23:16:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("79",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/progress_box.png","","271","1189","","10","0","1","2024-01-10 23:16:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("80",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/visual.png","","646","1497","","10","0","1","2024-01-10 23:16:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("81",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/items/our_team.png","","809","3525","","10","0","1","2024-01-10 23:16:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("82",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/logo.png","","2332","2856","","10","0","1","2024-01-10 23:16:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("83",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/transparency.png","","109","147","","10","0","1","2024-01-10 23:16:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("84",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/ico-shortcode.png","","122","180","","10","0","1","2024-01-10 23:16:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("85",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/assets/images/placeholder.png","","123","163","","10","0","1","2024-01-10 23:16:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("86",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/4.png","","16266","16266","","10","0","1","2024-01-10 23:16:54",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("87",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/21.png","","15789","15789","","10","0","1","2024-01-10 23:16:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("88",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/66.png","","11679","11679","","10","0","1","2024-01-10 23:16:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("89",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/906.png","","7885","7885","","10","0","1","2024-01-10 23:16:56",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("90",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x780b.png","","3130","3299","","10","0","1","2024-01-10 23:16:57",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("91",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo54x35.png","","559","559","","10","0","1","2024-01-10 23:16:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("92",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x550b.png","","2956","3112","","10","0","1","2024-01-10 23:16:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("93",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/1240x700.png","","2010","2078","","10","0","1","2024-01-10 23:17:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("94",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/bg80x80b.png","","820","948","","10","0","1","2024-01-10 23:17:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("95",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo360x111.png","","3604","6697","","10","0","1","2024-01-10 23:17:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("96",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x1000.png","","2417","2417","","10","0","1","2024-01-10 23:17:02",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("97",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x550.png","","2330","2330","","10","0","1","2024-01-10 23:17:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("98",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo325x59.png","","2475","2475","","10","0","1","2024-01-10 23:17:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("99",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo.png","","2771","2771","","10","0","1","2024-01-10 23:17:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("100",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/80x80b.png","","335","335","","10","0","1","2024-01-10 23:17:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("101",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/1920x800.png","","3139","3304","","10","0","1","2024-01-10 23:17:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("102",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo300x114.png","","2983","6099","","10","0","1","2024-01-10 23:17:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("103",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x1000b.png","","3158","3484","","10","0","1","2024-01-10 23:17:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("104",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo330x67.png","","1744","2533","","10","0","1","2024-01-10 23:17:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("105",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/bg80x80.png","","389","591","","10","0","1","2024-01-10 23:17:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("106",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo120x165.png","","1526","2515","","10","0","1","2024-01-10 23:17:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("107",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/80x80.png","","321","321","","10","0","1","2024-01-10 23:17:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("108",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo129x37.png","","807","807","","10","0","1","2024-01-10 23:17:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("109",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/1240x700b.png","","2077","2150","","10","0","1","2024-01-10 23:17:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("110",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo140x97.png","","1051","1970","","10","0","1","2024-01-10 23:17:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("111",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo127x41.png","","664","664","","10","0","1","2024-01-10 23:17:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("112",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo260x199.png","","9655","11768","","10","0","1","2024-01-10 23:17:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("113",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x450.png","","1750","1750","","10","0","1","2024-01-10 23:17:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("114",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x450b.png","","1840","1840","","10","0","1","2024-01-10 23:17:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("115",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/logo127x38.png","","978","978","","10","0","1","2024-01-10 23:17:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("116",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/placeholders/780x780.png","","2385","2385","","10","0","1","2024-01-10 23:17:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("117",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/914.png","","10386","10386","","10","0","1","2024-01-10 23:17:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("118",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/16.png","","13813","13813","","10","0","1","2024-01-10 23:17:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("119",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/91.png","","4852","4859","","10","0","1","2024-01-10 23:17:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("120",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/13.png","","13818","13818","","10","0","1","2024-01-10 23:17:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("121",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/54.png","","12541","12541","","10","0","1","2024-01-10 23:17:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("122",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/101.png","","5968","5968","","10","0","1","2024-01-10 23:17:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("123",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/8.png","","14830","14830","","10","0","1","2024-01-10 23:17:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("124",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/11.png","","11142","11142","","10","0","1","2024-01-10 23:17:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("125",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/32.png","","8251","8251","","10","0","1","2024-01-10 23:17:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("126",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/46.png","","12702","12702","","10","0","1","2024-01-10 23:17:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("127",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/85.png","","44072","44072","","10","0","1","2024-01-10 23:17:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("128",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/94.png","","5206","5206","","10","0","1","2024-01-10 23:17:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("129",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/78.png","","12123","12123","","10","0","1","2024-01-10 23:17:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("130",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/803.png","","19055","19055","","10","0","1","2024-01-10 23:17:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("131",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/48.png","","14670","14670","","10","0","1","2024-01-10 23:17:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("132",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/44.png","","8956","8956","","10","0","1","2024-01-10 23:17:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("133",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/20.png","","16535","16535","","10","0","1","2024-01-10 23:17:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("134",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/5.png","","15040","15040","","10","0","1","2024-01-10 23:17:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("135",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/6.png","","18375","18375","","10","0","1","2024-01-10 23:17:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("136",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/901.png","","9648","9648","","10","0","1","2024-01-10 23:17:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("137",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/9.png","","14425","14425","","10","0","1","2024-01-10 23:17:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("138",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/33.png","","8864","8864","","10","0","1","2024-01-10 23:17:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("139",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/3.png","","14540","14540","","10","0","1","2024-01-10 23:17:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("140",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/86.png","","72721","72721","","10","0","1","2024-01-10 23:17:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("141",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/910.png","","11735","11735","","10","0","1","2024-01-10 23:17:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("142",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/75.png","","13445","13445","","10","0","1","2024-01-10 23:17:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("143",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/45.png","","10993","10993","","10","0","1","2024-01-10 23:17:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("144",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/83.png","","18150","18150","","10","0","1","2024-01-10 23:17:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("145",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/98.png","","1090","1090","","10","0","1","2024-01-10 23:17:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("146",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/95.png","","3876","3876","","10","0","1","2024-01-10 23:17:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("147",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/109.png","","4011","4011","","10","0","1","2024-01-10 23:17:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("148",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/703.png","","15411","15411","","10","0","1","2024-01-10 23:17:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("149",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/907.png","","10022","10022","","10","0","1","2024-01-10 23:17:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("150",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/905.png","","6423","6423","","10","0","1","2024-01-10 23:17:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("151",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/908.png","","13166","13166","","10","0","1","2024-01-10 23:17:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("152",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/29.png","","11313","11313","","10","0","1","2024-01-10 23:17:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("153",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/68.png","","6519","6519","","10","0","1","2024-01-10 23:17:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("154",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/107.png","","1134","1134","","10","0","1","2024-01-10 23:17:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("155",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/2.png","","12306","12306","","10","0","1","2024-01-10 23:17:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("156",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/96.png","","6946","6946","","10","0","1","2024-01-10 23:17:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("157",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/79.png","","6014","6014","","10","0","1","2024-01-10 23:17:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("158",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/67.png","","8497","8497","","10","0","1","2024-01-10 23:17:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("159",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/59.png","","17771","17771","","10","0","1","2024-01-10 23:17:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("160",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/110.png","","1660","1660","","10","0","1","2024-01-10 23:17:54",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("161",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/804.png","","17637","17637","","10","0","1","2024-01-10 23:17:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("162",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/111.png","","6505","6505","","10","0","1","2024-01-10 23:17:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("163",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/41.png","","23433","23433","","10","0","1","2024-01-10 23:17:56",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("164",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/69.png","","11823","11823","","10","0","1","2024-01-10 23:17:57",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("165",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/18.png","","10081","10081","","10","0","1","2024-01-10 23:17:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("166",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/90.png","","4323","4323","","10","0","1","2024-01-10 23:17:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("167",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/12.png","","7032","7032","","10","0","1","2024-01-10 23:18:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("168",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/51.png","","24313","24313","","10","0","1","2024-01-10 23:18:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("169",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/902.png","","6007","6007","","10","0","1","2024-01-10 23:18:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("170",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/55.png","","14688","14688","","10","0","1","2024-01-10 23:18:02",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("171",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/113.png","","6328","6328","","10","0","1","2024-01-10 23:18:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("172",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/106.png","","1874","1916","","10","0","1","2024-01-10 23:18:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("173",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/802.png","","15994","15994","","10","0","1","2024-01-10 23:18:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("174",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/705.png","","14022","14022","","10","0","1","2024-01-10 23:18:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("175",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/58.png","","9488","9488","","10","0","1","2024-01-10 23:18:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("176",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/84.png","","5141","5141","","10","0","1","2024-01-10 23:18:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("177",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/36.png","","22847","22847","","10","0","1","2024-01-10 23:18:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("178",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/81.png","","16918","16918","","10","0","1","2024-01-10 23:18:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("179",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/40.png","","38813","38813","","10","0","1","2024-01-10 23:18:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("180",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/39.png","","9154","9154","","10","0","1","2024-01-10 23:18:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("181",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/28.png","","15601","15601","","10","0","1","2024-01-10 23:18:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("182",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/42.png","","10865","10865","","10","0","1","2024-01-10 23:18:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("183",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/10.png","","13495","13495","","10","0","1","2024-01-10 23:18:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("184",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/50.png","","13759","13759","","10","0","1","2024-01-10 23:18:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("185",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/25.png","","12024","12024","","10","0","1","2024-01-10 23:18:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("186",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/82.png","","4260","4260","","10","0","1","2024-01-10 23:18:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("187",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/43.png","","9716","9716","","10","0","1","2024-01-10 23:18:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("188",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/706.png","","8025","8025","","10","0","1","2024-01-10 23:18:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("189",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/19.png","","13870","13870","","10","0","1","2024-01-10 23:18:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("190",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/105.png","","3684","3684","","10","0","1","2024-01-10 23:18:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("191",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/22.png","","18125","18125","","10","0","1","2024-01-10 23:18:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("192",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/97.png","","3334","3334","","10","0","1","2024-01-10 23:18:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("193",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/801.png","","22811","22811","","10","0","1","2024-01-10 23:18:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("194",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/87.png","","69663","69663","","10","0","1","2024-01-10 23:18:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("195",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/104.png","","2491","2491","","10","0","1","2024-01-10 23:18:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("196",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/100.png","","6658","6658","","10","0","1","2024-01-10 23:18:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("197",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/704.png","","11004","11004","","10","0","1","2024-01-10 23:18:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("198",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/52.png","","11773","11773","","10","0","1","2024-01-10 23:18:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("199",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/911.png","","6556","6556","","10","0","1","2024-01-10 23:18:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("200",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/72.png","","5176","5176","","10","0","1","2024-01-10 23:18:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("201",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/903.png","","12356","12356","","10","0","1","2024-01-10 23:18:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("202",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/7.png","","21706","21706","","10","0","1","2024-01-10 23:18:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("203",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/17.png","","14786","14786","","10","0","1","2024-01-10 23:18:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("204",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/57.png","","9648","9648","","10","0","1","2024-01-10 23:18:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("205",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/112.png","","2586","2586","","10","0","1","2024-01-10 23:18:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("206",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/38.png","","5723","5723","","10","0","1","2024-01-10 23:18:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("207",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/701.png","","11105","11105","","10","0","1","2024-01-10 23:18:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("208",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/56.png","","10954","10954","","10","0","1","2024-01-10 23:18:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("209",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/904.png","","12379","12379","","10","0","1","2024-01-10 23:18:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("210",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/92.png","","4746","4746","","10","0","1","2024-01-10 23:18:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("211",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/34.png","","8375","8375","","10","0","1","2024-01-10 23:18:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("212",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/73.png","","5650","5650","","10","0","1","2024-01-10 23:18:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("213",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/14.png","","7983","7983","","10","0","1","2024-01-10 23:18:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("214",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/23.png","","12415","12415","","10","0","1","2024-01-10 23:18:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("215",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/35.png","","13354","13354","","10","0","1","2024-01-10 23:18:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("216",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/108.png","","1832","1832","","10","0","1","2024-01-10 23:18:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("217",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/702.png","","13405","13405","","10","0","1","2024-01-10 23:18:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("218",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/74.png","","13274","13274","","10","0","1","2024-01-10 23:18:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("219",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/89.png","","6444","6444","","10","0","1","2024-01-10 23:18:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("220",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/31.png","","1598","1658","","10","0","1","2024-01-10 23:18:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("221",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/62.png","","9356","9356","","10","0","1","2024-01-10 23:18:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("222",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/26.png","","15018","15018","","10","0","1","2024-01-10 23:18:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("223",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/93.png","","1339","1339","","10","0","1","2024-01-10 23:18:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("224",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/88.png","","12450","12450","","10","0","1","2024-01-10 23:18:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("225",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/103.png","","3105","3105","","10","0","1","2024-01-10 23:18:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("226",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/912.png","","5118","5118","","10","0","1","2024-01-10 23:18:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("227",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/60.png","","7576","7576","","10","0","1","2024-01-10 23:18:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("228",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/80.png","","14258","14258","","10","0","1","2024-01-10 23:18:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("229",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/61.png","","9785","9785","","10","0","1","2024-01-10 23:18:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("230",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/27.png","","7220","7220","","10","0","1","2024-01-10 23:18:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("231",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/102.png","","3618","3618","","10","0","1","2024-01-10 23:18:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("232",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/30.png","","734","741","","10","0","1","2024-01-10 23:18:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("233",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/909.png","","6061","6061","","10","0","1","2024-01-10 23:18:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("234",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/15.png","","6244","6244","","10","0","1","2024-01-10 23:18:54",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("235",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/37.png","","11048","11048","","10","0","1","2024-01-10 23:18:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("236",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/53.png","","12713","12713","","10","0","1","2024-01-10 23:18:56",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("237",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/70.png","","4944","4944","","10","0","1","2024-01-10 23:18:57",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("238",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/64.png","","8098","8098","","10","0","1","2024-01-10 23:18:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("239",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/77.png","","14166","14166","","10","0","1","2024-01-10 23:18:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("240",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/71.png","","6941","6941","","10","0","1","2024-01-10 23:18:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("241",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/99.png","","3599","3599","","10","0","1","2024-01-10 23:19:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("242",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/76.png","","13481","13481","","10","0","1","2024-01-10 23:19:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("243",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/65.png","","4095","4095","","10","0","1","2024-01-10 23:19:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("244",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/47.png","","9987","9987","","10","0","1","2024-01-10 23:19:02",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("245",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/24.png","","18204","18204","","10","0","1","2024-01-10 23:19:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("246",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/49.png","","6135","6135","","10","0","1","2024-01-10 23:19:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("247",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/1.png","","12282","12282","","10","0","1","2024-01-10 23:19:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("248",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/63.png","","12666","12666","","10","0","1","2024-01-10 23:19:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("249",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/functions/builder/pre-built/images/913.png","","12096","12096","","10","0","1","2024-01-10 23:19:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("250",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/2sb.png","","133","133","","10","0","1","2024-01-10 23:19:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("251",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-cross.png","","190","1080","","10","0","1","2024-01-10 23:19:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("252",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/switch-mask.png","","275","1353","","10","0","1","2024-01-10 23:19:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("253",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/logo.png","","2607","3159","","10","0","1","2024-01-10 23:19:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("254",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/colorpicker.png","","434","434","","10","0","1","2024-01-10 23:19:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("255",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-nav.png","","3044","3044","","10","0","1","2024-01-10 23:19:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("256",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-delete.png","","195","195","","10","0","1","2024-01-10 23:19:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("257",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/survey.png","","2682","2931","","10","0","1","2024-01-10 23:19:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("258",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-upload.png","","151","1000","","10","0","1","2024-01-10 23:19:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("259",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-sub-active.png","","231","232","","10","0","1","2024-01-10 23:19:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("260",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/transparency.png","","109","147","","10","0","1","2024-01-10 23:19:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("261",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-buttons.png","","626","626","","10","0","1","2024-01-10 23:19:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("262",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/ico-sub.png","","222","222","","10","0","1","2024-01-10 23:19:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("263",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/transparent.png","","90","134","","10","0","1","2024-01-10 23:19:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("264",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/2cr.png","","131","131","","10","0","1","2024-01-10 23:19:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("265",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/question.png","","212","382","","10","0","1","2024-01-10 23:19:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("266",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/classic.png","","198","202","","10","0","1","2024-01-10 23:19:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("267",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/masonry-blog.png","","307","307","","10","0","1","2024-01-10 23:19:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("268",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/timeline.png","","219","223","","10","0","1","2024-01-10 23:19:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("269",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/photo.png","","191","196","","10","0","1","2024-01-10 23:19:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("270",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/photo2.png","","344","662","","10","0","1","2024-01-10 23:19:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("271",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/blog/masonry-tiles.png","","267","274","","10","0","1","2024-01-10 23:19:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("272",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/creative.png","","169","169","","10","0","1","2024-01-10 23:19:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("273",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/classic.png","","338","339","","10","0","1","2024-01-10 23:19:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("274",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/creative-open-right.png","","413","431","","10","0","1","2024-01-10 23:19:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("275",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/stack-center.png","","336","339","","10","0","1","2024-01-10 23:19:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("276",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/fixed.png","","323","323","","10","0","1","2024-01-10 23:19:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("277",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/below-split.png","","343","343","","10","0","1","2024-01-10 23:19:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("278",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/creative-right.png","","169","170","","10","0","1","2024-01-10 23:19:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("279",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/below.png","","329","330","","10","0","1","2024-01-10 23:19:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("280",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/magazine.png","","352","354","","10","0","1","2024-01-10 23:19:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("281",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/plain.png","","394","1692","","10","0","1","2024-01-10 23:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("282",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/stack-right.png","","336","339","","10","0","1","2024-01-10 23:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("283",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/split.png","","342","343","","10","0","1","2024-01-10 23:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("284",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/transparent.png","","326","326","","10","0","1","2024-01-10 23:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("285",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/stack-left.png","","335","339","","10","0","1","2024-01-10 23:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("286",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/overlay.png","","236","241","","10","0","1","2024-01-10 23:19:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("287",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/split-semi.png","","388","759","","10","0","1","2024-01-10 23:19:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("288",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/creative-open.png","","362","366","","10","0","1","2024-01-10 23:19:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("289",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/modern.png","","336","336","","10","0","1","2024-01-10 23:19:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("290",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/empty.png","","326","326","","10","0","1","2024-01-10 23:19:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("291",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/header/simple.png","","322","322","","10","0","1","2024-01-10 23:19:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("292",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/style/boxed.png","","197","203","","10","0","1","2024-01-10 23:19:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("293",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/style/full-width.png","","163","176","","10","0","1","2024-01-10 23:19:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("294",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/style/default.png","","3618","3618","","10","0","1","2024-01-10 23:19:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("295",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/style/simple.png","","3590","3590","","10","0","1","2024-01-10 23:19:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("296",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/masonry-minimal.png","","226","468","","10","0","1","2024-01-10 23:19:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("297",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/masonry-hover.png","","240","240","","10","0","1","2024-01-10 23:19:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("298",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/masonry-blog.png","","295","295","","10","0","1","2024-01-10 23:19:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("299",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/flat.png","","177","178","","10","0","1","2024-01-10 23:19:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("300",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/exposure.png","","243","513","","10","0","1","2024-01-10 23:19:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("301",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/grid.png","","218","220","","10","0","1","2024-01-10 23:19:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("302",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/list.png","","209","212","","10","0","1","2024-01-10 23:19:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("303",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/portfolio/masonry-flat.png","","189","189","","10","0","1","2024-01-10 23:19:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("304",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/4.png","","309","600","","10","0","1","2024-01-10 23:19:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("305",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/5.png","","305","601","","10","0","1","2024-01-10 23:19:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("306",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/6.png","","300","600","","10","0","1","2024-01-10 23:19:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("307",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/3.png","","303","612","","10","0","1","2024-01-10 23:19:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("308",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/2.png","","306","604","","10","0","1","2024-01-10 23:19:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("309",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/mobile-minimal/1.png","","289","545","","10","0","1","2024-01-10 23:19:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("310",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/shop/masonry.png","","295","295","","10","0","1","2024-01-10 23:19:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("311",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/shop/grid-4.png","","220","224","","10","0","1","2024-01-10 23:19:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("312",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/shop/grid.png","","218","220","","10","0","1","2024-01-10 23:19:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("313",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/select/shop/list.png","","198","202","","10","0","1","2024-01-10 23:19:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("314",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/2cl.png","","131","131","","10","0","1","2024-01-10 23:19:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("315",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/intro-slider/intro-slider.jpg","","421676","421676","","10","0","1","2024-01-10 23:19:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("316",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/placeholder.png","","188","281","","10","0","1","2024-01-10 23:19:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("317",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/1col.png","","96","96","","10","0","1","2024-01-10 23:19:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("318",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/img/bg.jpg","","22605","22605","","10","0","1","2024-01-10 23:19:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("319",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/_dark/img/transparency.png","","105","142","","10","0","1","2024-01-10 23:19:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("320",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/muffin-options/svg/placeholders/featured-image.png","","7825","8770","","10","0","1","2024-01-10 23:19:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("321",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/contact_form_error.png","","237","241","","10","0","1","2024-01-10 23:19:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("322",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/progressbar.png","","160","1018","","10","0","1","2024-01-10 23:19:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("323",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/preloader2.gif","","19056","28757","","10","0","1","2024-01-10 23:19:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("324",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/top_bar_right_shadow.png","","115","115","","10","0","1","2024-01-10 23:19:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("325",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/videomask.png","","115","966","","10","0","1","2024-01-10 23:19:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("326",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/icons/list_star.png","","298","1149","","10","0","1","2024-01-10 23:19:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("327",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/icons/list_idea.png","","266","1213","","10","0","1","2024-01-10 23:19:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("328",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/icons/list_check.png","","336","1187","","10","0","1","2024-01-10 23:19:54",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("329",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/fancy_heading_hr.png","","238","1151","","10","0","1","2024-01-10 23:19:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("330",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/logo/be-retina.png","","1651","1651","","10","0","1","2024-01-10 23:19:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("331",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/logo/logo.png","","1568","1568","","10","0","1","2024-01-10 23:19:56",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("332",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/logo/logo-retina.png","","2771","2771","","10","0","1","2024-01-10 23:19:56",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("333",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/logo/be.png","","892","892","","10","0","1","2024-01-10 23:19:57",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("334",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/stripes_3_b.png","","123","974","","10","0","1","2024-01-10 23:19:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("335",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/stripes_5_b.png","","121","972","","10","0","1","2024-01-10 23:19:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("336",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/textline.png","","118","1160","","10","0","1","2024-01-10 23:19:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("337",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/textline_dark.png","","118","118","","10","0","1","2024-01-10 23:19:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("338",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/stripes_10_w.png","","123","982","","10","0","1","2024-01-10 23:20:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("339",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/stripes/stripes_10_b.png","","122","973","","10","0","1","2024-01-10 23:20:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("340",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/photo.png","","471","1359","","10","0","1","2024-01-10 23:20:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("341",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/testimonials-placeholder.png","","508","508","","10","0","1","2024-01-10 23:20:01",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("342",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/fancy_heading_hr_dark.png","","201","2993","","10","0","1","2024-01-10 23:20:02",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("343",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/shop-loader.gif","","1669","1737","","10","0","1","2024-01-10 23:20:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("344",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/timeline_top.png","","105","956","","10","0","1","2024-01-10 23:20:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("345",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/deep-forest.jpg","","226812","235970","","10","0","1","2024-01-10 23:20:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("346",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/portfolio.jpg","","44403","44403","","10","0","1","2024-01-10 23:20:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("347",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/minimal-tree.jpg","","27961","27961","","10","0","1","2024-01-10 23:20:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("348",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/glowee.jpg","","34246","34246","","10","0","1","2024-01-10 23:20:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("349",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/abstract.jpg","","149355","152601","","10","0","1","2024-01-10 23:20:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("350",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/soft-stripes.jpg","","26393","26393","","10","0","1","2024-01-10 23:20:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("351",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/city.jpg","","337217","349248","","10","0","1","2024-01-10 23:20:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("352",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/galaxy.jpg","","58986","58986","","10","0","1","2024-01-10 23:20:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("353",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/headers/origami.jpg","","29833","29833","","10","0","1","2024-01-10 23:20:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("354",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/tp-rightarrow.png","","180","1054","","10","0","1","2024-01-10 23:20:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("355",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/preloader.gif","","307","404","","10","0","1","2024-01-10 23:20:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("356",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/tp-leftarrow.png","","182","1054","","10","0","1","2024-01-10 23:20:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("357",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/box_shadow.png","","108","108","","10","0","1","2024-01-10 23:20:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("358",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/4.png","","2164","2232","","10","0","1","2024-01-10 23:20:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("359",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/21.png","","14771","14806","","10","0","1","2024-01-10 23:20:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("360",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/16.png","","24041","24041","","10","0","1","2024-01-10 23:20:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("361",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/13.png","","3353","3441","","10","0","1","2024-01-10 23:20:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("362",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/8.png","","179","184","","10","0","1","2024-01-10 23:20:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("363",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/11.png","","16344","16344","","10","0","1","2024-01-10 23:20:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("364",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/20.png","","927","927","","10","0","1","2024-01-10 23:20:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("365",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/5.png","","2282","2329","","10","0","1","2024-01-10 23:20:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("366",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/6.png","","41145","41145","","10","0","1","2024-01-10 23:20:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("367",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/9.png","","41297","60837","","10","0","1","2024-01-10 23:20:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("368",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/3.png","","700","700","","10","0","1","2024-01-10 23:20:20",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("369",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/2.png","","20447","20869","","10","0","1","2024-01-10 23:20:21",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("370",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/18.png","","1310","1390","","10","0","1","2024-01-10 23:20:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("371",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/12.png","","24958","26404","","10","0","1","2024-01-10 23:20:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("372",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/10.png","","22853","23964","","10","0","1","2024-01-10 23:20:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("373",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/25.png","","22048","22795","","10","0","1","2024-01-10 23:20:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("374",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/19.png","","10800","10800","","10","0","1","2024-01-10 23:20:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("375",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/22.png","","7468","7468","","10","0","1","2024-01-10 23:20:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("376",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/7.png","","3277","3277","","10","0","1","2024-01-10 23:20:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("377",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/17.png","","35122","35255","","10","0","1","2024-01-10 23:20:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("378",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/14.png","","2985","2985","","10","0","1","2024-01-10 23:20:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("379",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/23.png","","4007","4022","","10","0","1","2024-01-10 23:20:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("380",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/15.png","","31309","33551","","10","0","1","2024-01-10 23:20:28",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("381",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/24.png","","13540","13571","","10","0","1","2024-01-10 23:20:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("382",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/patterns/1.png","","4315","4315","","10","0","1","2024-01-10 23:20:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("383",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/timeline_left.png","","360","2338","","10","0","1","2024-01-10 23:20:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("384",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/infobox.png","","1721","1721","","10","0","1","2024-01-10 23:20:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("385",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/bg_subheader.jpg","","123913","123913","","10","0","1","2024-01-10 23:20:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("386",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/pin.png","","387","525","","10","0","1","2024-01-10 23:20:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("387",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/timeline_right.png","","363","2338","","10","0","1","2024-01-10 23:20:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("388",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/get_in_touch.png","","1517","1517","","10","0","1","2024-01-10 23:20:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("389",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/blog_masonry_tile_gradient.png","","204","241","","10","0","1","2024-01-10 23:20:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("390",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/bg_panel.png","","156","1077","","10","0","1","2024-01-10 23:20:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("391",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/cookies.png","","1448","3228","","10","0","1","2024-01-10 23:20:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("392",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/blockquote.png","","514","1541","","10","0","1","2024-01-10 23:20:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("393",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/menu-plus.png","","105","142","","10","0","1","2024-01-10 23:20:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("394",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/opening_hours.png","","713","713","","10","0","1","2024-01-10 23:20:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("395",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/link.png","","548","1486","","10","0","1","2024-01-10 23:20:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("396",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/blockquote_dark.png","","440","440","","10","0","1","2024-01-10 23:20:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("397",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/recent_comments.png","","230","1168","","10","0","1","2024-01-10 23:20:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("398",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/images/box_shadow_button.png","","108","108","","10","0","1","2024-01-10 23:20:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("399",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/contrast.png","","2409","3249","","10","0","1","2024-01-10 23:20:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("400",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/blur.png","","3950","4936","","10","0","1","2024-01-10 23:20:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("401",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/transparency.png","","109","147","","10","0","1","2024-01-10 23:20:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("402",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/divider.png","","134","134","","10","0","1","2024-01-10 23:20:42",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("403",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/intro-slider/intro-slider.jpg","","351429","351429","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("404",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/img/placeholder.png","","188","281","","10","0","1","2024-01-10 23:20:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("405",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/visual-builder/assets/_dark/img/transparency.png","","105","142","","10","0","1","2024-01-10 23:20:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("406",NULL,NULL,NULL,"ABSPATHwp-content/themes/betheme/screenshot.png","","291778","291778","","10","0","1","2024-01-10 23:20:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("407",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-768x138.png","","120","144","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("408",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-160x160.png","","110","134","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("409",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x600.png","","152","176","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("410",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x246.png","","126","150","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("411",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x523.png","","146","170","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("412",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x263.png","","127","151","","10","0","1","2024-01-10 23:20:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("413",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x502.png","","144","168","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("414",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-600x412.png","","138","162","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("415",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x779.png","","181","206","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("416",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-800x800.png","","186","210","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("417",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x619.png","","167","191","","10","0","1","2024-01-10 23:20:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("418",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x1240.png","","226","250","","10","0","1","2024-01-10 23:20:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("419",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-32x32.png","","96","121","","10","0","1","2024-01-10 23:20:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("420",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-225x225.png","","114","138","","10","0","1","2024-01-10 23:20:45",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("421",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x482.png","","153","177","","10","0","1","2024-01-10 23:20:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("422",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x755.png","","180","204","","10","0","1","2024-01-10 23:21:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("423",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x1029.png","","206","230","","10","0","1","2024-01-10 23:21:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("424",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-64x64.png","","99","124","","10","0","1","2024-01-10 23:27:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("425",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x696.png","","174","198","","10","0","1","2024-01-10 23:27:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("426",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x513.png","","156","181","","10","0","1","2024-01-10 23:27:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("427",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1201x540.png","","187","211","","10","0","1","2024-01-10 23:27:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("428",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x891.png","","192","216","","10","0","1","2024-01-10 23:27:40",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("429",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-66x21.png","","96","121","","10","0","1","2024-01-11 09:12:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("430",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-35x26.png","","96","121","","10","0","1","2024-01-11 09:12:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("431",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-42x26.png","","96","121","","10","0","1","2024-01-11 09:12:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("432",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-43x26.png","","96","121","","10","0","1","2024-01-11 09:12:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("433",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-72x72.png","","99","124","","10","0","1","2024-01-11 09:12:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("434",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-242x25.png","","100","125","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("435",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-102x25.png","","97","122","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("436",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1200x800.png","","225","249","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("437",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-120x120.png","","107","132","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("438",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-57x57.png","","98","123","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("439",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1080x810.png","","213","238","","10","0","1","2024-01-11 17:44:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("440",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1080x1300.png","","279","303","","10","0","1","2024-01-11 17:44:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("441",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-58x56.png","","98","123","","10","0","1","2024-01-11 17:44:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("442",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-146x146.png","","110","135","","10","0","1","2024-01-11 17:44:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("443",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1080x648.png","","193","217","","10","0","1","2024-01-11 17:44:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("444",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-24x24.png","","96","121","","10","0","1","2024-01-11 17:44:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("445",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-189x93.png","","108","132","","10","0","1","2024-01-11 17:44:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("446",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x910.png","","195","219","","10","0","1","2024-01-11 17:44:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("447",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1920x1200.png","","387","411","","10","0","1","2024-01-11 17:44:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("448",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-780x780.png","","182","207","","10","0","1","2024-01-11 17:47:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("665",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-442x262.png","","121","146","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("666",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-293x105.png","","111","136","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("667",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-16x13.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("668",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-38x60.png","","97","122","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("669",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-60x49.png","","98","123","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("670",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-53x60.png","","98","123","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("671",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-60x60.png","","99","124","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("672",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-45x48.png","","97","122","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("673",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-59x36.png","","97","122","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("674",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-14x17.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("675",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-17x17.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("676",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-16x14.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("677",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-443x334.png","","126","150","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("678",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-16x17.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("679",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1000x1000.png","","230","254","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("680",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-13x14.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("681",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-14x14.png","","96","121","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("682",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-640x642.png","","158","182","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("683",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-440x194.png","","118","142","","10","0","1","2024-02-05 23:39:24",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("684",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-80x80.png","","101","126","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("685",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-23x23.png","","96","121","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("686",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-26x21.png","","96","121","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("687",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1032x378.png","","155","179","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("688",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-258x338.png","","119","143","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("689",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-30x30.png","","96","121","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("690",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-25x25.png","","96","121","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("691",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-130x71.png","","102","127","","10","0","1","2024-02-05 23:39:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("703","22","media","full","ABSPATHwp-content/uploads/2021/04/Icon-1.jpg","","2638","2638","","10","0","1","2024-02-27 13:42:30",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("704","23","media","full","ABSPATHwp-content/uploads/2021/04/Icon-2.jpg","","2822","2822","","10","0","1","2024-02-27 13:42:31",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("705","24","media","full","ABSPATHwp-content/uploads/2021/04/Icon-3.jpg","","2990","2990","","10","0","1","2024-02-27 13:42:32",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("706","3903","media","full","ABSPATHwp-content/uploads/2021/04/Icon-4.jpg","","1914","1914","","10","0","1","2024-02-27 13:42:33",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("707","3904","media","full","ABSPATHwp-content/uploads/2021/04/Icon-5.jpg","","2336","2336","","10","0","1","2024-02-27 13:42:34",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("708","3905","media","full","ABSPATHwp-content/uploads/2021/04/Icon-6.jpg","","2801","2801","","10","0","1","2024-02-27 13:42:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("709","3906","media","full","ABSPATHwp-content/uploads/2021/04/Icon-7.jpg","","2294","2294","","10","0","1","2024-02-27 13:42:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("711","3907","media","full","ABSPATHwp-content/uploads/2021/04/Icon-8.jpg","","1934","1934","","10","0","1","2024-02-27 13:42:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("714","3909","media","full","ABSPATHwp-content/uploads/2021/04/Icon.jpg","","2591","2591","","10","0","1","2024-02-27 13:42:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("732","365","media","full","ABSPATHwp-content/uploads/2021/04/stars-left.png","","302","302","","10","0","1","2024-02-27 13:42:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("733","366","media","full","ABSPATHwp-content/uploads/2021/04/stars-right.png","","300","300","","10","0","1","2024-02-27 13:42:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("738","602","media","full","ABSPATHwp-content/uploads/2021/05/Group-1.png","","483","483","","10","0","1","2024-02-27 13:43:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("800","603","media","full","ABSPATHwp-content/uploads/2021/05/Group-2.jpg","","599","599","","10","0","1","2024-02-27 13:44:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("830","2254","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-9.jpg","","419","419","","10","0","1","2024-02-27 13:44:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("831","2253","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-8.jpg","","437","437","","10","0","1","2024-02-27 13:44:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("832","2252","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-7.jpg","","433","433","","10","0","1","2024-02-27 13:44:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("833","2251","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-6.jpg","","413","413","","10","0","1","2024-02-27 13:44:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("834","2250","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-5.jpg","","412","412","","10","0","1","2024-02-27 13:44:50",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("835","2249","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-4.jpg","","432","432","","10","0","1","2024-02-27 13:44:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("836","2248","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-3.jpg","","410","410","","10","0","1","2024-02-27 13:44:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("837","2247","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-2.jpg","","425","425","","10","0","1","2024-02-27 13:44:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("838","2246","media","full","ABSPATHwp-content/uploads/2021/05/menu-icon-1.jpg","","431","431","","10","0","1","2024-02-27 13:44:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("893",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore-child/screenshot.png","","184685","221942","","10","0","1","2024-02-27 13:45:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("894",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/holly_green.png","","16634","17695","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"9752","0"),
("895",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/lazy.png","","270","295","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"102","0"),
("896",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/select-arrow.png","","147","1000","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"96","0"),
("897",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/zoom-in.png","","271","323","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"172","0"),
("898",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/radio-icon-check.png","","326","3042","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"176","0"),
("899",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/grid-video.png","","86","2802","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"36","0"),
("900",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/products-not-found.png","","5185","7891","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"3496","0"),
("901",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/mailchimp-plus-white.png","","104","141","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"60","0"),
("902",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/paypal.jpeg","","1340","1373","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"592","0"),
("903",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/american-express.jpeg","","2847","2857","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"1366","0"),
("904",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/master-card.jpeg","","2766","2803","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"956","0"),
("905",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/bitcoin.jpeg","","2310","2334","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"932","0"),
("906",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/visa.jpeg","","1994","2007","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"976","0"),
("907",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/woocommerce/payment-icons/maestro.jpeg","","2935","2962","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"1044","0"),
("908",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/plus-white.png","","104","959","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"48","0"),
("909",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/logo.png","","950","950","","10","0","1","2024-02-27 13:45:35",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("910",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/404.png","","3712","3712","","10","0","1","2024-02-27 13:45:36",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("911",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/logo-fixed.png","","915","1372","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"652","0"),
("912",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/delete.png","","301","301","","10","0","1","2024-02-27 13:45:38",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("913",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/preloader.gif","","866","866","","10","0","1","2024-02-27 13:45:39",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("914",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/ie-arrow.png","","114","965","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"48","0"),
("915",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/loading.gif","","2536","2545","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("916",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/placeholder.jpg","","511","535","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"126","0"),
("917",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/mailchimp-plus.png","","107","107","","10","0","1","2024-02-27 13:45:41",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("918",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/drag.png","","351","358","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"236","0"),
("919",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/pretty-sprite.png","","2625","4835","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"1840","0"),
("920",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/paypal.png","","1120","1131","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"824","0"),
("921",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/size-guide.png","","130","143","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"86","0"),
("922",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/radio-icon.png","","207","2962","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"120","0"),
("923",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/loader-gif.png","","607","623","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"268","0"),
("924",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/grabbing.png","","116","116","","10","0","1","2024-02-27 13:45:46",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("925",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/instagram-sprite.png","","2031","2031","","10","0","1","2024-02-27 13:45:47",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("926",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/404-dark.png","","24553","24553","","10","0","1","2024-02-27 13:45:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("927",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/lazy-dark.png","","270","295","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"102","0"),
("928",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/images/loader-white-gif.png","","411","429","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"232","0"),
("929",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/themeforest.jpg","","48563","48563","","10","0","1","2024-02-27 13:45:51",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("930",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/logo-white.png","","1101","1101","","10","0","1","2024-02-27 13:45:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("931",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/zoom.png","","208","208","","10","0","1","2024-02-27 13:45:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("932",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/admin-logo.png","","1029","1029","","10","0","1","2024-02-27 13:45:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("933",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/telegram.png","","1958","3670","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"1024","0"),
("934",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/logo.png","","1106","1106","","10","0","1","2024-02-27 13:45:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("935",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/support-icon.png","","941","941","","10","0","1","2024-02-27 13:45:55",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("936",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/et-delete.png","","144","150","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"94","0"),
("937",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/icon-etheme.png","","773","3489","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"516","0"),
("938",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/admin-logo2x.png","","2669","4062","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"1824","0"),
("939",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/browser.png","","224","1143","","10","0","1","2025-03-24 13:11:18",NULL,NULL,NULL,NULL,NULL,"174","0"),
("940",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/placeholder-350x268.png","","106","2247","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"46","0"),
("941",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/loader-gif.png","","607","623","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"268","0"),
("942",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/success-icon.png","","727","731","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"518","0"),
("943",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/envato-icon.png","","1022","1033","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"756","0"),
("944",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/thirdparty/child-theme/screenshot.png","","4534","4534","","10","0","1","2024-02-27 13:46:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("945",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/customizer/images/search-icon-white.png","","543","543","","10","0","1","2024-02-27 13:46:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("946",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/customizer/images/search-icon.png","","424","602","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"286","0"),
("947",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/customizer/search/images/search-icon-white.png","","543","543","","10","0","1","2024-02-27 13:46:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("948",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/customizer/search/images/search-icon.png","","550","550","","10","0","1","2024-02-27 13:46:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("949",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/audio.png","","382","382","","10","0","1","2024-02-27 13:46:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("950",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/empty-search.png","","10173","10173","","10","0","1","2024-02-27 13:46:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("951",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/deactivate-license.png","","32845","32845","","10","0","1","2024-02-27 13:46:10",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("952",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-5.jpg","","52863","52863","","10","0","1","2024-02-27 13:46:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("953",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-6.jpg","","52647","52647","","10","0","1","2024-02-27 13:46:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("954",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-3.jpg","","54468","54468","","10","0","1","2024-02-27 13:46:13",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("955",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-2.jpg","","74417","74417","","10","0","1","2024-02-27 13:46:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("956",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-4.jpg","","58428","58428","","10","0","1","2024-02-27 13:46:15",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("957",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-7.jpg","","62118","62118","","10","0","1","2024-02-27 13:46:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("958",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-1.jpg","","61860","62633","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"39790","0"),
("959",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/account.png","","90085","90085","","10","0","1","2024-02-27 13:46:22",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("960",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/themeforest-licenses.png","","4319","4319","","10","0","1","2024-02-27 13:46:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("961",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/etheme2.png","","1837","2800","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"1184","0"),
("962",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/slides-tutorial.jpeg","","17842","17842","","10","0","1","2024-02-27 13:46:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("963",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/box-opening.gif","","14987","17322","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("964",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/loader.gif","","3635","6592","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("965",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/Icon-white.png","","540","883","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"340","0"),
("966",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/woo_label.png","","644","645","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"480","0"),
("967",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/icon-etheme32.png","","976","1829","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"592","0"),
("968",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/logo.png","","997","997","","10","0","1","2024-02-27 13:46:29",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("969",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/etheme.png","","938","1789","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"610","0"),
("970",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/et-delete.png","","144","150","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"94","0"),
("971",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/icon-etheme.png","","773","3489","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"516","0"),
("972",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/ico-delete.png","","662","715","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"534","0"),
("973",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/xstore.jpg","","1681","889890","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"508","0"),
("974",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/hamburger-icon.jpg","","1377","2316","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"320","0"),
("975",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/xstore2.jpg","","1879","890399","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"514","0"),
("976",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/advanced.jpg","","3876","4820","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"934","0"),
("977",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/center2.jpg","","2321","891245","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"492","0"),
("978",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/vertical-icon.jpg","","1066","1066","","10","0","1","2024-02-27 13:46:37",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("979",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/center3.jpg","","2640","3579","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"554","0"),
("980",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/vertical-icon-2.jpg","","1995","2909","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"478","0"),
("981",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/double-menu.jpg","","1856","2794","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"460","0"),
("982",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/headers/standard.jpg","","2389","891492","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"624","0"),
("983",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/logo-white2.png","","1553","1951","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"992","0"),
("984",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-medium.png","","502","507","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"370","0"),
("985",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-right.png","","505","505","","10","0","1","2024-02-27 13:46:43",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("986",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-wide.png","","500","500","","10","0","1","2024-02-27 13:46:44",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("987",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-booking.png","","513","517","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"398","0"),
("988",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-large.png","","422","423","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"308","0"),
("989",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-thin.png","","501","507","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"370","0"),
("990",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-fixed.png","","435","440","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"336","0"),
("991",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-center.png","","501","501","","10","0","1","2024-02-27 13:46:48",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("992",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/layout/product-small.png","","428","433","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"312","0"),
("993",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/placeholder.jpg","","851","851","","10","0","1","2024-02-27 13:46:49",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("994",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/trash-bin.gif","","9803","18677","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("995",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/logo-setup.png","","3341","5545","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"2372","0"),
("996",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Portfolio.png","","2397","2397","","10","0","1","2024-02-27 13:46:52",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("997",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Banner-with-mask.png","","2540","2540","","10","0","1","2024-02-27 13:46:53",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("998",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Categories.png","","4021","4275","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"2950","0"),
("999",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Testimonials-widget.png","","2163","2163","","10","0","1","2024-02-27 13:46:54",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1000",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Excerpt.png","","4251","4505","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"3200","0"),
("1001",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Stock-status.png","","4432","4593","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"3178","0"),
("1002",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Fancy-button.png","","2527","2527","","10","0","1","2024-02-27 13:46:57",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1003",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Blog.png","","2578","2578","","10","0","1","2024-02-27 13:46:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1004",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Autoscrolling-text.png","","2288","2288","","10","0","1","2024-02-27 13:46:58",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1005",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Slider.png","","2130","2130","","10","0","1","2024-02-27 13:46:59",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1006",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Custom-carousel.png","","2375","2375","","10","0","1","2024-02-27 13:47:00",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1007",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Image.png","","3638","3855","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"2698","0"),
("1008",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Rating.png","","4344","4519","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"3092","0"),
("1009",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Wishlist.png","","4166","4367","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"2962","0"),
("1010",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Menu.png","","2450","2450","","10","0","1","2024-02-27 13:47:03",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1011",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Brands.png","","2277","2277","","10","0","1","2024-02-27 13:47:04",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1012",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Tabs.png","","2351","2351","","10","0","1","2024-02-27 13:47:05",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1013",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Countdown.png","","2186","2186","","10","0","1","2024-02-27 13:47:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1014",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Team-member.png","","2427","2427","","10","0","1","2024-02-27 13:47:06",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1015",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Title-with-text.png","","2185","2185","","10","0","1","2024-02-27 13:47:07",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1016",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Icon-Box.png","","2528","2528","","10","0","1","2024-02-27 13:47:08",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1017",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Products.png","","2374","2374","","10","0","1","2024-02-27 13:47:09",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1018",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Sku.png","","4308","4526","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"3296","0"),
("1019",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Instagram.png","","2322","2322","","10","0","1","2024-02-27 13:47:11",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1020",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Social-links.png","","2757","2757","","10","0","1","2024-02-27 13:47:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1021",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Best-offer.png","","2270","2270","","10","0","1","2024-02-27 13:47:12",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1022",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Price.png","","4704","4924","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"3448","0"),
("1023",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/vc/Twitter.png","","2357","2357","","10","0","1","2024-02-27 13:47:14",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1024",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/theme/assets/images/icon_etheme.png","","773","3489","","10","0","1","2025-03-24 13:11:19",NULL,NULL,NULL,NULL,NULL,"516","0"),
("1025",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/screenshot.png","","3660","3660","","10","0","1","2024-02-27 13:47:16",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1026",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-403x190.png","","103","103","","10","0","1","2024-02-27 13:47:17",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1059",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-929x215.png","","118","118","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1060",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-250x250.png","","101","101","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1061",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-88x84.png","","87","88","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1062",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-85x85.png","","87","88","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1063",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-70x81.png","","86","87","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1064",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-190x250.png","","100","100","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1065",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-354x537.png","","118","118","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1066",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-448x537.png","","123","124","","10","0","1","2024-02-28 16:19:25",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1067",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-638x397.png","","125","125","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1068",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-630x700.png","","148","148","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1069",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-41x41.png","","83","84","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1070",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-141x56.png","","88","89","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1071",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-322x387.png","","108","109","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1072",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-641x453.png","","129","129","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1073",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-13x24.png","","82","83","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1074",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1026x387.png","","141","142","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1075",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1200x1200.png","","269","269","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1076",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-168x81.png","","92","93","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1077",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-101x80.png","","88","89","","10","0","1","2024-02-28 16:19:26",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1078",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1049x1050.png","","229","229","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1079",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-449x328.png","","112","112","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1080",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-402x190.png","","103","103","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1081",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-449x329.png","","111","111","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1082",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-258x41.png","","90","91","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1083",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-130x67.png","","88","89","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1084",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-100x100.png","","90","91","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1085",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1050x1050.png","","229","229","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1086",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-128x80.png","","90","91","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1087",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-15x15.png","","82","83","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1088",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-37x44.png","","83","84","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1089",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-640x470.png","","131","131","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1090",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-106x63.png","","87","88","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1091",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1410x195.png","","127","128","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1092",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-190x249.png","","100","100","","10","0","1","2024-02-28 16:19:27",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1093",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/assets/images/error-icon.png","","666","1318","","10","0","1","2025-03-24 13:11:20",NULL,NULL,NULL,NULL,NULL,"522","0"),
("1094",NULL,NULL,NULL,"ABSPATHwp-content/themes/xstore/framework/panel/images/welcome/9.2-banner-0.jpg","","63435","63435","","10","0","1","2024-07-05 05:49:23",NULL,NULL,NULL,NULL,NULL,NULL,NULL),
("1095",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-26x26.png","","96","121","","10","0","1","2024-07-08 14:49:24",NULL,NULL,NULL,NULL,NULL,"34","0"),
("1100","4072","media","full","ABSPATHwp-content/uploads/2021/05/email_2099199.png","","627","701","","10","0","1","2024-10-22 14:51:36",NULL,NULL,NULL,NULL,NULL,"308","0"),
("1101","4072","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2021/05/email_2099199-1x1.png","","68","68","","10","0","1","2024-10-22 14:51:36",NULL,NULL,NULL,NULL,NULL,"34","0"),
("1102","4072","media","etheme-nimi","ABSPATHwp-content/uploads/2021/05/email_2099199-10x10.png","","157","171","","10","0","1","2024-10-22 14:51:36",NULL,NULL,NULL,NULL,NULL,"102","0"),
("1103",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-256x256.png","","102","102","","10","0","1","2024-10-22 15:19:41",NULL,NULL,NULL,NULL,NULL,"42","0"),
("1104",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-21x21.png","","82","83","","10","0","1","2024-10-22 15:19:41",NULL,NULL,NULL,NULL,NULL,"34","0"),
("1109",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-200x63.png","","91","92","","10","0","1","2024-10-22 16:22:37",NULL,NULL,NULL,NULL,NULL,"40","0"),
("1110",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-96x96.png","","88","89","","10","0","1","2024-10-22 16:22:37",NULL,NULL,NULL,NULL,NULL,"40","0"),
("1111","4155","media","full","ABSPATHwp-content/uploads/2024/10/2148299644-1.jpg","","369261","403018","","10","0","1","2024-10-22 17:21:37",NULL,NULL,NULL,NULL,NULL,"26894","0"),
("1112","4155","media","medium","ABSPATHwp-content/uploads/2024/10/2148299644-1-500x500.jpg","","31518","32619","","10","0","1","2024-10-22 17:21:37",NULL,NULL,NULL,NULL,NULL,"12858","0"),
("1113","4155","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2148299644-1-300x300.jpg","","13551","13997","","10","0","1","2024-10-22 17:21:37",NULL,NULL,NULL,NULL,NULL,"6084","0"),
("1114","4155","media","medium_large","ABSPATHwp-content/uploads/2024/10/2148299644-1-768x768.jpg","","58081","59704","","10","0","1","2024-10-22 17:21:37",NULL,NULL,NULL,NULL,NULL,"20220","0"),
("1115","4155","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2148299644-1-600x600.jpg","","37432","38448","","10","0","1","2024-10-22 17:21:38",NULL,NULL,NULL,NULL,NULL,"14102","0"),
("1116","4155","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2148299644-1-100x100.jpg","","2725","3199","","10","0","1","2024-10-22 17:21:38",NULL,NULL,NULL,NULL,NULL,"1388","0"),
("1117","4155","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2148299644-1-1x1.jpg","","285","759","","10","0","1","2024-10-22 17:21:38",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1118","4155","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2148299644-1-10x10.jpg","","408","882","","10","0","1","2024-10-22 17:21:38",NULL,NULL,NULL,NULL,NULL,"140","0"),
("1119","4158","media","full","ABSPATHwp-content/uploads/2024/10/633.jpg","","46633","51099","","10","0","1","2024-10-22 17:28:20",NULL,NULL,NULL,NULL,NULL,"6222","0"),
("1120","4158","media","medium","ABSPATHwp-content/uploads/2024/10/633-500x500.jpg","","9141","9613","","10","0","1","2024-10-22 17:28:20",NULL,NULL,NULL,NULL,NULL,"2584","0"),
("1121","4158","media","thumbnail","ABSPATHwp-content/uploads/2024/10/633-300x300.jpg","","4072","4547","","10","0","1","2024-10-22 17:28:20",NULL,NULL,NULL,NULL,NULL,"1350","0"),
("1122","4158","media","medium_large","ABSPATHwp-content/uploads/2024/10/633-768x768.jpg","","17241","17944","","10","0","1","2024-10-22 17:28:20",NULL,NULL,NULL,NULL,NULL,"4110","0"),
("1123","4158","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/633-600x600.jpg","","11445","11889","","10","0","1","2024-10-22 17:28:21",NULL,NULL,NULL,NULL,NULL,"2882","0"),
("1124","4158","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/633-100x100.jpg","","1134","1608","","10","0","1","2024-10-22 17:28:21",NULL,NULL,NULL,NULL,NULL,"368","0"),
("1125","4158","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/633-1x1.jpg","","283","757","","10","0","1","2024-10-22 17:28:21",NULL,NULL,NULL,NULL,NULL,"44","0"),
("1126","4158","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/633-10x10.jpg","","352","826","","10","0","1","2024-10-22 17:28:21",NULL,NULL,NULL,NULL,NULL,"80","0"),
("1127","4161","media","full","ABSPATHwp-content/uploads/2024/10/2147692239.jpg","","286432","303819","","10","0","1","2024-10-22 17:30:53",NULL,NULL,NULL,NULL,NULL,"13394","0"),
("1128","4161","media","medium","ABSPATHwp-content/uploads/2024/10/2147692239-500x500.jpg","","18390","19219","","10","0","1","2024-10-22 17:30:53",NULL,NULL,NULL,NULL,NULL,"5950","0"),
("1129","4161","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2147692239-300x300.jpg","","7456","7929","","10","0","1","2024-10-22 17:30:53",NULL,NULL,NULL,NULL,NULL,"2874","0"),
("1130","4161","media","medium_large","ABSPATHwp-content/uploads/2024/10/2147692239-768x768.jpg","","36558","37542","","10","0","1","2024-10-22 17:30:53",NULL,NULL,NULL,NULL,NULL,"9786","0"),
("1131","4161","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2147692239-600x600.jpg","","22252","22850","","10","0","1","2024-10-22 17:30:54",NULL,NULL,NULL,NULL,NULL,"6614","0"),
("1132","4161","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2147692239-100x100.jpg","","1603","2077","","10","0","1","2024-10-22 17:30:54",NULL,NULL,NULL,NULL,NULL,"748","0"),
("1133","4161","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2147692239-1x1.jpg","","285","759","","10","0","1","2024-10-22 17:30:54",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1134","4161","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2147692239-10x10.jpg","","356","830","","10","0","1","2024-10-22 17:30:54",NULL,NULL,NULL,NULL,NULL,"100","0"),
("1135","4168","media","full","ABSPATHwp-content/uploads/2024/10/487.jpg","","162718","173918","","10","0","1","2024-10-23 09:30:05",NULL,NULL,NULL,NULL,NULL,"25546","0"),
("1136","4168","media","medium","ABSPATHwp-content/uploads/2024/10/487-500x500.jpg","","31469","32421","","10","0","1","2024-10-23 09:30:05",NULL,NULL,NULL,NULL,NULL,"13066","0"),
("1137","4168","media","thumbnail","ABSPATHwp-content/uploads/2024/10/487-300x300.jpg","","15656","16383","","10","0","1","2024-10-23 09:30:05",NULL,NULL,NULL,NULL,NULL,"7388","0"),
("1138","4168","media","medium_large","ABSPATHwp-content/uploads/2024/10/487-768x768.jpg","","54517","55760","","10","0","1","2024-10-23 09:30:06",NULL,NULL,NULL,NULL,NULL,"19368","0"),
("1139","4168","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/487-600x600.jpg","","38326","39277","","10","0","1","2024-10-23 09:30:06",NULL,NULL,NULL,NULL,NULL,"14374","0"),
("1140","4168","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/487-100x100.jpg","","4010","4483","","10","0","1","2024-10-23 09:30:06",NULL,NULL,NULL,NULL,NULL,"2236","0"),
("1141","4168","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/487-1x1.jpg","","285","759","","10","0","1","2024-10-23 09:30:06",NULL,NULL,NULL,NULL,NULL,"48","0"),
("1142","4168","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/487-10x10.jpg","","430","904","","10","0","1","2024-10-23 09:30:06",NULL,NULL,NULL,NULL,NULL,"136","0"),
("1143","4169","media","full","ABSPATHwp-content/uploads/2024/10/452.jpg","","382437","428879","","10","0","1","2024-10-23 09:30:24",NULL,NULL,NULL,NULL,NULL,"65336","0"),
("1144","4169","media","medium","ABSPATHwp-content/uploads/2024/10/452-500x500.jpg","","47680","52216","","10","0","1","2024-10-23 09:30:24",NULL,NULL,NULL,NULL,NULL,"24424","0"),
("1145","4169","media","thumbnail","ABSPATHwp-content/uploads/2024/10/452-300x300.jpg","","19425","21080","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"10406","0");

INSERT IGNORE INTO `wp_ewwwio_images` VALUES 
("1146","4169","media","medium_large","ABSPATHwp-content/uploads/2024/10/452-768x768.jpg","","89034","97734","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"45062","0"),
("1147","4169","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/452-600x600.jpg","","57348","62826","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"30024","0"),
("1148","4169","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/452-100x100.jpg","","3328","3800","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"1790","0"),
("1149","4169","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/452-1x1.jpg","","285","759","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"50","0"),
("1150","4169","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/452-10x10.jpg","","411","885","","10","0","1","2024-10-23 09:30:25",NULL,NULL,NULL,NULL,NULL,"134","0"),
("1165","4174","media","full","ABSPATHwp-content/uploads/2024/10/96479.jpg","","78813","82275","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"45716","0"),
("1166","4174","media","medium","ABSPATHwp-content/uploads/2024/10/96479-500x500.jpg","","58149","60624","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"39842","0"),
("1167","4174","media","thumbnail","ABSPATHwp-content/uploads/2024/10/96479-300x300.jpg","","25144","26064","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"18358","0"),
("1168","4174","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/96479-600x600.jpg","","68043","70644","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"40862","0"),
("1169","4174","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/96479-100x100.jpg","","4588","4588","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"3254","0"),
("1170","4174","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/96479-1x1.jpg","","288","288","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"62","0"),
("1171","4174","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/96479-10x10.jpg","","462","462","","10","0","1","2024-10-23 10:37:17",NULL,NULL,NULL,NULL,NULL,"196","0"),
("1180",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-300x300.png","","105","105","","10","0","1","2024-10-23 12:19:12",NULL,NULL,NULL,NULL,NULL,"42","0"),
("1181","4205","media","full","ABSPATHwp-content/uploads/2024/10/makeup_4446346-1.png","","9828","13952","","10","0","1","2024-10-23 13:42:21",NULL,NULL,NULL,NULL,NULL,"6696","0"),
("1182","4205","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/makeup_4446346-1-100x100.png","","7803","9650","","10","0","1","2024-10-23 13:42:21",NULL,NULL,NULL,NULL,NULL,"6398","0"),
("1183","4205","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/makeup_4446346-1-1x1.png","","70","70","","10","0","1","2024-10-23 13:42:21",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1184","4205","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/makeup_4446346-1-10x10.png","","469","469","","10","0","1","2024-10-23 13:42:21",NULL,NULL,NULL,NULL,NULL,"432","0"),
("1185","4206","media","full","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1.png","","77502","85799","","10","0","1","2024-10-23 13:42:26",NULL,NULL,NULL,NULL,NULL,"48816","0"),
("1186","4206","media","medium","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-500x500.png","","93324","97814","","10","0","1","2024-10-23 13:42:27",NULL,NULL,NULL,NULL,NULL,"58048","0"),
("1187","4206","media","thumbnail","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-300x300.png","","37624","44455","","10","0","1","2024-10-23 13:42:28",NULL,NULL,NULL,NULL,NULL,"25342","0"),
("1188","4206","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-100x100.png","","8090","9827","","10","0","1","2024-10-23 13:42:28",NULL,NULL,NULL,NULL,NULL,"6566","0"),
("1189","4206","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-1x1.png","","70","70","","10","0","1","2024-10-23 13:42:28",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1190","4206","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-10x10.png","","465","465","","10","0","1","2024-10-23 13:42:28",NULL,NULL,NULL,NULL,NULL,"440","0"),
("1191","4206","media","site_icon-270","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-270x270.png","","31341","37869","","10","0","1","2024-10-23 13:42:28",NULL,NULL,NULL,NULL,NULL,"21556","0"),
("1192","4206","media","site_icon-192","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-192x192.png","","15787","20641","","10","0","1","2024-10-23 13:42:29",NULL,NULL,NULL,NULL,NULL,"12824","0"),
("1193","4206","media","site_icon-180","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-180x180.png","","16597","20844","","10","0","1","2024-10-23 13:42:29",NULL,NULL,NULL,NULL,NULL,"12904","0"),
("1194","4206","media","site_icon-32","ABSPATHwp-content/uploads/2024/10/cropped-makeup_4446346-1-32x32.png","","2263","2352","","10","0","1","2024-10-23 13:42:29",NULL,NULL,NULL,NULL,NULL,"1886","0"),
("1195","4218","media","full","ABSPATHwp-content/uploads/2024/10/101997.jpg","","41109","42656","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"5890","0"),
("1196","4218","media","medium","ABSPATHwp-content/uploads/2024/10/101997-500x500.jpg","","10694","10694","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"2744","0"),
("1197","4218","media","thumbnail","ABSPATHwp-content/uploads/2024/10/101997-300x300.jpg","","4803","5276","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"1072","0"),
("1198","4218","media","medium_large","ABSPATHwp-content/uploads/2024/10/101997-768x768.jpg","","19348","19348","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"4502","0"),
("1199","4218","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/101997-600x600.jpg","","13610","13610","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"3318","0"),
("1200","4218","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/101997-100x100.jpg","","1145","1619","","10","0","1","2024-10-23 14:13:33",NULL,NULL,NULL,NULL,NULL,"320","0"),
("1201","4218","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/101997-1x1.jpg","","286","760","","10","0","1","2024-10-23 14:13:34",NULL,NULL,NULL,NULL,NULL,"58","0"),
("1202","4218","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/101997-10x10.jpg","","354","828","","10","0","1","2024-10-23 14:13:34",NULL,NULL,NULL,NULL,NULL,"80","0"),
("1203","4235","media","full","ABSPATHwp-content/uploads/2024/10/2148620110-1.jpg","","631241","689898","","10","0","1","2024-10-23 14:40:47",NULL,NULL,NULL,NULL,NULL,"58216","0"),
("1204","4235","media","medium","ABSPATHwp-content/uploads/2024/10/2148620110-1-500x321.jpg","","32258","34195","","10","0","1","2024-10-23 14:40:47",NULL,NULL,NULL,NULL,NULL,"16150","0"),
("1205","4235","media","large","ABSPATHwp-content/uploads/2024/10/2148620110-1-1200x771.jpg","","119428","124730","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"47938","0"),
("1206","4235","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2148620110-1-300x193.jpg","","14921","15897","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"7812","0"),
("1207","4235","media","medium_large","ABSPATHwp-content/uploads/2024/10/2148620110-1-768x494.jpg","","55932","58766","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"24754","0"),
("1208","4235","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2148620110-1-300x300.jpg","","20393","21521","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"10144","0"),
("1209","4235","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2148620110-1-600x386.jpg","","42578","45085","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"20768","0"),
("1210","4235","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2148620110-1-100x100.jpg","","4298","4772","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"2308","0"),
("1211","4235","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2148620110-1-1x1.jpg","","285","759","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"54","0"),
("1212","4235","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2148620110-1-10x6.jpg","","435","909","","10","0","1","2024-10-23 14:40:48",NULL,NULL,NULL,NULL,NULL,"138","0"),
("1223","4240","media","full","ABSPATHwp-content/uploads/2024/10/2148301854.jpg","","462016","495523","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"54102","0"),
("1224","4240","media","medium","ABSPATHwp-content/uploads/2024/10/2148301854-500x334.jpg","","52838","54836","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"27390","0"),
("1225","4240","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2148301854-300x200.jpg","","24573","25668","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"14106","0"),
("1226","4240","media","medium_large","ABSPATHwp-content/uploads/2024/10/2148301854-768x512.jpg","","90644","93838","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"41592","0"),
("1227","4240","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2148301854-300x300.jpg","","33078","34456","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"17698","0"),
("1228","4240","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2148301854-600x400.jpg","","69417","72101","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"35240","0"),
("1229","4240","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2148301854-100x100.jpg","","7192","7667","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"4372","0"),
("1230","4240","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2148301854-1x1.jpg","","285","759","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"56","0"),
("1231","4240","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2148301854-10x7.jpg","","402","876","","10","0","1","2024-10-23 14:50:19",NULL,NULL,NULL,NULL,NULL,"160","0"),
("1232","4248","media","full","ABSPATHwp-content/uploads/2024/10/2147878830.jpg","","620544","658279","","10","0","1","2024-10-23 15:16:44",NULL,NULL,NULL,NULL,NULL,"105728","0"),
("1233","4248","media","medium","ABSPATHwp-content/uploads/2024/10/2147878830-500x334.jpg","","80006","83174","","10","0","1","2024-10-23 15:16:44",NULL,NULL,NULL,NULL,NULL,"45636","0"),
("1234","4248","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-300x200.jpg","","35813","37568","","10","0","1","2024-10-23 15:16:44",NULL,NULL,NULL,NULL,NULL,"21554","0"),
("1235","4248","media","medium_large","ABSPATHwp-content/uploads/2024/10/2147878830-768x512.jpg","","140014","144608","","10","0","1","2024-10-23 15:16:44",NULL,NULL,NULL,NULL,NULL,"76998","0"),
("1236","4248","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-300x300.jpg","","45336","47173","","10","0","1","2024-10-23 15:16:44",NULL,NULL,NULL,NULL,NULL,"26274","0"),
("1237","4248","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2147878830-600x400.jpg","","106266","110158","","10","0","1","2024-10-23 15:16:45",NULL,NULL,NULL,NULL,NULL,"60994","0"),
("1238","4248","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-100x100.jpg","","8776","9247","","10","0","1","2024-10-23 15:16:45",NULL,NULL,NULL,NULL,NULL,"5274","0"),
("1239","4248","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2147878830-1x1.jpg","","286","760","","10","0","1","2024-10-23 15:16:45",NULL,NULL,NULL,NULL,NULL,"58","0"),
("1240","4248","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2147878830-10x7.jpg","","442","916","","10","0","1","2024-10-23 15:16:45",NULL,NULL,NULL,NULL,NULL,"170","0"),
("1241","4249","media","full","ABSPATHwp-content/uploads/2024/10/2147878830-1.jpg","","109696","113696","","10","0","1","2024-10-23 15:18:48",NULL,NULL,NULL,NULL,NULL,"57300","0"),
("1242","4249","media","medium","ABSPATHwp-content/uploads/2024/10/2147878830-1-500x334.jpg","","42679","43747","","10","0","1","2024-10-23 15:18:48",NULL,NULL,NULL,NULL,NULL,"26820","0"),
("1243","4249","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-1-300x200.jpg","","19312","19862","","10","0","1","2024-10-23 15:18:48",NULL,NULL,NULL,NULL,NULL,"13238","0"),
("1244","4249","media","medium_large","ABSPATHwp-content/uploads/2024/10/2147878830-1-768x512.jpg","","73718","75091","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"40618","0"),
("1245","4249","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-1-300x300.jpg","","24594","25066","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"15300","0"),
("1246","4249","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2147878830-1-600x400.jpg","","56270","57702","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"34740","0"),
("1247","4249","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2147878830-1-100x100.jpg","","4966","4966","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"3518","0"),
("1248","4249","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2147878830-1-1x1.jpg","","286","286","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"52","0"),
("1249","4249","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2147878830-1-10x7.jpg","","365","365","","10","0","1","2024-10-23 15:18:49",NULL,NULL,NULL,NULL,NULL,"116","0"),
("1250",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-601x601.png","","138","139","","10","0","1","2024-10-23 15:22:35",NULL,NULL,NULL,NULL,NULL,"58","0"),
("1251",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-667x667.png","","149","149","","10","0","1","2024-10-23 15:22:35",NULL,NULL,NULL,NULL,NULL,"58","0"),
("1252","4254","media","full","ABSPATHwp-content/uploads/2024/10/2148181425.jpg","","232880","246713","","10","0","1","2024-10-23 15:24:25",NULL,NULL,NULL,NULL,NULL,"104760","0"),
("1253","4254","media","medium","ABSPATHwp-content/uploads/2024/10/2148181425-500x333.jpg","","38838","40321","","10","0","1","2024-10-23 15:24:25",NULL,NULL,NULL,NULL,NULL,"22738","0"),
("1254","4254","media","large","ABSPATHwp-content/uploads/2024/10/2148181425-1200x800.jpg","","165495","172425","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"80842","0"),
("1255","4254","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2148181425-300x200.jpg","","16178","16522","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"9914","0"),
("1256","4254","media","medium_large","ABSPATHwp-content/uploads/2024/10/2148181425-768x512.jpg","","71745","74786","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"34672","0"),
("1257","4254","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2148181425-300x300.jpg","","21629","22318","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"12302","0"),
("1258","4254","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2148181425-600x400.jpg","","53600","55924","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"31890","0"),
("1259","4254","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2148181425-100x100.jpg","","3995","3996","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"2540","0"),
("1260","4254","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2148181425-1x1.jpg","","286","286","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"50","0"),
("1261","4254","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2148181425-10x7.jpg","","376","376","","10","0","1","2024-10-23 15:24:26",NULL,NULL,NULL,NULL,NULL,"122","0"),
("1262","4265","media","full","ABSPATHwp-content/uploads/2024/10/21330.jpg","","140523","147353","","10","0","1","2024-10-23 15:46:13",NULL,NULL,NULL,NULL,NULL,"85458","0"),
("1263","4265","media","medium","ABSPATHwp-content/uploads/2024/10/21330-500x334.jpg","","53223","55450","","10","0","1","2024-10-23 15:46:13",NULL,NULL,NULL,NULL,NULL,"38180","0"),
("1264","4265","media","thumbnail","ABSPATHwp-content/uploads/2024/10/21330-300x200.jpg","","23894","24812","","10","0","1","2024-10-23 15:46:13",NULL,NULL,NULL,NULL,NULL,"17640","0"),
("1265","4265","media","medium_large","ABSPATHwp-content/uploads/2024/10/21330-768x512.jpg","","94021","97962","","10","0","1","2024-10-23 15:46:13",NULL,NULL,NULL,NULL,NULL,"60182","0"),
("1266","4265","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/21330-300x300.jpg","","31092","32304","","10","0","1","2024-10-23 15:46:13",NULL,NULL,NULL,NULL,NULL,"22176","0"),
("1267","4265","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/21330-600x400.jpg","","70721","73868","","10","0","1","2024-10-23 15:46:14",NULL,NULL,NULL,NULL,NULL,"49944","0"),
("1268","4265","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/21330-100x100.jpg","","6151","6151","","10","0","1","2024-10-23 15:46:14",NULL,NULL,NULL,NULL,NULL,"4630","0"),
("1269","4265","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/21330-1x1.jpg","","287","287","","10","0","1","2024-10-23 15:46:14",NULL,NULL,NULL,NULL,NULL,"52","0"),
("1270","4265","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/21330-10x7.jpg","","385","385","","10","0","1","2024-10-23 15:46:14",NULL,NULL,NULL,NULL,NULL,"124","0"),
("1271","4266","media","full","ABSPATHwp-content/uploads/2024/10/2148301886-1-1.jpg","","233457","243788","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"27236","0"),
("1272","4266","media","medium","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-500x66.jpg","","13358","14088","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"7670","0"),
("1273","4266","media","large","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-1200x157.jpg","","58738","61220","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"35014","0"),
("1274","4266","media","thumbnail","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-300x39.jpg","","5500","5975","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"3302","0"),
("1275","4266","media","medium_large","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-768x101.jpg","","26822","28186","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"15792","0"),
("1276","4266","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-300x185.jpg","","12035","12420","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"6734","0"),
("1277","4266","media","woocommerce_single","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-600x79.jpg","","17129","18144","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"10072","0"),
("1278","4266","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-100x100.jpg","","2085","2559","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"932","0"),
("1279","4266","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-1x1.jpg","","285","759","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"54","0"),
("1280","4266","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/2148301886-1-1-10x1.jpg","","341","815","","10","0","1","2024-10-23 15:52:39",NULL,NULL,NULL,NULL,NULL,"82","0"),
("1281",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-1410x185.png","","126","126","","10","0","1","2024-10-23 16:19:16",NULL,NULL,NULL,NULL,NULL,"50","0"),
("1282","4298","media","full","ABSPATHwp-content/uploads/2021/05/letter_15054864.png","","1896","2869","","10","0","1","2024-10-23 16:24:26",NULL,NULL,NULL,NULL,NULL,"1198","0"),
("1283","4298","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2021/05/letter_15054864-1x1.png","","70","70","","10","0","1","2024-10-23 16:24:26",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1284","4298","media","etheme-nimi","ABSPATHwp-content/uploads/2021/05/letter_15054864-10x10.png","","417","417","","10","0","1","2024-10-23 16:24:26",NULL,NULL,NULL,NULL,NULL,"282","0"),
("1285","4302","media","full","ABSPATHwp-content/uploads/2021/05/message_2041219.png","","2233","3157","","10","0","1","2024-10-23 16:26:41",NULL,NULL,NULL,NULL,NULL,"1818","0"),
("1286","4302","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2021/05/message_2041219-1x1.png","","70","70","","10","0","1","2024-10-23 16:26:41",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1287","4302","media","etheme-nimi","ABSPATHwp-content/uploads/2021/05/message_2041219-10x10.png","","438","440","","10","0","1","2024-10-23 16:26:41",NULL,NULL,NULL,NULL,NULL,"358","0"),
("1299",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-400x400.png","","113","113","","10","0","1","2024-10-24 13:10:48",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1304","4359","media","full","ABSPATHwp-content/uploads/2024/12/logo.png","","8885","11586","","10","0","1","2024-12-09 11:32:36",NULL,NULL,NULL,NULL,NULL,"6260","0"),
("1305","4359","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/logo-100x100.png","","7135","7135","","10","0","1","2024-12-09 11:32:36",NULL,NULL,NULL,NULL,NULL,"5798","0"),
("1306","4359","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/logo-1x1.png","","70","70","","10","0","1","2024-12-09 11:32:36",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1307","4359","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/logo-10x10.png","","461","461","","10","0","1","2024-12-09 11:32:36",NULL,NULL,NULL,NULL,NULL,"0","5"),
("1308","4361","media","full","ABSPATHwp-content/uploads/2021/05/letter_12094745.png","","1697","2615","","10","0","1","2024-12-09 11:43:26",NULL,NULL,NULL,NULL,NULL,"1298","0"),
("1309","4361","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2021/05/letter_12094745-1x1.png","","70","70","","10","0","1","2024-12-09 11:43:26",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1310","4361","media","etheme-nimi","ABSPATHwp-content/uploads/2021/05/letter_12094745-10x10.png","","343","343","","10","0","1","2024-12-09 11:43:26",NULL,NULL,NULL,NULL,NULL,"318","0"),
("1311","4372","media","full","ABSPATHwp-content/uploads/2024/10/anpc-sol.png","","62340","62918","","10","0","1","2024-12-09 12:01:54",NULL,NULL,NULL,NULL,NULL,"42408","0"),
("1312","4372","media","medium","ABSPATHwp-content/uploads/2024/10/anpc-sol-500x140.png","","64852","64930","","10","0","1","2024-12-09 12:01:55",NULL,NULL,NULL,NULL,NULL,"44516","0"),
("1313","4372","media","thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sol-300x84.png","","26582","26582","","10","0","1","2024-12-09 12:01:55",NULL,NULL,NULL,NULL,NULL,"18556","0"),
("1314","4372","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sol-300x144.png","","47875","47899","","10","0","1","2024-12-09 12:01:56",NULL,NULL,NULL,NULL,NULL,"33042","0"),
("1315","4372","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sol-100x100.png","","15728","15728","","10","0","1","2024-12-09 12:01:56",NULL,NULL,NULL,NULL,NULL,"11448","0"),
("1316","4372","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/anpc-sol-1x1.png","","70","70","","10","0","1","2024-12-09 12:01:56",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1317","4372","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/anpc-sol-10x3.png","","186","191","","10","0","1","2024-12-09 12:01:56",NULL,NULL,NULL,NULL,NULL,"172","0"),
("1318","4373","media","full","ABSPATHwp-content/uploads/2024/10/anpc-sal.png","","80376","80978","","10","0","1","2024-12-09 12:03:03",NULL,NULL,NULL,NULL,NULL,"55480","0"),
("1319","4373","media","medium","ABSPATHwp-content/uploads/2024/10/anpc-sal-500x128.png","","77752","77873","","10","0","1","2024-12-09 12:03:04",NULL,NULL,NULL,NULL,NULL,"54632","0"),
("1320","4373","media","thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sal-300x77.png","","32264","32264","","10","0","1","2024-12-09 12:03:04",NULL,NULL,NULL,NULL,NULL,"23054","0"),
("1321","4373","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sal-300x136.png","","45850","45897","","10","0","1","2024-12-09 12:03:04",NULL,NULL,NULL,NULL,NULL,"31546","0"),
("1322","4373","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/10/anpc-sal-100x100.png","","9852","9852","","10","0","1","2024-12-09 12:03:04",NULL,NULL,NULL,NULL,NULL,"7120","0"),
("1323","4373","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/10/anpc-sal-1x1.png","","70","70","","10","0","1","2024-12-09 12:03:04",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1324","4373","media","etheme-nimi","ABSPATHwp-content/uploads/2024/10/anpc-sal-10x3.png","","186","191","","10","0","1","2024-12-09 12:03:05",NULL,NULL,NULL,NULL,NULL,"0","5"),
("1325",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-180x46.png","","88","89","","10","0","1","2024-12-09 12:10:47",NULL,NULL,NULL,NULL,NULL,"40","0"),
("1326",NULL,NULL,NULL,"ABSPATHwp-content/ewww/lazy/placeholder-180x50.png","","88","89","","10","0","1","2024-12-09 12:10:47",NULL,NULL,NULL,NULL,NULL,"40","0"),
("1327","4395","media","full","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1.png","","16194","20116","","10","0","1","2024-12-09 12:22:40",NULL,NULL,NULL,NULL,NULL,"9194","0"),
("1328","4395","media","medium","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1-500x500.png","","38636","39311","","10","0","1","2024-12-09 12:22:41",NULL,NULL,NULL,NULL,NULL,"23918","0"),
("1329","4395","media","thumbnail","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1-300x300.png","","21393","23136","","10","0","1","2024-12-09 12:22:41",NULL,NULL,NULL,NULL,NULL,"14154","0"),
("1330","4395","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1-100x100.png","","6790","6790","","10","0","1","2024-12-09 12:22:41",NULL,NULL,NULL,NULL,NULL,"5694","0"),
("1331","4395","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1-1x1.png","","70","70","","10","0","1","2024-12-09 12:22:41",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1332","4395","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/eye-shadow_5945091-1-10x10.png","","461","461","","10","0","1","2024-12-09 12:22:41",NULL,NULL,NULL,NULL,NULL,"0","5"),
("1333","4396","media","full","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1.png","","19567","22239","","10","0","1","2024-12-09 12:24:08",NULL,NULL,NULL,NULL,NULL,"9194","0"),
("1334","4396","media","medium","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-500x500.png","","38636","39311","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"23918","0"),
("1335","4396","media","thumbnail","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-300x300.png","","21393","23136","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"14154","0"),
("1336","4396","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-100x100.png","","6790","6790","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"5694","0"),
("1337","4396","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-1x1.png","","70","70","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1338","4396","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-10x10.png","","461","461","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"0","5"),
("1339","4396","media","site_icon-270","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-270x270.png","","19104","20647","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"12948","0"),
("1340","4396","media","site_icon-192","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-192x192.png","","12836","13895","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"9330","0"),
("1341","4396","media","site_icon-180","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-180x180.png","","12043","13074","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"9066","0"),
("1342","4396","media","site_icon-32","ABSPATHwp-content/uploads/2024/12/cropped-eye-shadow_5945091-1-32x32.png","","2131","2131","","10","0","1","2024-12-09 12:24:09",NULL,NULL,NULL,NULL,NULL,"1776","0"),
("1343","4404","media","full","ABSPATHwp-content/uploads/2024/12/4862.jpg","","140184","149448","","10","0","1","2024-12-09 12:38:07",NULL,NULL,NULL,NULL,NULL,"38100","0"),
("1344","4404","media","medium","ABSPATHwp-content/uploads/2024/12/4862-500x500.jpg","","21839","23553","","10","0","1","2024-12-09 12:38:07",NULL,NULL,NULL,NULL,NULL,"11644","0"),
("1345","4404","media","thumbnail","ABSPATHwp-content/uploads/2024/12/4862-300x300.jpg","","9247","9730","","10","0","1","2024-12-09 12:38:07",NULL,NULL,NULL,NULL,NULL,"4572","0"),
("1346","4404","media","medium_large","ABSPATHwp-content/uploads/2024/12/4862-768x768.jpg","","43966","47769","","10","0","1","2024-12-09 12:38:07",NULL,NULL,NULL,NULL,NULL,"23618","0"),
("1347","4404","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/4862-600x600.jpg","","27259","29485","","10","0","1","2024-12-09 12:38:08",NULL,NULL,NULL,NULL,NULL,"14062","0"),
("1348","4404","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/4862-100x100.jpg","","1939","2415","","10","0","1","2024-12-09 12:38:08",NULL,NULL,NULL,NULL,NULL,"942","0"),
("1349","4404","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/4862-1x1.jpg","","285","759","","10","0","1","2024-12-09 12:38:08",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1350","4404","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/4862-10x10.jpg","","362","836","","10","0","1","2024-12-09 12:38:08",NULL,NULL,NULL,NULL,NULL,"120","0"),
("1351","4405","media","full","ABSPATHwp-content/uploads/2024/12/2148177422.jpg","","622303","677144","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"58904","0"),
("1352","4405","media","medium","ABSPATHwp-content/uploads/2024/12/2148177422-500x500.jpg","","39236","41835","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"19280","0"),
("1353","4405","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148177422-300x300.jpg","","15442","16381","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"7584","0"),
("1354","4405","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148177422-768x768.jpg","","78327","83656","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"37536","0"),
("1355","4405","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148177422-600x600.jpg","","46776","49772","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"23070","0"),
("1356","4405","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148177422-100x100.jpg","","2841","3313","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"1320","0"),
("1357","4405","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148177422-1x1.jpg","","284","758","","10","0","1","2024-12-09 12:38:42",NULL,NULL,NULL,NULL,NULL,"54","0"),
("1358","4405","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148177422-10x10.jpg","","391","865","","10","0","1","2024-12-09 12:38:43",NULL,NULL,NULL,NULL,NULL,"110","0"),
("1359","4406","media","full","ABSPATHwp-content/uploads/2024/12/2148299635.jpg","","543390","587709","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"31596","0"),
("1360","4406","media","medium","ABSPATHwp-content/uploads/2024/12/2148299635-500x500.jpg","","36155","38611","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"14526","0"),
("1361","4406","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148299635-300x300.jpg","","15795","17017","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"6764","0"),
("1362","4406","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148299635-768x768.jpg","","64676","68087","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"23170","0"),
("1363","4406","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148299635-600x600.jpg","","41315","43789","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"16094","0"),
("1364","4406","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148299635-100x100.jpg","","3453","3927","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"1566","0"),
("1365","4406","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148299635-1x1.jpg","","285","759","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"54","0"),
("1366","4406","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148299635-10x10.jpg","","435","909","","10","0","1","2024-12-09 12:39:28",NULL,NULL,NULL,NULL,NULL,"130","0"),
("1367","4407","media","full","ABSPATHwp-content/uploads/2024/12/105915.jpg","","382301","416479","","10","0","1","2024-12-09 12:40:34",NULL,NULL,NULL,NULL,NULL,"34790","0"),
("1368","4407","media","medium","ABSPATHwp-content/uploads/2024/12/105915-500x500.jpg","","33382","34342","","10","0","1","2024-12-09 12:40:34",NULL,NULL,NULL,NULL,NULL,"15874","0"),
("1369","4407","media","thumbnail","ABSPATHwp-content/uploads/2024/12/105915-300x300.jpg","","15373","16010","","10","0","1","2024-12-09 12:40:34",NULL,NULL,NULL,NULL,NULL,"7804","0"),
("1370","4407","media","medium_large","ABSPATHwp-content/uploads/2024/12/105915-768x768.jpg","","60192","61369","","10","0","1","2024-12-09 12:40:35",NULL,NULL,NULL,NULL,NULL,"25300","0"),
("1371","4407","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/105915-600x600.jpg","","39888","40867","","10","0","1","2024-12-09 12:40:35",NULL,NULL,NULL,NULL,NULL,"17908","0"),
("1372","4407","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/105915-100x100.jpg","","3129","3601","","10","0","1","2024-12-09 12:40:35",NULL,NULL,NULL,NULL,NULL,"1848","0"),
("1373","4407","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/105915-1x1.jpg","","283","757","","10","0","1","2024-12-09 12:40:35",NULL,NULL,NULL,NULL,NULL,"44","0"),
("1374","4407","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/105915-10x10.jpg","","402","876","","10","0","1","2024-12-09 12:40:35",NULL,NULL,NULL,NULL,NULL,"110","0"),
("1375","4408","media","full","ABSPATHwp-content/uploads/2024/12/2148328733.jpg","","650526","721583","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"74950","0"),
("1376","4408","media","medium","ABSPATHwp-content/uploads/2024/12/2148328733-500x334.jpg","","24327","25901","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"13056","0"),
("1377","4408","media","large","ABSPATHwp-content/uploads/2024/12/2148328733-1200x801.jpg","","120768","128175","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"55784","0"),
("1378","4408","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148328733-300x200.jpg","","9636","10109","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"5296","0"),
("1379","4408","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148328733-768x513.jpg","","49202","52238","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"24750","0"),
("1380","4408","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328733-300x300.jpg","","12973","13840","","10","0","1","2024-12-09 12:45:57",NULL,NULL,NULL,NULL,NULL,"6966","0"),
("1381","4408","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148328733-600x400.jpg","","34536","36978","","10","0","1","2024-12-09 12:45:58",NULL,NULL,NULL,NULL,NULL,"18294","0"),
("1382","4408","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328733-100x100.jpg","","2224","2698","","10","0","1","2024-12-09 12:45:58",NULL,NULL,NULL,NULL,NULL,"1258","0"),
("1383","4408","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148328733-1x1.jpg","","283","757","","10","0","1","2024-12-09 12:45:58",NULL,NULL,NULL,NULL,NULL,"44","0"),
("1384","4408","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148328733-10x7.jpg","","386","860","","10","0","1","2024-12-09 12:45:58",NULL,NULL,NULL,NULL,NULL,"108","0"),
("1385","4409","media","full","ABSPATHwp-content/uploads/2024/12/2148328681.jpg","","537018","595222","","10","0","1","2024-12-09 12:47:25",NULL,NULL,NULL,NULL,NULL,"65250","0"),
("1386","4409","media","medium","ABSPATHwp-content/uploads/2024/12/2148328681-500x334.jpg","","27102","28981","","10","0","1","2024-12-09 12:47:25",NULL,NULL,NULL,NULL,NULL,"12878","0"),
("1387","4409","media","large","ABSPATHwp-content/uploads/2024/12/2148328681-1200x801.jpg","","109013","115358","","10","0","1","2024-12-09 12:47:25",NULL,NULL,NULL,NULL,NULL,"49024","0"),
("1388","4409","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148328681-300x200.jpg","","12204","13099","","10","0","1","2024-12-09 12:47:25",NULL,NULL,NULL,NULL,NULL,"5944","0"),
("1389","4409","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148328681-768x513.jpg","","48884","51881","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"22596","0"),
("1390","4409","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328681-300x300.jpg","","15224","16386","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"7528","0"),
("1391","4409","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148328681-600x400.jpg","","36435","38955","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"17546","0"),
("1392","4409","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328681-100x100.jpg","","3181","3655","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"1714","0"),
("1393","4409","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148328681-1x1.jpg","","285","759","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"50","0"),
("1394","4409","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148328681-10x7.jpg","","400","876","","10","0","1","2024-12-09 12:47:26",NULL,NULL,NULL,NULL,NULL,"128","0"),
("1395","4410","media","full","ABSPATHwp-content/uploads/2024/12/2147970829.jpg","","547196","596528","","10","0","1","2024-12-09 12:49:38",NULL,NULL,NULL,NULL,NULL,"75748","0"),
("1396","4410","media","medium","ABSPATHwp-content/uploads/2024/12/2147970829-500x500.jpg","","67874","70823","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"37146","0"),
("1397","4410","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2147970829-300x300.jpg","","30922","32387","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"17532","0"),
("1398","4410","media","medium_large","ABSPATHwp-content/uploads/2024/12/2147970829-768x768.jpg","","118102","123123","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"57976","0"),
("1399","4410","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2147970829-600x600.jpg","","80167","83399","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"41554","0"),
("1400","4410","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2147970829-100x100.jpg","","6316","6792","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"3828","0"),
("1401","4410","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2147970829-1x1.jpg","","285","759","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"52","0"),
("1402","4410","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2147970829-10x10.jpg","","513","987","","10","0","1","2024-12-09 12:49:39",NULL,NULL,NULL,NULL,NULL,"194","0"),
("1403","4411","media","full","ABSPATHwp-content/uploads/2024/12/13617.jpg","","1882912","2011655","","10","0","1","2024-12-09 12:51:23",NULL,NULL,NULL,NULL,NULL,"266116","0"),
("1404","4411","media","medium","ABSPATHwp-content/uploads/2024/12/13617-500x341.jpg","","105847","111146","","10","0","1","2024-12-09 12:51:23",NULL,NULL,NULL,NULL,NULL,"58662","0"),
("1405","4411","media","large","ABSPATHwp-content/uploads/2024/12/13617-1200x818.jpg","","412161","430954","","10","0","1","2024-12-09 12:51:24",NULL,NULL,NULL,NULL,NULL,"209628","0"),
("1406","4411","media","thumbnail","ABSPATHwp-content/uploads/2024/12/13617-300x204.jpg","","44496","47013","","10","0","1","2024-12-09 12:51:24",NULL,NULL,NULL,NULL,NULL,"25602","0"),
("1407","4411","media","medium_large","ABSPATHwp-content/uploads/2024/12/13617-768x523.jpg","","192889","201899","","10","0","1","2024-12-09 12:51:24",NULL,NULL,NULL,NULL,NULL,"101810","0"),
("1408","4411","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/13617-300x300.jpg","","49336","51892","","10","0","1","2024-12-09 12:51:25",NULL,NULL,NULL,NULL,NULL,"26728","0"),
("1409","4411","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/13617-600x409.jpg","","144619","151706","","10","0","1","2024-12-09 12:51:25",NULL,NULL,NULL,NULL,NULL,"78958","0"),
("1410","4411","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/13617-100x100.jpg","","8897","9373","","10","0","1","2024-12-09 12:51:25",NULL,NULL,NULL,NULL,NULL,"5186","0"),
("1411","4411","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/13617-1x1.jpg","","285","759","","10","0","1","2024-12-09 12:51:25",NULL,NULL,NULL,NULL,NULL,"50","0"),
("1412","4411","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/13617-10x7.jpg","","464","938","","10","0","1","2024-12-09 12:51:25",NULL,NULL,NULL,NULL,NULL,"194","0"),
("1413","4413","media","full","ABSPATHwp-content/uploads/2024/12/2148328738.jpg","","1652592","1758790","","10","0","1","2024-12-09 12:55:09",NULL,NULL,NULL,NULL,NULL,"327896","0"),
("1414","4413","media","medium","ABSPATHwp-content/uploads/2024/12/2148328738-500x371.jpg","","67959","71006","","10","0","1","2024-12-09 12:55:09",NULL,NULL,NULL,NULL,NULL,"46594","0"),
("1415","4413","media","large","ABSPATHwp-content/uploads/2024/12/2148328738-1200x891.jpg","","333126","350976","","10","0","1","2024-12-09 12:55:10",NULL,NULL,NULL,NULL,NULL,"224696","0"),
("1416","4413","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148328738-300x223.jpg","","25947","27216","","10","0","1","2024-12-09 12:55:10",NULL,NULL,NULL,NULL,NULL,"17748","0"),
("1417","4413","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148328738-768x570.jpg","","138318","145070","","10","0","1","2024-12-09 12:55:10",NULL,NULL,NULL,NULL,NULL,"93774","0"),
("1418","4413","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328738-300x300.jpg","","35950","37578","","10","0","1","2024-12-09 12:55:10",NULL,NULL,NULL,NULL,NULL,"24190","0"),
("1419","4413","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148328738-600x446.jpg","","85203","89290","","10","0","1","2024-12-09 12:55:10",NULL,NULL,NULL,NULL,NULL,"58002","0"),
("1420","4413","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148328738-100x100.jpg","","5905","6378","","10","0","1","2024-12-09 12:55:11",NULL,NULL,NULL,NULL,NULL,"3762","0"),
("1421","4413","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148328738-1x1.jpg","","284","758","","10","0","1","2024-12-09 12:55:11",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1422","4413","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148328738-10x7.jpg","","388","862","","10","0","1","2024-12-09 12:55:11",NULL,NULL,NULL,NULL,NULL,"138","0"),
("1423","4414","media","full","ABSPATHwp-content/uploads/2024/12/2148129504.jpg","","19849","22073","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"8278","0"),
("1424","4414","media","medium","ABSPATHwp-content/uploads/2024/12/2148129504-500x66.jpg","","4926","4927","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"2684","0"),
("1425","4414","media","large","ABSPATHwp-content/uploads/2024/12/2148129504-1200x157.jpg","","18234","18794","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"8278","0"),
("1426","4414","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148129504-300x39.jpg","","2255","2256","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"1380","0"),
("1427","4414","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148129504-768x101.jpg","","9017","9018","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"4438","0"),
("1428","4414","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/2148129504-300x185.jpg","","2562","2565","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"336","0"),
("1429","4414","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148129504-600x79.jpg","","6070","6070","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"3164","0"),
("1430","4414","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148129504-100x100.jpg","","678","678","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"104","0"),
("1431","4414","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148129504-1x1.jpg","","285","285","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"44","0"),
("1432","4414","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148129504-10x1.jpg","","313","313","","10","0","1","2024-12-09 12:58:29",NULL,NULL,NULL,NULL,NULL,"64","0"),
("1433","4415","media","full","ABSPATHwp-content/uploads/2024/12/2148620011.jpg","","1236171","1306906","","10","0","1","2024-12-09 13:00:08",NULL,NULL,NULL,NULL,NULL,"168514","0"),
("1434","4415","media","medium","ABSPATHwp-content/uploads/2024/12/2148620011-500x317.jpg","","71358","74122","","10","0","1","2024-12-09 13:00:09",NULL,NULL,NULL,NULL,NULL,"42914","0"),
("1435","4415","media","large","ABSPATHwp-content/uploads/2024/12/2148620011-1200x761.jpg","","264375","272477","","10","0","1","2024-12-09 13:00:09",NULL,NULL,NULL,NULL,NULL,"136230","0"),
("1436","4415","media","thumbnail","ABSPATHwp-content/uploads/2024/12/2148620011-300x190.jpg","","31974","33365","","10","0","1","2024-12-09 13:00:09",NULL,NULL,NULL,NULL,NULL,"19828","0"),
("1437","4415","media","medium_large","ABSPATHwp-content/uploads/2024/12/2148620011-768x487.jpg","","125382","129313","","10","0","1","2024-12-09 13:00:09",NULL,NULL,NULL,NULL,NULL,"68914","0"),
("1438","4415","media","woocommerce_thumbnail","ABSPATHwp-content/uploads/2024/12/2148620011-300x300.jpg","","41432","43028","","10","0","1","2024-12-09 13:00:10",NULL,NULL,NULL,NULL,NULL,"24966","0"),
("1439","4415","media","woocommerce_single","ABSPATHwp-content/uploads/2024/12/2148620011-600x380.jpg","","95604","99222","","10","0","1","2024-12-09 13:00:10",NULL,NULL,NULL,NULL,NULL,"56750","0"),
("1440","4415","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/2024/12/2148620011-100x100.jpg","","8106","8584","","10","0","1","2024-12-09 13:00:10",NULL,NULL,NULL,NULL,NULL,"5026","0"),
("1441","4415","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/2024/12/2148620011-1x1.jpg","","286","760","","10","0","1","2024-12-09 13:00:10",NULL,NULL,NULL,NULL,NULL,"56","0"),
("1442","4415","media","etheme-nimi","ABSPATHwp-content/uploads/2024/12/2148620011-10x6.jpg","","456","930","","10","0","1","2024-12-09 13:00:10",NULL,NULL,NULL,NULL,NULL,"196","0"),
("1443","4424","media","full","ABSPATHwp-content/uploads/xstore/xstore-placeholder.png","","270","270","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"102","0"),
("1444","4424","media","medium","ABSPATHwp-content/uploads/xstore/xstore-placeholder-500x500.png","","125","337","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"54","0"),
("1445","4424","media","thumbnail","ABSPATHwp-content/uploads/xstore/xstore-placeholder-300x300.png","","106","181","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"46","0"),
("1446","4424","media","medium_large","ABSPATHwp-content/uploads/xstore/xstore-placeholder-768x768.png","","167","667","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"68","0"),
("1447","4424","media","woocommerce_single","ABSPATHwp-content/uploads/xstore/xstore-placeholder-600x600.png","","139","444","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"58","0"),
("1448","4424","media","woocommerce_gallery_thumbnail","ABSPATHwp-content/uploads/xstore/xstore-placeholder-100x100.png","","91","105","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"44","0"),
("1449","4424","media","etheme-woocommerce-nimi","ABSPATHwp-content/uploads/xstore/xstore-placeholder-1x1.png","","82","82","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1450","4424","media","etheme-nimi","ABSPATHwp-content/uploads/xstore/xstore-placeholder-10x10.png","","82","84","","10","0","1","2024-12-09 13:05:26",NULL,NULL,NULL,NULL,NULL,"38","0"),
("1451","4431","media","full","ABSPATHwp-content/uploads/woocommerce-placeholder.jpg","ABSPATHwp-content/uploads/woocommerce-placeholder.png","35148","48149","","10","0","1","2024-12-18 11:24:49",NULL,NULL,NULL,NULL,NULL,"9494","0"),
("1452","4431","media","medium","ABSPATHwp-content/uploads/woocommerce-placeholder-500x500.jpg","ABSPATHwp-content/uploads/woocommerce-placeholder-500x500.png","10090","10091","","10","0","1","2024-12-18 11:24:50",NULL,NULL,NULL,NULL,NULL,"2622","0"),
("1453","4431","media","thumbnail","ABSPATHwp-content/uploads/woocommerce-placeholder-300x300.jpg","ABSPATHwp-content/uploads/woocommerce-placeholder-300x300.png","4500","4502","","10","0","1","2024-12-18 11:24:50",NULL,NULL,NULL,NULL,NULL,"1224","0"),
("1454","4431","media","medium_large","ABSPATHwp-content/uploads/woocommerce-placeholder-768x768.jpg","ABSPATHwp-content/uploads/woocommerce-placeholder-768x768.png","19082","19852","","10","0","1","2024-12-18 11:24:50",NULL,NULL,NULL,NULL,NULL,"4620","0");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse","yes"),
("2","home","https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse","yes"),
("3","blogname","Realizare Magazin Online La Cheie Cosmetice Diverse - Model","yes"),
("4","blogdescription","","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","demo@depozitul-de-magazine.ro","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","j F Y","yes"),
("24","time_format","G:i","yes"),
("25","links_updated_date_format","j F Y G:i","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:311:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:15:\"locations\\.kml$\";s:27:\"index.php?sitemap=locations\";s:10:\"magazin/?$\";s:27:\"index.php?post_type=product\";s:40:\"magazin/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:35:\"magazin/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:27:\"magazin/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:32:\"category/(.+?)/schema-preview/?$\";s:57:\"index.php?category=$matches[1]&schema-preview=$matches[3]\";s:27:\"tag/(.+?)/schema-preview/?$\";s:57:\"index.php?post_tag=$matches[1]&schema-preview=$matches[3]\";s:28:\"type/(.+?)/schema-preview/?$\";s:60:\"index.php?post_format=$matches[1]&schema-preview=$matches[3]\";s:42:\"portfolio-category/(.+?)/schema-preview/?$\";s:67:\"index.php?portfolio_category=$matches[1]&schema-preview=$matches[3]\";s:37:\"magazin/brand/(.+?)/schema-preview/?$\";s:54:\"index.php?brand=$matches[1]&schema-preview=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:51:\"e-landing-page/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?e-landing-page=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:48:\"e-landing-page/([^/]+)/schema-preview(/(.*))?/?$\";s:63:\"index.php?e-landing-page=$matches[1]&schema-preview=$matches[3]\";s:57:\"e-landing-page/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"e-landing-page/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:52:\"e-floating-buttons/([^/]+)/schema-preview(/(.*))?/?$\";s:67:\"index.php?e-floating-buttons=$matches[1]&schema-preview=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"etheme_mega_menus/([^/]+)/trackback/?$\";s:44:\"index.php?etheme_mega_menus=$matches[1]&tb=1\";s:46:\"etheme_mega_menus/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?etheme_mega_menus=$matches[1]&paged=$matches[2]\";s:53:\"etheme_mega_menus/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?etheme_mega_menus=$matches[1]&cpage=$matches[2]\";s:54:\"etheme_mega_menus/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?etheme_mega_menus=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"etheme_mega_menus/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?etheme_mega_menus=$matches[1]&wc-api=$matches[3]\";s:51:\"etheme_mega_menus/([^/]+)/schema-preview(/(.*))?/?$\";s:66:\"index.php?etheme_mega_menus=$matches[1]&schema-preview=$matches[3]\";s:60:\"etheme_mega_menus/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:71:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:49:\"etheme_mega_menus/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"etheme_mega_menus/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"etheme_mega_menus/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?etheme_mega_menus=$matches[1]&page=$matches[2]\";s:34:\"etheme_mega_menus/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"etheme_mega_menus/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"etheme_mega_menus/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"etheme_mega_menus/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"etheme_mega_menus/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"etheme_slides/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"etheme_slides/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"etheme_slides/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"etheme_slides/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"etheme_slides/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"etheme_slides/([^/]+)/trackback/?$\";s:40:\"index.php?etheme_slides=$matches[1]&tb=1\";s:42:\"etheme_slides/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?etheme_slides=$matches[1]&paged=$matches[2]\";s:49:\"etheme_slides/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?etheme_slides=$matches[1]&cpage=$matches[2]\";s:50:\"etheme_slides/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?etheme_slides=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"etheme_slides/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?etheme_slides=$matches[1]&wc-api=$matches[3]\";s:47:\"etheme_slides/([^/]+)/schema-preview(/(.*))?/?$\";s:62:\"index.php?etheme_slides=$matches[1]&schema-preview=$matches[3]\";s:56:\"etheme_slides/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"etheme_slides/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"etheme_slides/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"etheme_slides/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"etheme_slides/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?etheme_slides=$matches[1]&page=$matches[2]\";s:30:\"etheme_slides/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"etheme_slides/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"etheme_slides/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"etheme_slides/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"etheme_slides/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"staticblocks/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"staticblocks/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"staticblocks/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"staticblocks/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"staticblocks/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"staticblocks/([^/]+)/trackback/?$\";s:39:\"index.php?staticblocks=$matches[1]&tb=1\";s:41:\"staticblocks/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?staticblocks=$matches[1]&paged=$matches[2]\";s:48:\"staticblocks/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?staticblocks=$matches[1]&cpage=$matches[2]\";s:49:\"staticblocks/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?staticblocks=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"staticblocks/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?staticblocks=$matches[1]&wc-api=$matches[3]\";s:46:\"staticblocks/([^/]+)/schema-preview(/(.*))?/?$\";s:61:\"index.php?staticblocks=$matches[1]&schema-preview=$matches[3]\";s:55:\"staticblocks/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"staticblocks/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"staticblocks/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"staticblocks/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"staticblocks/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?staticblocks=$matches[1]&page=$matches[2]\";s:29:\"staticblocks/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"staticblocks/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"staticblocks/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"staticblocks/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"staticblocks/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"project/([^/]+)/trackback/?$\";s:43:\"index.php?etheme_portfolio=$matches[1]&tb=1\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?etheme_portfolio=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?etheme_portfolio=$matches[1]&cpage=$matches[2]\";s:44:\"project/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?etheme_portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"project/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?etheme_portfolio=$matches[1]&wc-api=$matches[3]\";s:41:\"project/([^/]+)/schema-preview(/(.*))?/?$\";s:65:\"index.php?etheme_portfolio=$matches[1]&schema-preview=$matches[3]\";s:50:\"project/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"project/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"project/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"project/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?etheme_portfolio=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"magazin/brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?brand=$matches[1]&feed=$matches[2]\";s:49:\"magazin/brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?brand=$matches[1]&feed=$matches[2]\";s:42:\"magazin/brand/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?brand=$matches[1]&paged=$matches[2]\";s:24:\"magazin/brand/([^/]+)/?$\";s:27:\"index.php?brand=$matches[1]\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"categorie-produs/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"categorie-produs/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:43:\"categorie-produs/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"categorie-produs/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:56:\"eticheta-produs/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:51:\"eticheta-produs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:44:\"eticheta-produs/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:26:\"eticheta-produs/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:34:\"produs/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"produs/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"produs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"produs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"produs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"produs/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:47:\"produs/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:42:\"produs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:35:\"produs/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:42:\"produs/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:43:\"produs/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"produs/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:40:\"produs/([^/]+)/schema-preview(/(.*))?/?$\";s:56:\"index.php?product=$matches[1]&schema-preview=$matches[3]\";s:49:\"produs/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"produs/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"produs/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"produs/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"produs/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:23:\"produs/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"produs/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"produs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"produs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"produs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3899&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:25:\"schema-preview(/(.*))?/?$\";s:37:\"index.php?&schema-preview=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:33:\"(.?.+?)/schema-preview(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&schema-preview=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:33:\"([^/]+)/schema-preview(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&schema-preview=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:23:{i:0;s:19:\"akismet/akismet.php\";i:1;s:44:\"click-to-chat-for-whatsapp/click-to-chat.php\";i:2;s:31:\"cookie-notice/cookie-notice.php\";i:3;s:47:\"disable-admin-notices/disable-admin-notices.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:32:\"elementor-pro-activator/main.php\";i:7;s:31:\"elementor-pro/elementor-pro.php\";i:8;s:23:\"elementor/elementor.php\";i:9;s:33:\"et-core-plugin/et-core-plugin.php\";i:10;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:11;s:23:\"loco-translate/loco.php\";i:12;s:43:\"noindex-except-home/noindex-except-home.php\";i:13;s:27:\"perfmatters/perfmatters.php\";i:14;s:23:\"revslider/revslider.php\";i:15;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:16;s:30:\"seo-by-rank-math/rank-math.php\";i:17;s:46:\"under-construction-page/under-construction.php\";i:18;s:37:\"user-role-editor/user-role-editor.php\";i:19;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";i:20;s:27:\"woocommerce/woocommerce.php\";i:21;s:23:\"wp-rocket/wp-rocket.php\";i:22;s:33:\"wps-hide-login/wps-hide-login.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","2","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","xstore","yes"),
("41","stylesheet","xstore-child","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","60421","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","1","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","300","yes"),
("57","thumbnail_size_h","300","yes"),
("58","thumbnail_crop","0","yes"),
("59","medium_size_w","500","yes"),
("60","medium_size_h","500","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1200","yes"),
("63","large_size_h","1200","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("79","uninstall_plugins","a:5:{s:27:\"perfmatters/perfmatters.php\";s:21:\"perfmatters_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:44:\"click-to-chat-for-whatsapp/click-to-chat.php\";a:2:{i:0;s:15:\"HT_CTC_Register\";i:1;s:9:\"uninstall\";}s:46:\"under-construction-page/under-construction.php\";a:2:{i:0;s:3:\"UCP\";i:1;s:9:\"uninstall\";}s:37:\"user-role-editor/user-role-editor.php\";a:2:{i:0;s:16:\"User_Role_Editor\";i:1;s:9:\"uninstall\";}}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","3900","yes"),
("82","page_on_front","3899","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","4396","on"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1777469619","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:1:{s:27:\"perfmatters/perfmatters.php\";s:5:\"2.5.2\";}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","off"),
("99","wp_attachment_pages_enabled","0","yes"),
("100","initial_db_version","56657","yes"),
("101","wp_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:166:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:10:\"loco_admin\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:106:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:16:\"create_customers\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}","yes"),
("102","fresh_site","0","off"),
("103","WPLANG","ro_RO","yes"),
("104","user_count","2","off"),
("107","cron","a:38:{i:1761919479;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1761919843;a:1:{s:25:\"ewww_image_optimizer_auto\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761920595;a:1:{s:46:\"facebook_for_woocommerce_hourly_heartbeat_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761921128;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761921757;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761922162;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761922240;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761922282;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761924920;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"77ea69430d1a7c6b4246b9b411d4f817\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4447;}}}}i:1761925141;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"f86fbf898f1fc7bc47fdf4479e76d03c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4449;}}}}i:1761925279;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"4bc1ac9fbacc37c3bc6b6bef00d25d6c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4450;}}}}i:1761925325;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"d8a115b996d97d1c9304d01c74b83e1f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4451;}}}}i:1761939782;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761942738;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761943762;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761943794;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761943795;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761943839;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761943840;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761945474;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761948000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761950989;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761953528;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761955200;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761958857;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761960660;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761986520;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761995013;a:1:{s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761996195;a:1:{s:45:\"facebook_for_woocommerce_daily_heartbeat_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761996383;a:1:{s:26:\"wacv_remove_abandoned_cart\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762171200;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762364759;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762375764;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762377924;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762378524;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762462162;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762893188;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}","on"),
("124","theme_mods_twentytwentyfour","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1704920011;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","no"),
("125","recovery_keys","a:0:{}","off"),
("162","action_scheduler_hybrid_store_demarkation","6","yes"),
("163","schema-ActionScheduler_StoreSchema","8.0.1755037511","yes"),
("164","schema-ActionScheduler_LoggerSchema","3.0.1704919839","yes"),
("167","woocommerce_newly_installed","no","yes"),
("168","woocommerce_schema_version","920","yes"),
("169","woocommerce_store_address","Bucuresti","on"),
("170","woocommerce_store_address_2","","on"),
("171","woocommerce_store_city","Bucuresti","on"),
("172","woocommerce_default_country","RO:B","on"),
("173","woocommerce_store_postcode","","on"),
("174","woocommerce_allowed_countries","all","yes"),
("175","woocommerce_all_except_countries","a:0:{}","yes"),
("176","woocommerce_specific_allowed_countries","a:0:{}","yes"),
("177","woocommerce_ship_to_countries","","yes"),
("178","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("179","woocommerce_default_customer_address","base","yes"),
("180","woocommerce_calc_taxes","no","yes"),
("181","woocommerce_enable_coupons","yes","yes"),
("182","woocommerce_calc_discounts_sequentially","no","no"),
("183","woocommerce_currency","RON","on"),
("184","woocommerce_currency_pos","left","on"),
("185","woocommerce_price_thousand_sep",",","yes"),
("186","woocommerce_price_decimal_sep",".","yes"),
("187","woocommerce_price_num_decimals","2","on"),
("188","woocommerce_shop_page_id","4","yes"),
("189","woocommerce_cart_redirect_after_add","no","yes"),
("190","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("191","woocommerce_placeholder_image","4431","yes"),
("192","woocommerce_weight_unit","kg","yes"),
("193","woocommerce_dimension_unit","cm","yes"),
("194","woocommerce_enable_reviews","yes","yes"),
("195","woocommerce_review_rating_verification_label","yes","no"),
("196","woocommerce_review_rating_verification_required","no","no"),
("197","woocommerce_enable_review_rating","yes","yes"),
("198","woocommerce_review_rating_required","yes","no"),
("199","woocommerce_manage_stock","yes","yes"),
("200","woocommerce_hold_stock_minutes","60","off"),
("201","woocommerce_notify_low_stock","yes","no"),
("202","woocommerce_notify_no_stock","yes","no"),
("203","woocommerce_stock_email_recipient","demo@depozitul-de-magazine.ro","off"),
("204","woocommerce_notify_low_stock_amount","2","no"),
("205","woocommerce_notify_no_stock_amount","0","on"),
("206","woocommerce_hide_out_of_stock_items","no","yes"),
("207","woocommerce_stock_format","","yes"),
("208","woocommerce_file_download_method","force","no"),
("209","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("210","woocommerce_downloads_require_login","no","no"),
("211","woocommerce_downloads_grant_access_after_payment","yes","no"),
("212","woocommerce_downloads_deliver_inline","","no"),
("213","woocommerce_downloads_add_hash_to_filename","yes","yes"),
("215","woocommerce_attribute_lookup_direct_updates","no","yes"),
("216","woocommerce_prices_include_tax","no","yes"),
("217","woocommerce_tax_based_on","shipping","yes"),
("218","woocommerce_shipping_tax_class","inherit","yes"),
("219","woocommerce_tax_round_at_subtotal","no","yes"),
("220","woocommerce_tax_classes","","yes"),
("221","woocommerce_tax_display_shop","excl","yes"),
("222","woocommerce_tax_display_cart","excl","yes"),
("223","woocommerce_price_display_suffix","","yes"),
("224","woocommerce_tax_total_display","itemized","no"),
("225","woocommerce_enable_shipping_calc","yes","no"),
("226","woocommerce_shipping_cost_requires_address","no","yes"),
("227","woocommerce_ship_to_destination","billing","no"),
("228","woocommerce_shipping_debug_mode","no","yes"),
("229","woocommerce_enable_guest_checkout","yes","no"),
("230","woocommerce_enable_checkout_login_reminder","yes","no"),
("231","woocommerce_enable_signup_and_login_from_checkout","yes","no"),
("232","woocommerce_enable_myaccount_registration","yes","no"),
("233","woocommerce_registration_generate_username","no","no"),
("234","woocommerce_registration_generate_password","no","no"),
("235","woocommerce_erasure_request_removes_order_data","no","no"),
("236","woocommerce_erasure_request_removes_download_data","no","no"),
("237","woocommerce_allow_bulk_remove_personal_data","no","no"),
("238","woocommerce_registration_privacy_policy_text","Datele cu caracter personal vor fi utilizate pentru a sprijini experiența dumneavoastră pe acest site, pentru a administra accesul la contul dumneavoastră și pentru alte scopuri descrise în [privacy_policy].","on"),
("239","woocommerce_checkout_privacy_policy_text","Datele cu caracter personal vor fi utilizate pentru a procesa comanda dvs., pentru a vă sprijini experiența pe acest site și pentru alte scopuri descrise în [privacy_policy].","on"),
("240","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("241","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("242","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("243","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("244","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("245","woocommerce_email_from_name","La Cheie - Depozitul de Magazine","off"),
("246","woocommerce_email_from_address","demo@depozitul-de-magazine.ro","off"),
("247","woocommerce_email_header_image","","no"),
("248","woocommerce_email_footer_text","{site_title} &mdash; Built by <a href=\"https://depozitul-de-magazine.ro/\" target=\"_blank\">Depozitul de Magazine</a>","off"),
("249","woocommerce_email_base_color","#720eec","no"),
("250","woocommerce_email_background_color","#f7f7f7","no"),
("251","woocommerce_email_body_background_color","#ffffff","no"),
("252","woocommerce_email_text_color","#3c3c3c","no"),
("253","woocommerce_merchant_email_notifications","no","no"),
("254","woocommerce_cart_page_id","5","no"),
("255","woocommerce_checkout_page_id","6","no"),
("256","woocommerce_myaccount_page_id","3898","no"),
("257","woocommerce_terms_page_id","4119","on"),
("258","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("259","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("260","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("261","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("262","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("263","woocommerce_myaccount_orders_endpoint","orders","yes"),
("264","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("265","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("266","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("267","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("268","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("269","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("270","woocommerce_logout_endpoint","customer-logout","yes"),
("271","woocommerce_api_enabled","no","yes"),
("272","woocommerce_allow_tracking","yes","on"),
("273","woocommerce_show_marketplace_suggestions","yes","no"),
("274","woocommerce_custom_orders_table_enabled","yes","yes"),
("275","woocommerce_analytics_enabled","yes","yes"),
("276","woocommerce_navigation_enabled","no","yes"),
("277","woocommerce_feature_marketplace_enabled","yes","yes"),
("278","woocommerce_feature_product_block_editor_enabled","no","yes"),
("279","woocommerce_single_image_width","600","yes"),
("280","woocommerce_thumbnail_image_width","300","yes"),
("281","woocommerce_checkout_highlight_required_fields","yes","yes"),
("282","woocommerce_demo_store","no","no"),
("283","wc_downloads_approved_directories_mode","enabled","yes"),
("284","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:7:\"/produs\";s:13:\"category_base\";s:16:\"categorie-produs\";s:8:\"tag_base\";s:15:\"eticheta-produs\";s:14:\"attribute_base\";s:7:\"atribut\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("285","current_theme_supports_woocommerce","yes","yes"),
("286","woocommerce_queue_flush_rewrite_rules","no","yes"),
("289","default_product_cat","119","yes"),
("291","woocommerce_refund_returns_page_id","4017","yes"),
("294","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:92:\"Plătește prin PayPal; nu poți plăti cu cardul tău de credit dacă nu ai un cont PayPal.\";s:5:\"email\";s:29:\"demo@depozitul-de-magazine.ro\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:29:\"demo@depozitul-de-magazine.ro\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}","yes"),
("295","woocommerce_version","10.3.3","yes"),
("296","woocommerce_db_version","10.3.3","yes"),
("297","woocommerce_store_id","fb49185a-063b-4883-9184-42973cf4eeff","yes"),
("298","woocommerce_admin_install_timestamp","1704919839","yes"),
("299","woocommerce_inbox_variant_assignment","5","yes"),
("303","recently_activated","a:0:{}","off"),
("305","action_scheduler_lock_async-request-runner","6904c1da694b65.68023098|1761919510","no"),
("306","woocommerce_admin_notices","a:1:{i:0;s:14:\"template_files\";}","yes"),
("307","wc_blocks_version","11.8.0-dev","yes"),
("308","jetpack_connection_active_plugins","a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}","yes"),
("309","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"2nIbig0pIW62Hci6Lb6SILvxeebCEVD8\";}","yes"),
("326","has_migrated_cart","success","yes"),
("327","has_migrated_checkout","success","yes"),
("335","wcpay_was_in_use","no","yes"),
("338","wc_admin_show_legacy_coupon_menu","0","yes"),
("341","woocommerce_custom_orders_table_created","yes","yes"),
("346","wc_blocks_db_schema_version","260","yes"),
("347","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}","no"),
("350","jetpack_options","a:12:{s:14:\"last_heartbeat\";i:1761825105;s:7:\"version\";s:17:\"13.9.1:1729759061\";s:11:\"old_version\";s:17:\"13.9.1:1729759061\";s:27:\"historically_active_modules\";a:5:{i:0;s:9:\"anti-spam\";i:1;s:7:\"creator\";i:2;s:6:\"extras\";i:3;s:10:\"jetpack-ai\";i:4;s:5:\"stats\";}s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:238340550;s:6:\"public\";i:1;s:11:\"master_user\";i:2;s:16:\"first_admin_view\";b:1;s:28:\"has_seen_wc_connection_modal\";b:1;s:27:\"recommendations_conditional\";a:1:{i:0;s:11:\"backup-plan\";}}","yes"),
("369","finished_updating_comment_type","1","yes"),
("373","woocommerce_task_list_tracked_completed_actions","a:1:{i:0;s:10:\"appearance\";}","yes"),
("384","current_theme","XStore Child","yes"),
("385","theme_mods_betheme-child","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:9:\"main-menu\";i:2;s:9:\"lang-menu\";i:0;s:11:\"social-menu\";i:110;s:18:\"social-menu-bottom\";i:118;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1707167665;s:4:\"data\";a:5:{s:13:\"footer-area-1\";a:2:{i:0;s:8:\"block-40\";i:1;s:8:\"block-50\";}s:13:\"footer-area-2\";a:3:{i:0;s:8:\"block-41\";i:1;s:8:\"block-42\";i:2;s:8:\"block-47\";}s:13:\"footer-area-3\";a:2:{i:0;s:8:\"block-44\";i:1;s:8:\"block-43\";}s:13:\"footer-area-4\";a:2:{i:0;s:8:\"block-45\";i:1;s:8:\"block-46\";}s:4:\"shop\";a:6:{i:0;s:8:\"block-49\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:27:\"widget_mfn_woo_attributes-3\";i:3;s:27:\"widget_mfn_woo_attributes-2\";i:4;s:27:\"widget_mfn_woo_attributes-4\";i:5;s:27:\"widget_mfn_woo_attributes-5\";}}}}","no"),
("386","theme_switched","","yes"),
("390","betheme_promo","<li>\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/sidebar-menu-builder/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/271.png\" alt=\"Sidebar Menu Builder\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/speed-performance/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/27.1.png\" alt=\"Performance update\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/speed-performance/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/27.2.png\" alt=\"Performance update\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/speed-performance/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/27.3.png\" alt=\"Performance update\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/popup-builder/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/26.8.jpg\" alt=\"Popup Builder\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://muffingroup.com/betheme/loop-builder/?utm_source=betheme-dashboard&amp;utm_medium=banner&amp;utm_campaign=bebuilder\">\n    <img src=\"https://api.muffingroup.com/promo/images/26.7.jpg\" alt=\"Loop Builder\">\n  </a>\n</li>\n<li style=\"display:none;\">\n  <a target=\"_blank\" href=\"https://www.facebook.com/groups/betheme/\">\n    <img src=\"https://api.muffingroup.com/promo/images/join-fb-community.jpg\" alt=\"Join FB Community\">\n  </a>\n</li>\n","no"),
("403","betheme","a:483:{s:8:\"last_tab\";s:9:\"font-size\";s:6:\"layout\";s:10:\"full-width\";s:10:\"grid-width\";s:4:\"1140\";s:5:\"style\";s:6:\"simple\";s:17:\"image-frame-style\";s:4:\"zoom\";s:18:\"image-frame-border\";s:0:\"\";s:19:\"image-frame-caption\";s:0:\"\";s:11:\"img-page-bg\";s:0:\"\";s:16:\"position-page-bg\";s:20:\"no-repeat;left top;;\";s:12:\"size-page-bg\";s:4:\"auto\";s:11:\"transparent\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:11:\"favicon-img\";s:0:\"\";s:16:\"apple-touch-icon\";s:0:\"\";s:8:\"logo-img\";s:105:\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-content/uploads/2021/08/clothingstore.webp\";s:15:\"retina-logo-img\";s:112:\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-content/uploads/2021/08/retina-clothingstore.webp\";s:15:\"sticky-logo-img\";s:0:\"\";s:22:\"sticky-retina-logo-img\";s:0:\"\";s:9:\"logo-link\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:4:\"link\";s:4:\"link\";}s:9:\"logo-text\";s:0:\"\";s:10:\"logo-width\";s:0:\"\";s:11:\"logo-height\";s:0:\"\";s:21:\"logo-vertical-padding\";s:0:\"\";s:19:\"logo-vertical-align\";s:0:\"\";s:13:\"logo-advanced\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:9:\"no-margin\";s:9:\"no-margin\";}s:12:\"button-style\";s:6:\"custom\";s:12:\"color-button\";s:7:\"#747474\";s:17:\"background-button\";s:7:\"#f7f7f7\";s:18:\"color-button-theme\";s:7:\"#ffffff\";s:19:\"color-action-button\";s:7:\"#ffffff\";s:24:\"background-action-button\";s:7:\"#0089f7\";s:18:\"button-font-family\";s:7:\"Poppins\";s:11:\"button-font\";a:3:{s:4:\"size\";s:2:\"16\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:14:\"button-padding\";a:5:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"25\";s:8:\"isLinked\";s:1:\"0\";}s:19:\"button-border-width\";s:0:\"\";s:20:\"button-border-radius\";s:1:\"0\";s:12:\"button-color\";a:2:{s:6:\"normal\";s:7:\"#8d2629\";s:5:\"hover\";s:7:\"#8d2629\";}s:17:\"button-background\";a:2:{s:6:\"normal\";s:7:\"#dc91a3\";s:5:\"hover\";s:7:\"#d67f93\";}s:19:\"button-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:24:\"button-highlighted-color\";a:2:{s:6:\"normal\";s:7:\"#ffffff\";s:5:\"hover\";s:7:\"#ffffff\";}s:29:\"button-highlighted-background\";a:2:{s:6:\"normal\";s:7:\"#000000\";s:5:\"hover\";s:7:\"#6d6d6d\";}s:31:\"button-highlighted-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:19:\"button-action-color\";a:2:{s:6:\"normal\";s:7:\"#626262\";s:5:\"hover\";s:7:\"#626262\";}s:24:\"button-action-background\";a:2:{s:6:\"normal\";s:7:\"#dbdddf\";s:5:\"hover\";s:7:\"#d3d3d3\";}s:26:\"button-action-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:19:\"slider-blog-timeout\";s:1:\"0\";s:22:\"slider-clients-timeout\";s:1:\"0\";s:20:\"slider-offer-timeout\";s:1:\"0\";s:24:\"slider-portfolio-timeout\";s:1:\"0\";s:19:\"slider-shop-timeout\";s:1:\"0\";s:21:\"slider-slider-timeout\";s:1:\"0\";s:27:\"slider-testimonials-timeout\";s:1:\"0\";s:20:\"layout-boxed-padding\";s:0:\"\";s:18:\"builder-visibility\";s:0:\"\";s:13:\"display-order\";s:1:\"0\";s:22:\"content-remove-padding\";s:1:\"0\";s:8:\"no-hover\";s:0:\"\";s:19:\"google-maps-api-key\";s:0:\"\";s:11:\"table-hover\";s:0:\"\";s:23:\"math-animations-disable\";s:1:\"0\";s:14:\"layout-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:17:\"post-type-disable\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"theme-disable\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:10:\"static-css\";s:1:\"0\";s:15:\"builder-storage\";s:6:\"encode\";s:16:\"slider-shortcode\";s:0:\"\";s:12:\"table_prefix\";s:11:\"base_prefix\";s:8:\"hook-top\";s:0:\"\";s:19:\"hook-content-before\";s:0:\"\";s:18:\"hook-content-after\";s:0:\"\";s:11:\"hook-bottom\";s:0:\"\";s:12:\"header-style\";s:10:\"stack,left\";s:9:\"header-fw\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-height\";s:1:\"0\";s:16:\"img-subheader-bg\";s:0:\"\";s:24:\"img-subheader-attachment\";s:20:\"no-repeat;left top;;\";s:17:\"size-subheader-bg\";s:4:\"auto\";s:14:\"top-bar-bg-img\";s:0:\"\";s:19:\"top-bar-bg-position\";s:20:\"no-repeat;left top;;\";s:13:\"sticky-header\";s:1:\"1\";s:19:\"sticky-header-style\";s:5:\"white\";s:15:\"subheader-style\";s:11:\"both-center\";s:9:\"subheader\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:17:\"subheader-padding\";s:11:\"60px 0 45px\";s:19:\"subheader-title-tag\";s:2:\"h1\";s:15:\"subheader-image\";s:0:\"\";s:18:\"subheader-position\";s:20:\"no-repeat;left top;;\";s:14:\"subheader-size\";s:4:\"auto\";s:21:\"subheader-transparent\";s:3:\"100\";s:18:\"subheader-advanced\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:18:\"top-bar-right-hide\";s:1:\"0\";s:19:\"header-action-title\";s:0:\"\";s:18:\"header-action-link\";s:0:\"\";s:20:\"header-action-target\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-search\";s:4:\"shop\";s:11:\"header-wpml\";s:0:\"\";s:19:\"header-wpml-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-banner\";s:0:\"\";s:11:\"sliding-top\";s:1:\"0\";s:16:\"sliding-top-icon\";s:14:\"fab fa-cc-visa\";s:10:\"menu-style\";s:10:\"line-below\";s:12:\"menu-options\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:12:\"hide-borders\";s:12:\"hide-borders\";}s:21:\"menu-creative-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:15:\"menu-mega-style\";s:0:\"\";s:10:\"action-bar\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:4:\"show\";s:4:\"show\";}s:13:\"header-slogan\";s:65:\"<b>Hot Summer sale  —  Get 50% Off  —  Ends on 10/18/2022</b>\";s:12:\"header-phone\";s:0:\"\";s:14:\"header-phone-2\";s:0:\"\";s:12:\"header-email\";s:0:\"\";s:14:\"sidebar-sticky\";s:1:\"0\";s:13:\"sidebar-width\";s:2:\"25\";s:13:\"sidebar-lines\";s:12:\"lines-hidden\";s:18:\"single-page-layout\";s:0:\"\";s:19:\"single-page-sidebar\";s:0:\"\";s:20:\"single-page-sidebar2\";s:0:\"\";s:13:\"single-layout\";s:0:\"\";s:14:\"single-sidebar\";s:0:\"\";s:15:\"single-sidebar2\";s:0:\"\";s:23:\"single-portfolio-layout\";s:0:\"\";s:24:\"single-portfolio-sidebar\";s:0:\"\";s:25:\"single-portfolio-sidebar2\";s:0:\"\";s:13:\"search-layout\";s:10:\"no-sidebar\";s:13:\"prev-next-nav\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:15:\"prev-next-style\";s:7:\"minimal\";s:22:\"prev-next-sticky-style\";s:0:\"\";s:5:\"share\";s:1:\"1\";s:11:\"share-style\";s:6:\"simple\";s:19:\"pagination-show-all\";s:1:\"1\";s:4:\"love\";s:1:\"1\";s:22:\"featured-image-caption\";s:0:\"\";s:13:\"related-style\";s:6:\"simple\";s:13:\"title-heading\";s:1:\"1\";s:10:\"blog-posts\";s:1:\"2\";s:11:\"blog-layout\";s:6:\"photo2\";s:12:\"blog-columns\";s:1:\"2\";s:14:\"blog-title-tag\";s:1:\"4\";s:11:\"blog-images\";s:0:\"\";s:15:\"blog-full-width\";s:1:\"0\";s:9:\"blog-page\";s:3:\"135\";s:12:\"blog-orderby\";s:4:\"date\";s:10:\"blog-order\";s:4:\"DESC\";s:16:\"exclude-category\";s:0:\"\";s:14:\"excerpt-length\";s:2:\"26\";s:9:\"blog-meta\";a:3:{s:9:\"post-meta\";s:1:\"1\";s:6:\"author\";s:6:\"author\";s:4:\"date\";s:4:\"date\";}s:14:\"blog-load-more\";s:1:\"0\";s:20:\"blog-infinite-scroll\";s:1:\"1\";s:12:\"blog-filters\";s:1:\"1\";s:12:\"blog-isotope\";s:1:\"0\";s:10:\"blog-title\";s:1:\"0\";s:11:\"blog-author\";s:1:\"1\";s:13:\"blog-comments\";s:1:\"1\";s:16:\"blog-single-zoom\";s:1:\"1\";s:18:\"blog-single-layout\";s:0:\"\";s:16:\"blog-single-menu\";s:1:\"0\";s:12:\"blog-related\";s:1:\"3\";s:20:\"blog-related-columns\";s:1:\"3\";s:19:\"blog-related-images\";s:0:\"\";s:20:\"single-intro-padding\";s:12:\"100px 0 85px\";s:15:\"portfolio-posts\";s:1:\"9\";s:16:\"portfolio-layout\";s:4:\"grid\";s:17:\"portfolio-columns\";s:1:\"3\";s:20:\"portfolio-full-width\";s:1:\"0\";s:14:\"portfolio-page\";s:0:\"\";s:17:\"portfolio-orderby\";s:4:\"date\";s:15:\"portfolio-order\";s:4:\"DESC\";s:18:\"portfolio-external\";s:0:\"\";s:21:\"portfolio-hover-title\";s:1:\"0\";s:14:\"portfolio-meta\";a:4:{s:9:\"post-meta\";s:1:\"1\";s:6:\"author\";s:6:\"author\";s:4:\"date\";s:4:\"date\";s:10:\"categories\";s:10:\"categories\";}s:19:\"portfolio-load-more\";s:1:\"0\";s:25:\"portfolio-infinite-scroll\";s:1:\"0\";s:17:\"portfolio-filters\";s:1:\"1\";s:17:\"portfolio-isotope\";s:1:\"1\";s:22:\"portfolio-single-title\";s:1:\"0\";s:17:\"portfolio-related\";s:1:\"3\";s:25:\"portfolio-related-columns\";s:1:\"3\";s:18:\"portfolio-comments\";s:1:\"0\";s:23:\"portfolio-single-layout\";s:0:\"\";s:21:\"portfolio-single-menu\";s:1:\"0\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:13:\"portfolio-tax\";s:15:\"portfolio-types\";s:13:\"shop-template\";s:0:\"\";s:13:\"shop-products\";s:2:\"27\";s:11:\"shop-layout\";s:4:\"grid\";s:14:\"shop-catalogue\";s:1:\"0\";s:11:\"shop-images\";s:9:\"secondary\";s:14:\"shop-title-tag\";s:2:\"h6\";s:10:\"shop-align\";s:4:\"left\";s:11:\"shop-button\";s:1:\"0\";s:12:\"shop-excerpt\";s:1:\"0\";s:12:\"shop-sidebar\";s:4:\"shop\";s:11:\"shop-slider\";s:0:\"\";s:13:\"shop-sidecart\";s:1:\"1\";s:16:\"sale-badge-style\";s:7:\"percent\";s:12:\"shop-soldout\";s:8:\"Sold out\";s:18:\"shop-product-style\";s:7:\"default\";s:21:\"shop-product-template\";s:0:\"\";s:17:\"shop-single-image\";s:0:\"\";s:20:\"shop-product-gallery\";s:39:\"mfn-thumbnails-bottom mfn-bottom-center\";s:28:\"shop-product-gallery-overlay\";s:22:\"mfn-thumbnails-outside\";s:30:\"shop-product-main-image-margin\";s:10:\"mfn-mim-10\";s:30:\"shop-product-thumbnails-margin\";s:2:\"10\";s:18:\"shop-product-title\";s:0:\"\";s:12:\"shop-related\";s:1:\"3\";s:13:\"shop-wishlist\";s:1:\"1\";s:18:\"shop-wishlist-page\";s:3:\"185\";s:22:\"shop-wishlist-position\";s:1:\"1\";s:15:\"shop-icons-hide\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:9:\"shop-user\";s:0:\"\";s:18:\"shop-icon-wishlist\";s:0:\"\";s:9:\"shop-cart\";s:0:\"\";s:20:\"shop-cart-total-hide\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:29:\"featured-blog-portfolio-width\";s:3:\"960\";s:30:\"featured-blog-portfolio-height\";s:3:\"720\";s:28:\"featured-blog-portfolio-crop\";s:4:\"crop\";s:21:\"featured-single-width\";s:4:\"1200\";s:22:\"featured-single-height\";s:3:\"675\";s:20:\"featured-single-crop\";s:4:\"crop\";s:13:\"page-comments\";s:1:\"0\";s:13:\"error404-icon\";s:17:\"icon-traffic-cone\";s:13:\"error404-page\";s:0:\"\";s:12:\"construction\";s:1:\"0\";s:18:\"construction-title\";s:11:\"Coming Soon\";s:17:\"construction-text\";s:0:\"\";s:17:\"construction-date\";s:19:\"12/30/2018 12:00:00\";s:19:\"construction-offset\";s:1:\"0\";s:20:\"construction-contact\";s:0:\"\";s:17:\"construction-page\";s:0:\"\";s:13:\"footer-layout\";s:45:\"4;one-fourth;one-fourth;one-fourth;one-fourth\";s:12:\"footer-style\";s:0:\"\";s:14:\"footer-padding\";s:6:\"70px 0\";s:14:\"footer-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"footer-bg-img\";s:0:\"\";s:22:\"footer-bg-img-position\";s:20:\"no-repeat;left top;;\";s:18:\"footer-bg-img-size\";s:4:\"auto\";s:21:\"footer-call-to-action\";s:0:\"\";s:11:\"footer-copy\";s:0:\"\";s:11:\"footer-hide\";s:0:\"\";s:12:\"back-top-top\";s:0:\"\";s:18:\"popup-contact-form\";s:0:\"\";s:23:\"popup-contact-form-icon\";s:14:\"icon-mail-line\";s:10:\"responsive\";s:1:\"1\";s:17:\"mobile-grid-width\";s:3:\"480\";s:20:\"font-size-responsive\";s:1:\"1\";s:15:\"responsive-zoom\";s:1:\"0\";s:19:\"responsive-boxed2fw\";s:1:\"0\";s:13:\"no-section-bg\";s:0:\"\";s:19:\"responsive-parallax\";s:1:\"0\";s:23:\"builder-section-padding\";s:0:\"\";s:19:\"builder-wrap-moveup\";s:0:\"\";s:12:\"footer-align\";s:6:\"center\";s:19:\"responsive-logo-img\";s:112:\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-content/uploads/2021/08/clothingstore-mobile.webp\";s:26:\"responsive-retina-logo-img\";s:118:\"https://la-cheie.depozitul-de-magazine.ro/cosmetice-diverse/wp-content/uploads/2021/08/retina-clothingstore-mobile.png\";s:26:\"responsive-sticky-logo-img\";s:0:\"\";s:33:\"responsive-sticky-retina-logo-img\";s:0:\"\";s:24:\"responsive-header-tablet\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:6:\"sticky\";s:6:\"sticky\";}s:24:\"responsive-header-mobile\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:6:\"sticky\";s:6:\"sticky\";}s:20:\"mobile-header-height\";s:0:\"\";s:24:\"mobile-subheader-padding\";s:0:\"\";s:25:\"responsive-header-minimal\";s:5:\"mr-ll\";s:18:\"responsive-top-bar\";s:6:\"center\";s:19:\"mobile-menu-initial\";s:4:\"1240\";s:11:\"mobile-menu\";s:1:\"0\";s:22:\"responsive-mobile-menu\";s:10:\"side-slide\";s:27:\"responsive-side-slide-width\";s:3:\"250\";s:21:\"responsive-side-slide\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:16:\"header-menu-text\";s:0:\"\";s:25:\"header-menu-mobile-sticky\";s:1:\"0\";s:16:\"google-analytics\";s:0:\"\";s:14:\"facebook-pixel\";s:0:\"\";s:18:\"google-remarketing\";s:0:\"\";s:7:\"mfn-seo\";s:1:\"1\";s:16:\"meta-description\";s:27:\"Just another WordPress site\";s:13:\"meta-keywords\";s:0:\"\";s:16:\"mfn-seo-og-image\";s:0:\"\";s:13:\"seo-fb-app-id\";s:0:\"\";s:19:\"mfn-seo-schema-type\";s:1:\"1\";s:11:\"social-attr\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:12:\"social-skype\";s:0:\"\";s:15:\"social-whatsapp\";s:0:\"\";s:15:\"social-facebook\";s:0:\"\";s:14:\"social-twitter\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:13:\"social-flickr\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:16:\"social-pinterest\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:15:\"social-snapchat\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-tumblr\";s:0:\"\";s:18:\"social-tripadvisor\";s:0:\"\";s:16:\"social-vkontakte\";s:0:\"\";s:13:\"social-viadeo\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:18:\"social-custom-icon\";s:0:\"\";s:18:\"social-custom-link\";s:0:\"\";s:19:\"social-custom-title\";s:0:\"\";s:10:\"social-rss\";s:1:\"0\";s:9:\"cf7-error\";s:0:\"\";s:8:\"parallax\";s:11:\"translate3d\";s:19:\"prettyphoto-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:18:\"sc-gallery-disable\";s:1:\"0\";s:10:\"plugin-rev\";s:0:\"\";s:13:\"plugin-visual\";s:0:\"\";s:12:\"plugin-layer\";s:0:\"\";s:4:\"skin\";s:6:\"custom\";s:9:\"color-one\";s:7:\"#0095eb\";s:15:\"background-html\";s:7:\"#ffffff\";s:15:\"background-body\";s:7:\"#ffffff\";s:24:\"background-archives-post\";s:7:\"#ffffff\";s:29:\"background-archives-portfolio\";s:7:\"#ffffff\";s:27:\"background-archives-product\";s:0:\"\";s:17:\"background-header\";s:7:\"#ffffff\";s:19:\"background-top-left\";s:7:\"#ffffff\";s:21:\"background-top-middle\";s:7:\"#e3e3e3\";s:20:\"background-top-right\";s:7:\"#f5f5f5\";s:17:\"color-top-right-a\";s:7:\"#333333\";s:14:\"border-top-bar\";s:0:\"\";s:17:\"background-search\";s:7:\"#000000\";s:20:\"background-subheader\";s:7:\"#ffffff\";s:15:\"color-subheader\";s:7:\"#161922\";s:12:\"color-menu-a\";s:7:\"#2a2b39\";s:19:\"color-menu-a-active\";s:7:\"#000000\";s:24:\"background-menu-a-active\";s:7:\"#F2F2F2\";s:18:\"background-submenu\";s:7:\"#F2F2F2\";s:15:\"color-submenu-a\";s:7:\"#5f5f5f\";s:21:\"color-submenu-a-hover\";s:7:\"#2e2e2e\";s:26:\"color-menu-responsive-icon\";s:7:\"#000000\";s:31:\"background-menu-responsive-icon\";s:0:\"\";s:23:\"background-overlay-menu\";s:7:\"#000000\";s:25:\"background-overlay-menu-a\";s:7:\"#FFFFFF\";s:32:\"background-overlay-menu-a-active\";s:7:\"#B1DCFB\";s:17:\"border-menu-plain\";s:7:\"#f2f2f2\";s:20:\"background-side-menu\";s:7:\"#191919\";s:17:\"color-side-menu-a\";s:7:\"#A6A6A6\";s:23:\"color-side-menu-a-hover\";s:7:\"#FFFFFF\";s:21:\"background-action-bar\";s:7:\"#f7e8e2\";s:16:\"color-action-bar\";s:7:\"#a52335\";s:18:\"color-action-bar-a\";s:7:\"#000000\";s:24:\"color-action-bar-a-hover\";s:7:\"#5b5b5b\";s:23:\"color-action-bar-social\";s:7:\"#2a2b39\";s:29:\"color-action-bar-social-hover\";s:7:\"#000000\";s:28:\"mobile-background-action-bar\";s:7:\"#FFFFFF\";s:23:\"mobile-color-action-bar\";s:7:\"#222222\";s:25:\"mobile-color-action-bar-a\";s:7:\"#6d6d6d\";s:31:\"mobile-color-action-bar-a-hover\";s:7:\"#000000\";s:30:\"mobile-color-action-bar-social\";s:7:\"#bbbbbb\";s:36:\"mobile-color-action-bar-social-hover\";s:7:\"#777777\";s:11:\"color-theme\";s:7:\"#000000\";s:10:\"color-text\";s:7:\"#252525\";s:15:\"color-selection\";s:7:\"#000000\";s:7:\"color-a\";s:7:\"#6d6d6d\";s:13:\"color-a-hover\";s:7:\"#000000\";s:16:\"color-fancy-link\";s:7:\"#656B6F\";s:21:\"background-fancy-link\";s:7:\"#6d6d6d\";s:22:\"color-fancy-link-hover\";s:7:\"#6d6d6d\";s:27:\"background-fancy-link-hover\";s:7:\"#000000\";s:17:\"border-imageframe\";s:7:\"#f8f8f8\";s:26:\"background-imageframe-link\";s:7:\"#000000\";s:21:\"color-imageframe-link\";s:7:\"#ffffff\";s:21:\"color-imageframe-mask\";s:7:\"#ffffff\";s:20:\"background-highlight\";s:7:\"#000000\";s:8:\"color-hr\";s:7:\"#000000\";s:10:\"color-list\";s:7:\"#737E86\";s:10:\"color-note\";s:7:\"#a8a8a8\";s:28:\"background-highlight-section\";s:7:\"#000000\";s:18:\"color-footer-theme\";s:7:\"#000000\";s:17:\"background-footer\";s:7:\"#ffffff\";s:12:\"color-footer\";s:7:\"#000000\";s:20:\"color-footer-heading\";s:7:\"#000000\";s:17:\"color-footer-note\";s:7:\"#a8a8a8\";s:16:\"border-copyright\";s:21:\"rgba(255,255,255,0.1)\";s:14:\"color-footer-a\";s:7:\"#000000\";s:20:\"color-footer-a-hover\";s:7:\"#d1d1d1\";s:19:\"color-footer-social\";s:7:\"#000000\";s:25:\"color-footer-social-hover\";s:7:\"#ededed\";s:22:\"color-footer-backtotop\";s:7:\"#65666C\";s:27:\"background-footer-backtotop\";s:0:\"\";s:23:\"color-sliding-top-theme\";s:7:\"#000000\";s:22:\"background-sliding-top\";s:7:\"#545454\";s:17:\"color-sliding-top\";s:7:\"#cccccc\";s:19:\"color-sliding-top-a\";s:7:\"#6d6d6d\";s:25:\"color-sliding-top-a-hover\";s:7:\"#000000\";s:25:\"color-sliding-top-heading\";s:7:\"#ffffff\";s:22:\"color-sliding-top-note\";s:7:\"#a8a8a8\";s:8:\"color-h1\";s:7:\"#000000\";s:8:\"color-h2\";s:7:\"#000000\";s:8:\"color-h3\";s:7:\"#000000\";s:8:\"color-h4\";s:7:\"#000000\";s:8:\"color-h5\";s:7:\"#000000\";s:8:\"color-h6\";s:7:\"#000000\";s:9:\"color-tab\";s:7:\"#444444\";s:15:\"color-tab-title\";s:7:\"#000000\";s:16:\"color-blockquote\";s:7:\"#444444\";s:21:\"background-getintouch\";s:7:\"#000000\";s:17:\"color-contentlink\";s:7:\"#000000\";s:13:\"color-counter\";s:7:\"#000000\";s:13:\"color-iconbar\";s:7:\"#000000\";s:13:\"color-iconbox\";s:7:\"#000000\";s:15:\"color-list-icon\";s:7:\"#000000\";s:19:\"color-pricing-price\";s:7:\"#000000\";s:27:\"background-pricing-featured\";s:7:\"#000000\";s:22:\"background-progressbar\";s:7:\"#000000\";s:22:\"color-quickfact-number\";s:7:\"#000000\";s:27:\"background-slidingbox-title\";s:7:\"#000000\";s:27:\"background-trailer-subtitle\";s:7:\"#000000\";s:10:\"color-form\";s:7:\"#252525\";s:15:\"background-form\";s:7:\"#f9f9f9\";s:11:\"border-form\";s:7:\"#a2a2a2\";s:22:\"color-form-placeholder\";s:7:\"#929292\";s:16:\"color-form-focus\";s:7:\"#252525\";s:21:\"background-form-focus\";s:7:\"#ffffff\";s:17:\"border-form-focus\";s:7:\"#a2a2a2\";s:28:\"color-form-placeholder-focus\";s:7:\"#929292\";s:17:\"form-border-width\";s:3:\"1px\";s:18:\"form-border-radius\";s:3:\"0px\";s:16:\"form-transparent\";s:3:\"100\";s:12:\"font-content\";s:7:\"Poppins\";s:9:\"font-menu\";s:7:\"Poppins\";s:10:\"font-title\";s:7:\"Poppins\";s:13:\"font-headings\";s:7:\"Poppins\";s:19:\"font-headings-small\";s:7:\"Poppins\";s:15:\"font-blockquote\";s:7:\"Poppins\";s:15:\"font-decorative\";s:7:\"Poppins\";s:11:\"font-weight\";a:8:{s:9:\"post-meta\";s:1:\"1\";i:300;s:3:\"300\";i:400;s:3:\"400\";s:9:\"400italic\";s:9:\"400italic\";i:500;s:3:\"500\";i:600;s:3:\"600\";i:700;s:3:\"700\";s:9:\"700italic\";s:9:\"700italic\";}s:11:\"font-subset\";s:0:\"\";s:17:\"font-size-content\";a:4:{s:4:\"size\";s:2:\"15\";s:11:\"line_height\";s:2:\"28\";s:12:\"weight_style\";s:3:\"300\";s:14:\"letter_spacing\";s:1:\"0\";}s:13:\"font-size-big\";a:4:{s:4:\"size\";s:2:\"16\";s:11:\"line_height\";s:2:\"29\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:14:\"font-size-menu\";a:3:{s:4:\"size\";s:2:\"15\";s:12:\"weight_style\";s:3:\"500\";s:14:\"letter_spacing\";s:1:\"0\";}s:15:\"font-size-title\";a:4:{s:4:\"size\";s:2:\"50\";s:11:\"line_height\";s:2:\"64\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:22:\"font-size-single-intro\";a:4:{s:4:\"size\";s:2:\"60\";s:11:\"line_height\";s:2:\"64\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h1\";a:4:{s:4:\"size\";s:2:\"60\";s:11:\"line_height\";s:2:\"64\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"1\";}s:12:\"font-size-h2\";a:4:{s:4:\"size\";s:2:\"50\";s:11:\"line_height\";s:2:\"55\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"1\";}s:12:\"font-size-h3\";a:4:{s:4:\"size\";s:2:\"35\";s:11:\"line_height\";s:2:\"42\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"1\";}s:12:\"font-size-h4\";a:4:{s:4:\"size\";s:2:\"24\";s:11:\"line_height\";s:2:\"32\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"1\";}s:12:\"font-size-h5\";a:4:{s:4:\"size\";s:2:\"17\";s:11:\"line_height\";s:2:\"28\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h6\";a:4:{s:4:\"size\";s:2:\"15\";s:11:\"line_height\";s:2:\"26\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:11:\"font-custom\";s:0:\"\";s:16:\"font-custom-woff\";s:0:\"\";s:15:\"font-custom-ttf\";s:0:\"\";s:12:\"font-custom2\";s:0:\"\";s:17:\"font-custom2-woff\";s:0:\"\";s:16:\"font-custom2-ttf\";s:0:\"\";s:9:\"translate\";s:1:\"1\";s:28:\"translate-search-placeholder\";s:17:\"Enter your search\";s:24:\"translate-search-results\";s:18:\"results found for:\";s:14:\"translate-home\";s:4:\"Home\";s:14:\"translate-prev\";s:9:\"Prev page\";s:14:\"translate-next\";s:9:\"Next page\";s:19:\"translate-load-more\";s:9:\"Load more\";s:17:\"translate-wpml-no\";s:39:\"No translations available for this page\";s:15:\"translate-share\";s:5:\"Share\";s:16:\"translate-before\";s:6:\"Before\";s:15:\"translate-after\";s:5:\"After\";s:14:\"translate-days\";s:4:\"days\";s:15:\"translate-hours\";s:5:\"hours\";s:17:\"translate-minutes\";s:7:\"minutes\";s:17:\"translate-seconds\";s:7:\"seconds\";s:16:\"translate-filter\";s:9:\"Filter by\";s:17:\"translate-authors\";s:7:\"Authors\";s:13:\"translate-all\";s:8:\"Show all\";s:18:\"translate-item-all\";s:3:\"All\";s:19:\"translate-published\";s:12:\"Published by\";s:12:\"translate-at\";s:2:\"on\";s:20:\"translate-categories\";s:10:\"Categories\";s:14:\"translate-tags\";s:4:\"Tags\";s:18:\"translate-readmore\";s:9:\"Read more\";s:14:\"translate-like\";s:15:\"Do you like it?\";s:17:\"translate-related\";s:13:\"Related posts\";s:16:\"translate-client\";s:6:\"Client\";s:14:\"translate-date\";s:4:\"Date\";s:17:\"translate-website\";s:7:\"Website\";s:14:\"translate-view\";s:12:\"View website\";s:14:\"translate-task\";s:4:\"Task\";s:22:\"translate-commented-on\";s:12:\"commented on\";s:19:\"translate-404-title\";s:18:\"Ooops... Error 404\";s:22:\"translate-404-subtitle\";s:62:\"We are sorry, but the page you are looking for does not exist.\";s:18:\"translate-404-text\";s:46:\"Please check entered address and try again or \";s:17:\"translate-404-btn\";s:14:\"go to homepage\";s:22:\"translate-search-title\";s:8:\"Ooops...\";s:25:\"translate-search-subtitle\";s:21:\"No results found for:\";s:10:\"custom-css\";s:0:\"\";s:9:\"custom-js\";s:0:\"\";}","yes"),
("404","wc_blocks_use_blockified_product_grid_block_as_template","no","yes"),
("405","woocommerce_maybe_regenerate_images_hash","991b1ca641921cf0f5baf7a2fe85861b","yes"),
("412","envato_purchase_code_7758048","********-****-****-****-************","no"),
("459","revslider-valid","true","yes"),
("460","revslider-code","activated","yes"),
("461","revslider-temp-active-notice","false","yes"),
("462","revslider_servers","a:3:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-c.tools\";}","yes"),
("463","revslider_server_refresh","1760718614","yes"),
("464","revslider-update-check-short","1761850804","yes"),
("465","revslider-connection","1","yes"),
("466","revslider-update-hash","862066cad04991a9964d407d3d8c6c90","yes"),
("467","revslider-latest-version","6.7.38","yes"),
("468","revslider-stable-version","4.2.0","yes"),
("469","revslider-notices","a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-a.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-a.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}","yes"),
("470","revslider-additions","O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}","yes"),
("471","rs-addons-counter","35","yes"),
("472","revslider-addons","O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"493\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2023-11-16\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"507\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-10-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-a.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}","yes");

INSERT IGNORE INTO `wp_options` VALUES 
("474","revslider-library-check","1760675937","yes"),
("475","revslider-library-hash","324e6ba47fb68dfb7f1bd5b0b203bdc5","yes"),
("476","rs-library","a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("477","revslider-templates-check","1761670434","yes"),
("478","revslider-templates-hash","42da1d3fd549004a80ff524485ae9caa","yes"),
("479","rs-templates-new","","off"),
("480","rs-templates","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