<?php
/**
 * Plugin Name: Noindex and Nofollow Except Home
 * Description: Adds a noindex, nofollow meta tag to all pages except the home page. The home page will have an index, nofollow meta tag.
 * Version: 1.0
 * Author: Depozitul.shop
 */

function add_custom_meta_tags() {
    if (is_front_page() || is_home()) {
        echo '<meta name="robots" content="index, nofollow">';
    } else {
        echo '<meta name="robots" content="noindex, nofollow">';
    }
}

add_action('wp_head', 'add_custom_meta_tags');
?>
