<?php if ( ! defined('ETHEME_FW')) exit('No direct script access allowed');
/**
 * Template "Header" for ET_Setup_Wizard.
 * @package ET_Setup_Wizard
 * @since 9.5.0
 * @version 1.0.0
 */

$is_activated = etheme_is_activated();

 if(
    isset($_GET['step'])
    && $_GET['step'] == 'basic-updated'
){
    if (isset($_POST['site_title'])){
        update_option('blogname', esc_html($_POST['site_title']));
    }

    if (isset($_POST['site_tagline'])){
        update_option('blogdescription', esc_html($_POST['site_tagline']));
    }

    if ($is_activated){
        wp_safe_redirect( ET_Setup_Wizard::get_controls_url('child-theme') );
    } else {
        wp_safe_redirect( ET_Setup_Wizard::get_controls_url('register') );
    }

    exit;
}

if(
    isset($_GET['step'])
    && $_GET['step'] == 'language-setuped'
){
    $language = (isset($_POST['language']) && !empty($_POST['language'])) ? $_POST['language'] : false;
    if($language){
        ETC_Languages::setup_translation($language);
        update_option( 'etheme_builtin_language', true);
    }


    // if ($is_activated){
        wp_safe_redirect( ET_Setup_Wizard::get_controls_url('basic') );
    // } else {
        // wp_safe_redirect( ET_Setup_Wizard::get_controls_url('register') );
    // }

    exit;
}


?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="UTF-8">
    <?php printf('<%1s>%2s</%3s>', 'title', 'XStore Setup Wizard', 'title');?>
    <link rel="stylesheet" id="dashicons-css" href="<?php echo includes_url('css/dashicons.min.css'); ?>" type="text/css" media="all">
    <link rel="stylesheet" href="<?php echo ETHEME_CODE_CSS.'xstore-panel-nav-icons.css'; ?>">
    <link rel="stylesheet" href="<?php echo ETHEME_CODE_CSS.'etheme_admin_backend-styles.css'; ?>">
    <link rel="stylesheet" href="<?php echo ETHEME_CODE_CSS.'et_admin-panel-styles.css'; ?>">
    <?php
        if ( is_rtl() ) { ?>
            <link rel="stylesheet" href="<?php echo ETHEME_CODE_CSS.'etheme_admin_backend-styles-rtl.css'; ?>">
        <?php }
    ?>
    <link rel="stylesheet" href="<?php echo esc_attr(get_template_directory_uri()); ?>/framework/setup-wizard/assets/css/style.css">
    <?php if (isset($_GET['step']) && $_GET['step'] == 'welcome') :
        foreach (array('car-parts', 'electronic-mega-market', 'minimal-fashion02') as $demo) { ?>
            <link rel="preload" as="image" href="<?php echo apply_filters('etheme_protocol_url', ETHEME_BASE_URL . 'import/xstore-demos/' . esc_attr( $demo ) . '/screenshot.jpg'); ?>">
        <?php }
    endif; ?>
    <script src="<?php echo includes_url('/js/jquery/jquery.js'); ?>"></script>
    <script src="<?php echo ETHEME_BASE_URI . 'js/libs/jquery.lazyload.js'; ?>" id="jquery_lazyload-js"></script>
    <script type="text/javascript">
        var ajaxurl = '<?php echo esc_js( admin_url( 'admin-ajax.php', 'relative' ) ); ?>',
            adminurl = '<?php echo esc_js( admin_url() ); ?>';
    </script>
</head>
<?php $dark_light_default = get_option('et_panel_dark_light_default', 'light'); ?>
<body class="xstore-wizard" data-mode="<?php echo esc_attr($dark_light_default); ?>">
<div class="setup-wrapper">
	<header>
            <div class="header-inner">
                <svg width="143" height="28" viewBox="0 0 143 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M20.256 13.419L29.2503 0.129883H25.7477C25.6166 0.129883 25.5005 0.152814 25.3993 0.210153C25.3506 0.229259 25.3057 0.259841 25.2645 0.294226C25.1296 0.405056 25.0097 0.546491 24.8936 0.72994L18.8063 9.95243L18.2107 10.8506C18.0007 11.1711 18.1885 10.8896 17.7609 11.5085L17.3264 12.1818L16.4575 13.419L25.7477 27.8012C25.8001 27.8088 25.8563 27.8126 25.9163 27.8126H29.5537L20.256 13.419Z" fill="currentColor"/>
                    <path d="M9.43435 13.5947L0.478421 0.129578H4.13264C4.39786 0.129578 4.59339 0.17474 4.7196 0.264691C4.84563 0.355016 4.9594 0.483785 5.06055 0.650997L12.142 11.74C12.2302 11.4694 12.3628 11.1734 12.5396 10.8513L19.2238 0.728631C19.3372 0.548355 19.4601 0.403537 19.5929 0.293804C19.7253 0.184444 19.8863 0.129578 20.0758 0.129578H23.5786L14.5846 13.4207L23.8815 27.8129H20.2459C19.9683 27.8129 19.7506 27.739 19.5929 27.5909C19.4349 27.4431 19.3057 27.2788 19.2048 27.0982L11.9337 15.4877C11.8453 15.7583 11.7317 16.0159 11.5929 16.2604L4.51145 27.0982C4.39786 27.2788 4.26818 27.4431 4.12331 27.5909C3.9779 27.739 3.77303 27.8129 3.50781 27.8129H0.0996094L9.43435 13.5947Z" fill="currentColor"/>
                    <path d="M46.1254 4.67578C46.0147 4.8649 45.8967 5.00664 45.7735 5.10143C45.6493 5.19576 45.4885 5.24316 45.2911 5.24316C45.0802 5.24316 44.8363 5.13606 44.5585 4.92141C44.2807 4.70722 43.9278 4.4707 43.5017 4.2123C43.0747 3.9539 42.5619 3.71738 41.9625 3.50273C41.363 3.28808 40.6367 3.18098 39.7836 3.18098C38.9796 3.18098 38.2685 3.29173 37.6512 3.5123C37.0321 3.73287 36.5166 4.03229 36.1026 4.411C35.6881 4.78925 35.3763 5.23359 35.1659 5.74446C34.9555 6.25533 34.851 6.80722 34.851 7.40013C34.851 8.15709 35.0332 8.78463 35.3977 9.28274C35.7622 9.78086 36.2446 10.207 36.8445 10.5597C37.4439 10.9129 38.1238 11.2191 38.884 11.4775C39.6442 11.7359 40.4232 12.0044 41.2201 12.2814C42.0178 12.559 42.7968 12.8712 43.5571 13.218C44.3173 13.5652 44.9971 14.0032 45.5966 14.5327C46.1969 15.0628 46.6784 15.7126 47.0438 16.4814C47.4083 17.2512 47.5905 18.1973 47.5905 19.3197C47.5905 20.5055 47.3922 21.6184 46.9973 22.6588C46.6016 23.6997 46.0236 24.6048 45.2634 25.3741C44.5031 26.1434 43.5696 26.749 42.4627 27.1902C41.3559 27.6318 40.0989 27.8523 38.6892 27.8523C36.9713 27.8523 35.404 27.5342 33.9885 26.8971C32.573 26.26 31.3647 25.3996 30.3633 24.3145L31.4018 22.5736C31.5005 22.4351 31.6211 22.3184 31.7632 22.2236C31.9052 22.1293 32.0629 22.0819 32.2362 22.0819C32.4957 22.0819 32.7923 22.2236 33.1264 22.5075C33.4601 22.7915 33.8772 23.1036 34.378 23.4441C34.8787 23.7845 35.4844 24.0967 36.1955 24.3806C36.9061 24.6645 37.7745 24.8062 38.8009 24.8062C39.6532 24.8062 40.4143 24.6868 41.0816 24.4467C41.749 24.2074 42.3144 23.8697 42.7781 23.4345C43.2417 22.9997 43.5973 22.4793 43.8447 21.8736C44.0922 21.2684 44.2155 20.5939 44.2155 19.8493C44.2155 19.0294 44.0332 18.3581 43.6687 17.8345C43.3034 17.3113 42.8245 16.8729 42.2314 16.5193C41.6382 16.1665 40.961 15.8667 40.2008 15.6206C39.4405 15.3749 38.6616 15.1225 37.8647 14.8641C37.0669 14.6057 36.2879 14.3058 35.5277 13.9654C34.7675 13.6249 34.0908 13.1833 33.4971 12.641C32.904 12.0987 32.4247 11.4206 32.0602 10.6071C31.6953 9.79362 31.513 8.78782 31.513 7.58925C31.513 6.63086 31.6953 5.7039 32.0602 4.80794C32.4247 3.91243 32.9531 3.11809 33.6454 2.42402C34.3378 1.73086 35.194 1.17532 36.2138 0.75924C37.234 0.34316 38.4043 0.134892 39.7282 0.134892C41.2112 0.134892 42.5655 0.374605 43.7893 0.854032C45.0132 1.33346 46.0817 2.02708 46.9973 2.93489L46.1254 4.67578Z" fill="currentColor"/>
                    <path d="M70.269 0.437496V3.52142H61.684V27.5497H58.0865V3.52142H49.463V0.437496H70.269Z" fill="currentColor"/>
                    <path d="M96.9165 14.0032C96.9165 16.0339 96.602 17.8978 95.9713 19.5941C95.3406 21.2903 94.4509 22.7505 93.3011 23.9741C92.1514 25.1973 90.7694 26.1465 89.156 26.8215C87.5426 27.4964 85.7595 27.8337 83.8067 27.8337C81.8529 27.8337 80.0725 27.4964 78.4654 26.8215C76.8582 26.1465 75.4798 25.1973 74.3301 23.9741C73.1804 22.7505 72.2906 21.2903 71.6599 19.5941C71.0301 17.8978 70.7147 16.0339 70.7147 14.0032C70.7147 11.9725 71.0301 10.109 71.6599 8.4123C72.2906 6.71608 73.1804 5.25273 74.3301 4.02272C75.4798 2.79316 76.8582 1.8375 78.4654 1.15664C80.0725 0.475321 81.8529 0.134892 83.8067 0.134892C85.7595 0.134892 87.5426 0.475321 89.156 1.15664C90.7694 1.8375 92.1514 2.79316 93.3011 4.02272C94.4509 5.25273 95.3406 6.71608 95.9713 8.4123C96.602 10.109 96.9165 11.9725 96.9165 14.0032ZM93.227 14.0032C93.227 12.3384 93.0045 10.8436 92.5588 9.51927C92.1139 8.19492 91.4832 7.07565 90.6676 6.161C89.8519 5.24635 88.8621 4.54316 87.7008 4.05143C86.5385 3.55924 85.2405 3.3136 83.8067 3.3136C82.3845 3.3136 81.0927 3.55924 79.9305 4.05143C78.7682 4.54316 77.7766 5.24635 76.9547 6.161C76.132 7.07565 75.4986 8.19492 75.0537 9.51927C74.6088 10.8436 74.3864 12.3384 74.3864 14.0032C74.3864 15.668 74.6088 17.1596 75.0537 18.4775C75.4986 19.796 76.132 20.912 76.9547 21.8267C77.7766 22.7413 78.7682 23.4413 79.9305 23.9267C81.0927 24.4125 82.3845 24.6549 83.8067 24.6549C85.2405 24.6549 86.5385 24.4125 87.7008 23.9267C88.8621 23.4413 89.8519 22.7413 90.6676 21.8267C91.4832 20.912 92.1139 19.796 92.5588 18.4775C93.0045 17.1596 93.227 15.668 93.227 14.0032Z" fill="currentColor"/>
                    <path d="M105.78 16.2358V27.5497H102.202V0.437496H109.712C111.393 0.437496 112.846 0.611129 114.07 0.957939C115.293 1.30475 116.304 1.80651 117.102 2.46185C117.898 3.1181 118.489 3.90924 118.872 4.83665C119.255 5.7636 119.448 6.8013 119.448 7.94882C119.448 8.90768 119.299 9.80273 119.003 10.6353C118.705 11.468 118.275 12.2154 117.714 12.8775C117.151 13.5397 116.465 14.1044 115.655 14.5706C114.845 15.0377 113.928 15.3909 112.901 15.6301C113.346 15.8949 113.742 16.28 114.088 16.7845L121.839 27.5497H118.65C117.994 27.5497 117.513 27.2913 117.203 26.7741L110.305 17.0871C110.095 16.7845 109.866 16.5667 109.619 16.4345C109.372 16.3019 109.001 16.2358 108.507 16.2358H105.78ZM105.78 13.568H109.545C110.595 13.568 111.52 13.439 112.317 13.1801C113.115 12.9217 113.782 12.5558 114.32 12.0827C114.858 11.6097 115.262 11.0455 115.535 10.3893C115.806 9.73392 115.943 9.00839 115.943 8.2136C115.943 6.59941 115.42 5.38216 114.375 4.5623C113.331 3.74244 111.776 3.33229 109.712 3.33229H105.78V13.568Z" fill="currentColor"/>
                    <path d="M142.089 0.437496V3.42708H129.331V12.4327H139.66V15.3084H129.331V24.5606H142.089V27.5497H125.715V0.437496H142.089Z" fill="currentColor"/>
                </svg>
                <?php if ( isset($_GET['step']) && $_GET['step'] == 'register'): ?>
                    <a href="https://1.envato.market/2rXmmA" target="_blank" class="setup-button setup-button-outline no-loader" style="margin-inline-start: auto;">
                        <?php esc_html_e('Get license', 'xstore'); ?>
                    </a>
                <?php endif; ?>
                <div class="et_panel-dark-light-switcher">
                    <span class="switcher <?php echo esc_attr($dark_light_default); ?>-mode">
                        <span class="on">Light</span>
                        <span class="off">Dark</span>
                        <i>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 35 35" style="enable-background:new 0 0 35 35;" xml:space="preserve" class="light" width="1em" height="1em" fill="currentColor">
                              <g id="Sun">
                                  <g>
                                      <path style="fill-rule:evenodd;clip-rule:evenodd;" d="M6,17.5C6,16.672,5.328,16,4.5,16h-3C0.672,16,0,16.672,0,17.5    S0.672,19,1.5,19h3C5.328,19,6,18.328,6,17.5z M7.5,26c-0.414,0-0.789,0.168-1.061,0.439l-2,2C4.168,28.711,4,29.086,4,29.5    C4,30.328,4.671,31,5.5,31c0.414,0,0.789-0.168,1.06-0.44l2-2C8.832,28.289,9,27.914,9,27.5C9,26.672,8.329,26,7.5,26z M17.5,6    C18.329,6,19,5.328,19,4.5v-3C19,0.672,18.329,0,17.5,0S16,0.672,16,1.5v3C16,5.328,16.671,6,17.5,6z M27.5,9    c0.414,0,0.789-0.168,1.06-0.439l2-2C30.832,6.289,31,5.914,31,5.5C31,4.672,30.329,4,29.5,4c-0.414,0-0.789,0.168-1.061,0.44    l-2,2C26.168,6.711,26,7.086,26,7.5C26,8.328,26.671,9,27.5,9z M6.439,8.561C6.711,8.832,7.086,9,7.5,9C8.328,9,9,8.328,9,7.5    c0-0.414-0.168-0.789-0.439-1.061l-2-2C6.289,4.168,5.914,4,5.5,4C4.672,4,4,4.672,4,5.5c0,0.414,0.168,0.789,0.439,1.06    L6.439,8.561z M33.5,16h-3c-0.828,0-1.5,0.672-1.5,1.5s0.672,1.5,1.5,1.5h3c0.828,0,1.5-0.672,1.5-1.5S34.328,16,33.5,16z     M28.561,26.439C28.289,26.168,27.914,26,27.5,26c-0.828,0-1.5,0.672-1.5,1.5c0,0.414,0.168,0.789,0.439,1.06l2,2    C28.711,30.832,29.086,31,29.5,31c0.828,0,1.5-0.672,1.5-1.5c0-0.414-0.168-0.789-0.439-1.061L28.561,26.439z M17.5,29    c-0.829,0-1.5,0.672-1.5,1.5v3c0,0.828,0.671,1.5,1.5,1.5s1.5-0.672,1.5-1.5v-3C19,29.672,18.329,29,17.5,29z M17.5,7    C11.71,7,7,11.71,7,17.5S11.71,28,17.5,28S28,23.29,28,17.5S23.29,7,17.5,7z M17.5,25c-4.136,0-7.5-3.364-7.5-7.5    c0-4.136,3.364-7.5,7.5-7.5c4.136,0,7.5,3.364,7.5,7.5C25,21.636,21.636,25,17.5,25z"></path>
                                  </g>
                              </g>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve" class="dark" width="1em" height="1em" fill="currentColor">
                              <path d="M96.76,66.458c-0.853-0.852-2.15-1.064-3.23-0.534c-6.063,2.991-12.858,4.571-19.655,4.571  C62.022,70.495,50.88,65.88,42.5,57.5C29.043,44.043,25.658,23.536,34.076,6.47c0.532-1.08,0.318-2.379-0.534-3.23  c-0.851-0.852-2.15-1.064-3.23-0.534c-4.918,2.427-9.375,5.619-13.246,9.491c-9.447,9.447-14.65,22.008-14.65,35.369  c0,13.36,5.203,25.921,14.65,35.368s22.008,14.65,35.368,14.65c13.361,0,25.921-5.203,35.369-14.65  c3.872-3.871,7.064-8.328,9.491-13.246C97.826,68.608,97.611,67.309,96.76,66.458z"></path>
                            </svg>
                        </i>
                    </span>
                </div>
            </div>

        <span class="installation-progress">
            <span style="width: <?php echo ET_Setup_Wizard::calculate_progress($_GET['step']??'welcome', true); ?>%;" data-active-percent="<?php echo ET_Setup_Wizard::calculate_progress($_GET['step']??'welcome'); ?>" class="installation-progress-value"></span>
        </span>
	</header>
	<main>
        <div class="container">